<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<xsl:template match="/operations">
		<html>
	        <body>
				<table border="0" width="100%" hspace="0" vspace="0" cellspacing="0" cellpadding="2">

		            <xsl:apply-templates select="operation" />

				</table>
		    </body>
	    </html>
	</xsl:template>

    <xsl:template match="operation">
		<xsl:if test="@name='*rbXmlErrorReportTable*'">
			<xsl:call-template name="rbXmlErrorReportTable"/>
		</xsl:if>
		<xsl:if test="@name='*rbXmlErrorReportEntry*'">
			<xsl:call-template name="rbXmlErrorReportEntry"/>
		</xsl:if>
		<xsl:if test="@name!='*rbXmlErrorReportTable*'">
			<xsl:if test="@name!='*rbXmlErrorReportEntry*'">
				<xsl:call-template name="report"/>
			</xsl:if>
		</xsl:if>
    </xsl:template>

	<xsl:template name="report">
		<tr>
			<td align="left" bgcolor="#c9c9c9" colspan="2">
				<font size="3" face="Verdana, Arial, Helvetica, sans-serif"><b><xsl:value-of select="@name"/></b></font>
			</td>
			<td align="right" bgcolor="#c9c9c9">
				<font size="3" face="Verdana, Arial, Helvetica, sans-serif"><b><xsl:value-of select="@status"/></b></font>
			</td>
		</tr>
		<xsl:if test="@message!='*null*'">
		<tr>
			<td colspan="3">
				<font size="2" face="Verdana, Arial, Helvetica, sans-serif"><xsl:value-of select="@message"/></font>
			</td>
		</tr>
		</xsl:if>
		<xsl:apply-templates select="operation" />
	</xsl:template>

	<xsl:template name="rbXmlErrorReportTable">
		<tr>
			<td colspan="3">
				<table border="1">
					<tr bgcolor="Silver">
						<th>
							<xsl:value-of select="@idx"/>
						</th>
						<th>
							<xsl:value-of select="@lineNo"/>
						</th>
						<th>
							<xsl:value-of select="@folderType"/>
						</th>
						<th>
							<xsl:value-of select="@elementType"/>
						</th>
						<th>
							<xsl:value-of select="@errorType"/>
						</th>
					</tr>
					<xsl:apply-templates select="operation" />
				</table>
			</td>
		</tr>
	</xsl:template>

	<xsl:template name="rbXmlErrorReportEntry">
		<tr>
			<td>
				<xsl:value-of select="@rbXmlErrorIdx"/>
			</td>
			<td>
				<xsl:value-of select="@rbXmlFileLineNumber"/>
			</td>
			<td>
				<xsl:value-of select="@rbXmlFolderType"/>
			</td>
			<td>
				<xsl:value-of select="@rbXmlElementType"/>
			</td>
			<td>
				<xsl:value-of select="@rbXmlErrorType"/>
			</td>
		</tr>
		<xsl:apply-templates select="operation" />
	</xsl:template>

</xsl:stylesheet>