<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="xhtml" omit-xml-declaration="yes" />

    <xsl:template match="report">
        <html>
            <head>
                <title>
                    <xsl:apply-templates mode="match_title" select="header"></xsl:apply-templates>
                </title>
            </head>
            <body>
                <xsl:apply-templates mode="match_header" select="header"></xsl:apply-templates>
                <xsl:apply-templates mode="match_report_scanned" select="data/scanned"></xsl:apply-templates>
                <xsl:apply-templates mode="match_report_discovered" select="data/discovered"></xsl:apply-templates>
                <xsl:apply-templates mode="gigi" select="data/range"></xsl:apply-templates>
                <xsl:apply-templates mode="match_failed" select="data/failed"></xsl:apply-templates>
            </body>
        </html>
    </xsl:template>

    <xsl:template mode="gigi" match="/report/data/range">
        <h3 align="left">
        <xsl:value-of select="range-start"/>
            <xsl:if test="range-type='IpRange'">
                <xsl:text> .. </xsl:text>
            </xsl:if>
            <xsl:if test="range-type='Subnet'">
                <xsl:text>/</xsl:text>
            </xsl:if>
         <xsl:value-of select="range-end"/></h3>
        <table border="2" align="center" width="100%">
            <tr>
                <th bgcolor="#3A6EA5"><font color="#FFFFFF">IP address</font></th>
                <th bgcolor="#3A6EA5"><font color="#FFFFFF">Read community</font></th>
                <th bgcolor="#3A6EA5"><font color="#FFFFFF">Write community</font></th>
                <th bgcolor="#3A6EA5"><font color="#FFFFFF">Response</font></th>
            </tr>
            <xsl:apply-templates mode="match_data" select="row"></xsl:apply-templates>
        </table>
    </xsl:template>

    <xsl:template mode="match_title" match="header">
        <xsl:value-of select="title"/>
    </xsl:template>

    <xsl:template mode="match_header" match="header">
        <h1 align="center"><xsl:value-of select="title"/></h1>
        <h2 align="center"><xsl:value-of select="date"/></h2>
    </xsl:template>

    <xsl:template mode="match_data" match="row">
        <tr>
            <td align="center">
                <xsl:value-of select="ip"/>
                <xsl:text disable-output-escaping="yes">&amp;nbsp</xsl:text>
            </td>
            <td align="center">
                <xsl:value-of select="read-community"/>
                <xsl:text disable-output-escaping="yes">&amp;nbsp</xsl:text>
            </td>
            <td align="center">
                <xsl:value-of select="write-community"/>
                <xsl:text disable-output-escaping="yes">&amp;nbsp</xsl:text>
            </td>
            <td>
                <xsl:value-of select="response"/>
                <xsl:text disable-output-escaping="yes">&amp;nbsp</xsl:text>
            </td>
        </tr>
    </xsl:template>

    <xsl:template mode="match_report_scanned" match="/report/data/scanned">
        <b>Total scanned : <xsl:value-of select="."/></b><xsl:text disable-output-escaping="yes">&lt;br&gt;</xsl:text>
    </xsl:template>

    <xsl:template mode="match_report_discovered" match="/report/data/discovered">
        <b>Discovered : <xsl:value-of select="."/></b><xsl:text disable-output-escaping="yes">&lt;br&gt;</xsl:text>
    </xsl:template>

    <xsl:template mode="match_failed" match="/report/data/failed">
	    <b>Failed : <xsl:value-of select="."/></b><xsl:text disable-output-escaping="yes">&lt;br&gt;</xsl:text>
    </xsl:template>

    <xsl:template match="*">
    </xsl:template>

</xsl:stylesheet>
