/*
 * Decompiled with CFR 0.152.
 */
package com.tftp;

import com.tftp.AvTftpEndTransferEvent;
import com.tftp.AvTftpErrorEvent;
import com.tftp.AvTftpEventListener;
import com.tftp.AvTftpStartTransferEvent;
import com.tftp.AvTftpTransferEvent;
import com.tftp.AvUdpData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class AvTftpClient {
    public static final String TFTP_netascii = "netascii";
    public static final String TFTP_octet = "octet";
    static final short TFTP_RRQ = 1;
    static final short TFTP_WRQ = 2;
    static final short TFTP_DATA = 3;
    static final short TFTP_ACK = 4;
    static final short TFTP_ERROR = 5;
    private String remoteHost;
    private String remoteFileName;
    private String localFileName;
    private String mode = "octet";
    private int maxPacketSize = 516;
    private int remotePort = 69;
    private int retries = 3;
    private int timeOut = 3000;
    private Vector listeners = null;

    DatagramPacket buildRequestPacket(short opcode, String filename, String mode, InetAddress server, int remotePort, long fileSize) {
        int packetSize = 4 + filename.length() + mode.length();
        AvUdpData reqData = new AvUdpData(packetSize);
        int offset = 0;
        offset += reqData.putInt(opcode, offset);
        offset += reqData.putString(filename, offset);
        offset += reqData.putString(mode, offset);
        return reqData.mkPacket(server, remotePort);
    }

    DatagramPacket buildPutAckPacket() {
        AvUdpData ackData = new AvUdpData(this.maxPacketSize);
        return ackData.mkPacket();
    }

    DatagramPacket buildGetDataPacket(int port, InetAddress server) {
        AvUdpData dataObj = new AvUdpData(this.maxPacketSize);
        DatagramPacket dataPacket = dataObj.mkPacket();
        dataPacket.setPort(port);
        dataPacket.setAddress(server);
        dataPacket.setLength(this.maxPacketSize);
        return dataPacket;
    }

    DatagramPacket buildGetAckPacket(int port, InetAddress server, int ackPacketNum) {
        AvUdpData ackData = new AvUdpData(4);
        ackData.putInt(4, 0);
        ackData.putInt(ackPacketNum, 2);
        DatagramPacket ackPacket = ackData.mkPacket(server, port);
        return ackPacket;
    }

    DatagramPacket buildPutDataPacket(int port, InetAddress server, int blockNum, byte[] data, int dataLength) {
        AvUdpData dataObj = new AvUdpData(dataLength);
        dataObj.setData(data);
        dataObj.putInt(3, 0);
        dataObj.putInt(blockNum, 2);
        DatagramPacket dataPacket = dataObj.mkPacket();
        dataPacket.setPort(port);
        dataPacket.setAddress(server);
        dataPacket.setLength(dataLength);
        return dataPacket;
    }

    public void putFile() throws Exception {
        URL url = new URL("file", "", this.localFileName);
        File inFile = new File(url.getPath());
        if (!inFile.exists()) {
            throw new FileNotFoundException("Local file does not exist: " + this.localFileName);
        }
        long fileSize = inFile.length();
        this.fireStartTransfer(fileSize);
        InputStream inFileStream = url.openStream();
        InetAddress server = InetAddress.getByName(this.remoteHost);
        DatagramSocket sock = new DatagramSocket();
        DatagramPacket reqPacket = this.buildRequestPacket((short)2, this.remoteFileName, this.mode, server, this.remotePort, fileSize);
        sock.setSoTimeout(this.timeOut);
        try {
            sock.send(reqPacket);
        }
        catch (Exception e) {
            this.fireError("Error on Sending WRQ Packet: " + e);
            return;
        }
        boolean done = false;
        boolean lastPacket = false;
        DatagramPacket ackPacket = this.buildPutAckPacket();
        byte[] data = new byte[this.maxPacketSize];
        int dataLength = this.maxPacketSize;
        int packetNum = 0;
        int tryNum = 1;
        int totalBytes = 0;
        int retransmitions = 0;
        DatagramPacket currentPacket = reqPacket;
        while (!done) {
            try {
                sock.receive(ackPacket);
            }
            catch (InterruptedIOException e) {
                if (tryNum > this.retries) {
                    this.fireError("Error in recieve ACK: " + e.getMessage());
                    return;
                }
                try {
                    sock.send(currentPacket);
                }
                catch (Exception ex) {
                    this.fireError("Error on Sending Data Packet: " + ex);
                    return;
                }
                ++tryNum;
                continue;
            }
            catch (IOException e) {
                this.fireError("Error in recieve ACK: " + e.getMessage());
                return;
            }
            AvUdpData udpData = new AvUdpData(ackPacket);
            short status = udpData.getByte(1);
            int ackPacketNum = udpData.getInt(2);
            if (status == 4) {
                if (packetNum != ackPacketNum) {
                    if (packetNum > ackPacketNum) {
                        ++retransmitions;
                        continue;
                    }
                    this.fireError("Invalid Acknowledge Packet Number. Expected: " + packetNum + ". Recieved: " + ackPacketNum);
                    return;
                }
                this.fireTransfer(totalBytes, packetNum);
                this.remotePort = ackPacket.getPort();
                if (this.remotePort == 0) {
                    this.fireError("Failed to Set Remote Port.");
                    return;
                }
                ++packetNum;
            } else {
                if (status == 5) {
                    this.fireError("Error Packet Retrieved: " + this.getErrorString(udpData));
                    return;
                }
                this.fireError("Unknown Packet Recieved.");
                return;
            }
            if (lastPacket) {
                done = true;
                continue;
            }
            try {
                dataLength = inFileStream.read(data, 4, 512);
            }
            catch (IOException e) {
                this.fireError("Failed to read DATA packet from file: " + e);
                return;
            }
            if (dataLength < 512) {
                lastPacket = true;
                if (dataLength < 0) {
                    dataLength = 0;
                }
            }
            DatagramPacket dataPacket = this.buildPutDataPacket(this.remotePort, server, packetNum, data, dataLength + 4);
            try {
                sock.send(dataPacket);
            }
            catch (Exception e) {
                this.fireError("Error on Sending Data Packet: " + e);
                return;
            }
            currentPacket = dataPacket;
            totalBytes += dataLength;
            tryNum = 1;
        }
        inFileStream.close();
        sock.close();
        this.fireEndTransfer(retransmitions);
    }

    public void getFile() throws Exception {
        this.fireStartTransfer(0L);
        FileOutputStream outFileStream = new FileOutputStream(this.localFileName);
        InetAddress server = InetAddress.getByName(this.remoteHost);
        DatagramSocket sock = new DatagramSocket();
        DatagramPacket reqPacket = this.buildRequestPacket((short)1, this.remoteFileName, this.mode, server, this.remotePort, 0L);
        sock.setSoTimeout(this.timeOut);
        try {
            sock.send(reqPacket);
        }
        catch (Exception e) {
            this.fireError("Error on Sending WRQ Packet: " + e);
            return;
        }
        boolean done = false;
        boolean lastPacket = false;
        byte[] data = new byte[this.maxPacketSize];
        int dataLength = this.maxPacketSize;
        int packetNum = 1;
        int tryNum = 1;
        int totalBytes = 0;
        int retransmitions = 0;
        while (!done) {
            DatagramPacket dataPacket = this.buildGetDataPacket(this.remotePort, server);
            try {
                sock.receive(dataPacket);
            }
            catch (InterruptedIOException e) {
                if (tryNum > this.retries) {
                    this.fireError("Error in recieve DATA: " + e.getMessage());
                    return;
                }
                ++tryNum;
                continue;
            }
            catch (IOException e) {
                this.fireError("Error in recieve DATA: " + e.getMessage());
                return;
            }
            this.remotePort = dataPacket.getPort();
            if (this.remotePort == 0) {
                this.fireError("Failed to Set Remote Port.");
                return;
            }
            AvUdpData udpData = new AvUdpData(dataPacket);
            short status = udpData.getByte(1);
            if (status == 3) {
                int recievedPacketNum = udpData.getInt(2);
                if (packetNum != recievedPacketNum) {
                    if (packetNum > recievedPacketNum) {
                        ++retransmitions;
                        continue;
                    }
                    this.fireError("Invalid DATA Packet Number. Expected: " + packetNum + ". Recieved: " + recievedPacketNum);
                    return;
                }
                dataLength = dataPacket.getLength();
                outFileStream.write(udpData.getData(), 4, dataLength - 4);
                this.fireTransfer(totalBytes += dataLength, packetNum);
                if (dataLength < this.maxPacketSize) {
                    done = true;
                }
            } else {
                if (status == 5) {
                    this.fireError("Error Packet Retrieved: " + this.getErrorString(udpData));
                    return;
                }
                this.fireError("Unknown Packet Recieved.");
                return;
            }
            DatagramPacket ackPacket = this.buildGetAckPacket(this.remotePort, server, packetNum);
            try {
                sock.send(ackPacket);
            }
            catch (Exception e) {
                this.fireError("Error on Sending ACK Packet: " + e);
                return;
            }
            ++packetNum;
        }
        outFileStream.close();
        sock.close();
        this.fireEndTransfer(retransmitions);
    }

    String getErrorString(AvUdpData udpData) {
        String str = udpData.getString(4);
        if (str.length() != 0) {
            return "ErrorStr: " + str;
        }
        byte errorCode = udpData.getByte(3);
        switch (errorCode) {
            case 0: {
                return "Not defined, see error message (if any).";
            }
            case 1: {
                return "File not found.";
            }
            case 2: {
                return "Access violation.";
            }
            case 3: {
                return "Disk full or allocation exceeded.";
            }
            case 4: {
                return "Illegal TFTP operation.";
            }
            case 5: {
                return "Unknown transfer ID.";
            }
            case 6: {
                return "File already exists.";
            }
            case 7: {
                return "No such user.";
            }
        }
        return "File not found.";
    }

    public void addTftpEventListener(AvTftpEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public void removeTftpEventListener(AvTftpEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners != null) {
            this.listeners.removeElement(listener);
        }
    }

    void fireEndTransfer(int retransmitions) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            AvTftpEventListener listener = (AvTftpEventListener)e.nextElement();
            listener.endTransfer(new AvTftpEndTransferEvent(this, retransmitions));
        }
    }

    void fireError(String errorString) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            AvTftpEventListener listener = (AvTftpEventListener)e.nextElement();
            listener.error(new AvTftpErrorEvent(this, errorString));
        }
    }

    void fireStartTransfer(long fileSize) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            AvTftpEventListener listener = (AvTftpEventListener)e.nextElement();
            listener.startTransfer(new AvTftpStartTransferEvent(this, fileSize));
        }
    }

    void fireTransfer(long bytesTransferred, int packetNumber) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            AvTftpEventListener listener = (AvTftpEventListener)e.nextElement();
            listener.transfer(new AvTftpTransferEvent(this, bytesTransferred, packetNumber));
        }
    }

    public void setRemoteHost(String newRemoteHost) {
        this.remoteHost = newRemoteHost;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteFileName(String newRemoteFileName) {
        this.remoteFileName = newRemoteFileName;
    }

    public String getRemoteFileName() {
        return this.remoteFileName;
    }

    public void setLockalFileName(String newLocalFileName) {
        this.localFileName = newLocalFileName;
    }

    public String getLockalFileName() {
        return this.localFileName;
    }

    public void setMode(String newMode) throws Exception {
        if (!newMode.equals(TFTP_netascii) && !newMode.equals(TFTP_octet)) {
            throw new Exception("Unknown mode: " + newMode);
        }
        this.mode = newMode;
    }

    public String getMode() {
        return this.mode;
    }

    public void setRemotePort(int newRemotePort) {
        this.remotePort = newRemotePort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRetries(int newRetries) {
        this.retries = newRetries;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setTimeOut(int newTimeOut) {
        this.timeOut = newTimeOut * 1000;
    }

    public int getTimeOut() {
        return this.timeOut;
    }
}

