/*
 * Decompiled with CFR 0.152.
 */
package com.tftp;

import com.tftp.AvTftpClient;
import com.tftp.AvTftpEndTransferEvent;
import com.tftp.AvTftpErrorEvent;
import com.tftp.AvTftpEventListener;
import com.tftp.AvTftpStartTransferEvent;
import com.tftp.AvTftpTransferEvent;

public class AvTestTftp {
    public static void main(String[] args) {
        System.out.println("\n\nPress Enter key to End.");
        AvTestTftpSession tftpSession = new AvTestTftpSession(1, "10.0.0.50", "private.fmr", "C:/Dorado/firmware/GFSK/4.3.9/128K/A439S.BS");
        Thread thread = new Thread(tftpSession);
        thread.start();
        try {
            System.in.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class AvTestTftpSession
    implements Runnable {
        AvTftpClient tftpClient = null;
        int id;
        int maxAttempts = 3;
        int attempt = 1;
        boolean done = false;
        String server;
        String remoteFile;
        String localFile;

        public AvTestTftpSession(int newID, String newServer, String newRemoteFile, String newLocalFile) {
            this.id = newID;
            this.server = newServer;
            this.remoteFile = newRemoteFile;
            this.localFile = newLocalFile;
        }

        private void init() {
            this.tftpClient = new AvTftpClient();
            AvTftpEventListener tftpEventListener = new AvTftpEventListener(){

                public void endTransfer(AvTftpEndTransferEvent endEvent) {
                    System.out.println("\n**************************************************");
                    System.out.println(AvTestTftpSession.this.id + " - TFTP Session Finished. Retransmitions: " + endEvent.getRetransmitions());
                    System.out.println("**************************************************\n");
                    AvTestTftpSession.this.done = true;
                }

                public void error(AvTftpErrorEvent errorEvent) {
                    System.out.println("\n--------------------------------------------------");
                    System.out.println(AvTestTftpSession.this.id + " - TFTP Session Failed on Attempt: " + AvTestTftpSession.this.attempt + " - " + errorEvent.getErrorString());
                    System.out.println("--------------------------------------------------\n");
                    ++AvTestTftpSession.this.attempt;
                }

                public void startTransfer(AvTftpStartTransferEvent startEvent) {
                    System.out.println(AvTestTftpSession.this.id + " - TFTP Session Started: File Size is " + startEvent.getFileSize());
                }

                public void transfer(AvTftpTransferEvent transferEvent) {
                    int packetNumber = transferEvent.getPacketNumber();
                    if (packetNumber % 200 == 0) {
                        System.out.println(AvTestTftpSession.this.id + " - Bytes Transferred: " + transferEvent.getBytesTransferred() + ", Packet Number: " + packetNumber);
                    }
                }
            };
            this.tftpClient.addTftpEventListener(tftpEventListener);
            this.tftpClient.setLockalFileName(this.localFile);
            this.tftpClient.setRemoteHost(this.server);
            this.tftpClient.setRemoteFileName(this.remoteFile);
            this.tftpClient.setTimeOut(3);
            this.tftpClient.setRetries(5);
        }

        public void run() {
            try {
                this.init();
                this.tftpClient.putFile();
            }
            catch (Exception e) {
                System.out.println("TFTP Session Failed.");
                e.printStackTrace();
            }
            System.out.println("\n**************************************************");
            System.out.println(this.id + " - TFTP Session Finished.");
            System.out.println("**************************************************\n");
        }
    }
}

