/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.zdebug.trace;

import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvTraceStartupCategory;
import com.ngnms.zdebug.trace.AvTraceOperate;
import com.ngnms.zdebug.trace.AvTraceOperateParamSet;
import com.ngnms.zdebug.trace.AvTraceOperation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AvTraceOperateImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvTraceOperate.class);

    public void runDelegated(IOWEvent event2) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvTraceOperate.run()");
        this.runRule((AvTraceOperateParamSet)event2);
        AvTrace.traceln("AvCS", 1, "<AvTraceOperate.run()");
    }

    public void runRule(AvTraceOperateParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        try {
            IOWBOMClient bomAPI = this.getBOM();
            for (AvTraceOperation operation : (Vector)pParamSet.getOperations()) {
                String category;
                if (operation.getOperation() == 1) {
                    System.out.println("\nIn AvTraceOperate - Add Category:");
                    category = operation.getCategory();
                    int detailLevel = operation.getDetailLevel();
                    Hashtable allCategories = AvTrace.getCategories();
                    if (allCategories.isEmpty() || !allCategories.containsKey(category)) {
                        AvTraceStartupCategory cat = new AvTraceStartupCategory();
                        cat.setCategory(category);
                        cat.setDetail(detailLevel);
                        bomAPI.commitObject((IOWBean)cat);
                    } else {
                        try {
                            OWBOMAttribValueOperator attr = new OWBOMAttribValueOperator("Category", "=", (Object)category);
                            OWBOMQueryByAttribs query = new OWBOMQueryByAttribs("com.ngnms.common.AvTraceStartupCategory", attr, false);
                            ArrayList categories = bomAPI.getObjects((OWBOMQuery)query).getReturnObjects();
                            AvTraceStartupCategory cat = null;
                            if (!categories.isEmpty()) {
                                cat = (AvTraceStartupCategory)categories.get(0);
                            }
                            if (cat != null) {
                                bomAPI.getObjectForUpdate((IOWBean)cat);
                                cat.setDetail(detailLevel);
                                bomAPI.commitObject((IOWBean)cat);
                            }
                        }
                        catch (OWBOMNotFoundException e) {
                            System.out.println("Category: " + category + " - Cannot be updated.");
                        }
                    }
                    AvTrace.addTraceCategory(category, detailLevel);
                    System.out.println("Category: " + category + "." + detailLevel + " - Added.");
                } else if (operation.getOperation() == 2) {
                    System.out.println("\nIn AvTraceOperate - Delete Category:");
                    category = operation.getCategory();
                    try {
                        OWBOMAttribValueOperator attr = new OWBOMAttribValueOperator("Category", "=", (Object)category);
                        OWBOMQueryByAttribs query = new OWBOMQueryByAttribs("com.ngnms.common.AvTraceStartupCategory", attr, false);
                        ArrayList categories = bomAPI.getObjects((OWBOMQuery)query).getReturnObjects();
                        for (AvTraceStartupCategory cat : categories) {
                            bomAPI.getObjectForUpdate((IOWBean)cat);
                            bomAPI.deleteObject((IOWBean)cat);
                            bomAPI.commitObject((IOWBean)cat);
                            System.out.println("Category: " + category + " - Deleted.");
                        }
                        AvTrace.removeTraceCategory(category);
                    }
                    catch (OWBOMNotFoundException e) {
                        System.out.println("Category: " + category + " - Not Found.");
                    }
                } else if (operation.getOperation() == 4) {
                    System.out.println("\nIn AvTraceOperate - Load Categories:");
                    AvTrace.load(bomAPI);
                    System.out.println("\nIn AvTraceOperate - Categories Loaded.");
                } else {
                    System.out.println("Unknown Operation: " + operation);
                }
                bomAPI.commitAll();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

