/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.zdebug.debug;

import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.common.utility.OWOID;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.core.scheduler.OWScheduleClient;
import com.dorado.core.scheduler.OWScheduleItem;
import com.dorado.core.scheduler.OWScheduleItemList;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.common.AvTrace;
import com.ngnms.zdebug.debug.DebugEvent;
import com.ngnms.zdebug.debug.DeleteOrDisplayScheduleItemsRule;
import java.util.Date;
import org.apache.log4j.Logger;

public class DeleteOrDisplayScheduleItemsRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(DeleteOrDisplayScheduleItemsRule.class);

    public void runDelegated(IOWEvent event2) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">DeleteOrDisplayScheduleItemsRule.run()");
        this.runRule((DebugEvent)event2);
        AvTrace.traceln("AvCS", 1, "<DeleteOrDisplayScheduleItemsRule.run()");
    }

    public void runRule(DebugEvent pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        block13: {
            try {
                String request = pParamSet.getRequest();
                OWScheduleClient schedClient = new OWScheduleClient();
                System.out.println("In DeleteOrDisplayScheduleItemsRule - request = " + request);
                if (request == null) {
                    request = "";
                }
                if (request.equals("ALL")) {
                    System.out.println("Removing ALL schedule items");
                    schedClient.removeAllItems();
                    break block13;
                }
                try {
                    OWScheduleItem item = schedClient.getItem(new OWOID(request));
                    System.out.println("Removing schedule item " + request);
                    schedClient.removeItem(item);
                }
                catch (Exception x) {
                    OWScheduleItemList items = schedClient.getItemList();
                    System.out.println("\n\nUsege:");
                    System.out.println("Request = OID -     OWOID of the OWScheduleItem.");
                    System.out.println("Request = \"ALL\" - Delete all Scheduled Items\n\n");
                    System.out.println("Found " + items.size() + " Schedule items");
                    for (int i = 0; i < items.size(); ++i) {
                        OWScheduleItem item = items.elementAt(i);
                        System.out.println("Schedule item " + (i + 1));
                        System.out.println("   Category =        " + item.getCategory());
                        System.out.println("   Description =     " + item.getDescription());
                        System.out.println("   ItemKeyAsString = " + item.getItemKeyAsString());
                        System.out.println("   KEY =             " + item.getKEY());
                        System.out.println("   EJBName =         " + item.getEJBName());
                        System.out.println("   isFinished =      " + item.getFinishedFlag());
                        System.out.println("   Enabled =         " + item.getEnabled());
                        System.out.println("   hasOccurrences =  " + item.getHasOccurrences());
                        if (item.getHasOccurrences()) {
                            System.out.println("   Occurrences =     " + item.getOccurrences());
                        }
                        System.out.println("   isTime =          " + item.isTime());
                        System.out.println("   isToExecute =     " + item.isToExecute());
                        System.out.println("   StartDate =       " + new Date(item.getStartDate()).toString());
                        switch (item.getRunStatus()) {
                            case 0: {
                                System.out.println("   RunStatus =        WAIT");
                                break;
                            }
                            case 1: {
                                System.out.println("   RunStatus =        RUN");
                                break;
                            }
                            case 2: {
                                System.out.println("   RunStatus =        STOP");
                            }
                        }
                        System.out.println("-------------------------------------------------------------------------");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

