/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup.migration;

import com.dorado.oware.core.usermanagement.OWRole;
import com.dorado.oware.core.usermanagement.OWUser;
import com.dorado.runtime.OWVector;
import com.ngnms.setup.migration.ObjectExportHandler;
import com.ngnms.setup.migration.PrintStreamWriter;
import java.io.OutputStream;

public class UserExportHandler
extends ObjectExportHandler {
    private static String[] usersToSkip = new String[]{"admin", "Administrator", "monitor", "operator", "supervisor", "technician", "OWAdmin", "OWMedServer", "OWPublic"};

    public UserExportHandler(OutputStream output) {
        super(new String[0], new String[0], new String[0], output);
    }

    public UserExportHandler(String[] includes, String[] excludes, String[] force, OutputStream output) {
        super(includes, excludes, force, output);
    }

    public void exportObject(Object object) throws Exception {
        OWUser user;
        if (object instanceof OWUser && !this.skipUser(user = (OWUser)object)) {
            this.exportUser(user, this.output);
        }
    }

    private void exportUser(OWUser user, PrintStreamWriter out) throws Exception {
        System.out.println("Export User : " + OWUser.class + " [" + user.getKEY() + "]");
        out.print("\t");
        out.print("<RCUser");
        out.print(" firstName=\"" + user.getFirstName() + "\"");
        out.print(" lastName=\"" + user.getLastName() + "\"");
        out.print(" userId=\"" + user.getUserId() + "\"");
        out.println(">");
        this.exportUserAttribute("password", user.getPassword(), out);
        OWVector roles = user.getRoles();
        if (roles != null) {
            for (int i = 0; i < roles.size(); ++i) {
                OWRole role = (OWRole)roles.get(i);
                if (role == null) continue;
                this.exportUserAttribute("group", role.getRoleId(), out);
            }
        }
        this.exportUserAttribute("enabled", "true", out);
        this.exportUserAttribute("icon", "RedCell.Images.Contact.Contact", out);
        out.print("\t");
        out.println("</RCUser>");
        out.flush();
    }

    private void exportUserAttribute(String name, String value, PrintStreamWriter out) throws Exception {
        out.print("\t\t");
        out.print("<UserAttrib");
        out.print(" name=\"" + name + "\"");
        out.print(" value=\"" + value + "\"");
        out.println("/>");
    }

    private boolean skipUser(OWUser user) {
        for (int i = 0; i < usersToSkip.length; ++i) {
            if (!usersToSkip[i].equals(user.getUserId())) continue;
            return true;
        }
        return false;
    }

    private String getUserGroup(OWUser user) {
        StringBuffer group = new StringBuffer();
        OWVector roles = user.getRoles();
        if (roles != null && roles.size() > 0) {
            int lastIdx = roles.size() - 1;
            OWRole role = null;
            for (int i = 0; i < lastIdx; ++i) {
                role = (OWRole)roles.get(i);
                if (role == null) continue;
                group.append(role.getRoleId()).append(",");
            }
            role = (OWRole)roles.get(lastIdx);
            if (role != null) {
                group.append(role.getRoleId());
            }
        }
        return group.toString();
    }
}

