/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup.migration;

import com.dorado.core.bom.IOWBOMInternalUseMarker;
import com.dorado.core.bom.OWBOMFatClient;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryAllByClass;
import com.ngnms.setup.migration.Exporter;
import com.ngnms.setup.migration.ObjectExportHandler;
import com.ngnms.setup.migration.PrintStreamWriter;
import com.ngnms.setup.migration.RoleExportHandler;
import com.ngnms.setup.migration.UserExportHandler;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.ZipEntry;

public class SecurityExporter
extends Exporter {
    public SecurityExporter(String inputFile, String outputFile) throws Exception {
        super(inputFile, outputFile);
    }

    protected void doExport() throws Exception {
        this.bomAPI = "odbms".equalsIgnoreCase(System.getProperty("com.dorado.bom_dbms.preferred_db_type")) && "odbms".equalsIgnoreCase(System.getProperty("com.dorado.bom_dbms.versant.dbms_type")) ? new OWBOMFatClient((IOWBOMInternalUseMarker)this, "CNTL", true, false) : new OWBOMFatClient((IOWBOMInternalUseMarker)this, true);
        this.exportManifest();
        this.exportInstallScript();
        this.exportObjects();
        this.zip.close();
        this.file.close();
    }

    private void exportManifest() throws IOException {
        ZipEntry backup = new ZipEntry("META-INF/MANIFEST.MF");
        backup.setMethod(8);
        this.zip.putNextEntry(backup);
        BufferedOutputStream output = new BufferedOutputStream(this.zip);
        PrintStreamWriter stream = null;
        try {
            stream = new PrintStreamWriter((OutputStream)output, "UTF8");
            System.out.println("Set UTF8 Encoding");
        }
        catch (UnsupportedEncodingException e) {
            stream = new PrintStreamWriter(output);
            System.out.println("Failed to set UTF8 Encoding - Use Default");
        }
        stream.println("Manifest-Version: 1.0");
        stream.println("Ant-Version: Apache Ant 1.5.2");
        stream.println("Created-By: (A* v2.6 Exporter)");
        stream.println("Content-Version: ");
        stream.println("User-Directory: ");
        stream.println("Install-Path: META-INF/ocp.install");
        stream.flush();
        this.zip.closeEntry();
    }

    private void exportInstallScript() throws IOException {
        ZipEntry backup = new ZipEntry("META-INF/ocp.install");
        backup.setMethod(8);
        this.zip.putNextEntry(backup);
        BufferedOutputStream output = new BufferedOutputStream(this.zip);
        PrintStreamWriter stream = null;
        try {
            stream = new PrintStreamWriter((OutputStream)output, "UTF8");
            System.out.println("Set UTF8 Encoding");
            stream.println("<?xml version='1.0' encoding='UTF-8'?>");
        }
        catch (UnsupportedEncodingException e) {
            stream = new PrintStreamWriter(output);
            System.out.println("Failed to set UTF8 Encoding - Use Default");
            stream.println("<?xml version='1.0' ?>");
        }
        stream.println("<device-driver>");
        stream.println("<name>@NAME@</name>");
        stream.println("<description>@NAME@</description>");
        stream.println("<version>@BUILD_VER@</version>");
        stream.println("<type>Deployed</type>");
        stream.println("");
        stream.println("<propertydef name=\"component.basedir\" value=\"ngnms\"/>");
        stream.println("<propertydef name=\"component.prefix\" value=\"ngnms\"/>");
        stream.println("<propertydef name=\"component.basepath\" value=\"${oware.user.root}/owareapps/${component.basedir}\"/>");
        stream.println("<propertydef name=\"dep_type\" value=\"deployed\"/>");
        stream.println("<propertydef name=\"temp_url\" value=\"file://${oware.user.root}/oware/temp\"/>");
        stream.print('\t');
        stream.println("<install>");
        stream.print("\t\t");
        stream.println("<!-- Roles -->");
        stream.print("\t\t");
        stream.println("<import>");
        stream.print("\t\t\t");
        stream.println("<file>db/seedroles2.xml</file>");
        stream.print("\t\t\t");
        stream.println("<dbms>cntl</dbms>");
        stream.print("\t\t\t");
        stream.println("<importer>SOAP_IMPORTER</importer>");
        stream.print("\t\t");
        stream.println("</import>");
        stream.print("\t\t");
        stream.println("<!-- Users -->");
        stream.print("\t\t");
        stream.println("<import>");
        stream.print("\t\t\t");
        stream.println("<file>db/seedusers2.xml</file>");
        stream.print("\t\t\t");
        stream.println("<importer>redcell.core.usersys.RCUserHandler2</importer>");
        stream.print("\t\t");
        stream.println("</import>");
        stream.print('\t');
        stream.println("</install>");
        stream.println("</device-driver>");
        stream.flush();
        this.zip.closeEntry();
    }

    private void exportObjects() throws Exception {
        for (int i = 0; i < this.exports.length; ++i) {
            ZipEntry backup;
            String clazz = this.exports[i];
            Collection v = null;
            try {
                OWBOMQueryAllByClass qbc = new OWBOMQueryAllByClass(clazz, false);
                v = (Collection)this.bomAPI.getObjects((OWBOMQuery)qbc).getReturnObject();
            }
            catch (OWBOMNotFoundException e) {
                // empty catch block
            }
            if (v == null) continue;
            System.out.println("Exporting " + clazz + " instance count: " + v.size());
            if (v.size() <= 0) continue;
            BufferedOutputStream output = null;
            ObjectExportHandler exportHandler = null;
            if ("com.dorado.oware.core.usermanagement.OWRole".equals(clazz)) {
                backup = new ZipEntry("db/seedroles2.xml");
                backup.setMethod(8);
                this.zip.putNextEntry(backup);
                output = new BufferedOutputStream(this.zip);
                exportHandler = new RoleExportHandler(output);
            } else if ("com.dorado.oware.core.usermanagement.OWUser".equals(clazz)) {
                backup = new ZipEntry("db/seedusers2.xml");
                backup.setMethod(8);
                this.zip.putNextEntry(backup);
                output = new BufferedOutputStream(this.zip);
                exportHandler = new UserExportHandler(output);
            } else {
                return;
            }
            PrintStreamWriter stream = null;
            try {
                stream = new PrintStreamWriter((OutputStream)output, "UTF8");
                System.out.println("Set UTF8 Encoding");
                stream.println("<?xml version='1.0' encoding='UTF-8'?>");
            }
            catch (UnsupportedEncodingException e) {
                stream = new PrintStreamWriter(output);
                System.out.println("Failed to set UTF8 Encoding - Use Default");
                stream.println("<?xml version='1.0' ?>");
            }
            if ("com.dorado.oware.core.usermanagement.OWUser".equals(clazz)) {
                stream.println("<!DOCTYPE OWUsers [");
                stream.println("<!ELEMENT OWUsers (RCUser+, XMLConfig) >");
                stream.println("<!ELEMENT RCUser (UserAttrib+, RCAttrib+) >");
                stream.println("<!ELEMENT XMLConfig (empty) >");
                stream.println("<!ELEMENT UserAttrib (empty) >");
                stream.println("<!ELEMENT RCAttrib (empty) >");
                stream.println("\n");
                stream.println("<!ATTLIST XMLConfig");
                stream.println("handlerClassName        CDATA           #REQUIRED");
                stream.println("instanceClass           CDATA           #REQUIRED");
                stream.println(">");
                stream.println("<!ATTLIST RCUser");
                stream.println("userId                  CDATA           #REQUIRED");
                stream.println("lastName                CDATA           #REQUIRED");
                stream.println("firstName               CDATA           #REQUIRED");
                stream.println(">");
                stream.println("<!ATTLIST UserAttrib");
                stream.println("name                    CDATA           #REQUIRED");
                stream.println("value                   CDATA           #REQUIRED");
                stream.println(">");
                stream.println("<!ATTLIST RCAttrib");
                stream.println("name                    CDATA           #REQUIRED");
                stream.println("value                   CDATA           #REQUIRED");
                stream.println(">");
                stream.println("]>");
                stream.println("\n");
                stream.println("<OWUsers>");
                stream.print('\t');
                stream.print("<XMLConfig");
                stream.print(" handlerClassName=\"redcell.core.usersys.RCUserHandler2\"");
                stream.print(" instanceClass=\"com.dorado.oware.core.usermanagement.OWUser\"");
                stream.println("/>");
            }
            stream.flush();
            this.progress.setMinValue(0);
            this.progress.setMaxValue(v.size());
            int val = 0;
            this.progress.startTask();
            Iterator it = v.iterator();
            while (it.hasNext()) {
                exportHandler.exportObject(it.next());
                this.progress.setProgress(++val);
            }
            this.progress.endTask();
            if ("com.dorado.oware.core.usermanagement.OWUser".equals(clazz)) {
                stream.println("</OWUsers>");
            }
            stream.flush();
            this.zip.closeEntry();
        }
    }
}

