/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup.migration;

import com.dorado.oware.core.usermanagement.OWRole;
import com.ngnms.setup.migration.ObjectExportHandler;
import com.ngnms.setup.migration.PrintStreamWriter;
import java.io.OutputStream;

public class RoleExportHandler
extends ObjectExportHandler {
    private static String[] rolesToSkip = new String[]{"Administrators", "Network Monitors", "NOC Supervisors", "Operators", "Technicians", "OWDbAdmin", "OWServerAdmin"};

    public RoleExportHandler(OutputStream output) {
        super(new String[0], new String[0], new String[0], output);
    }

    public RoleExportHandler(String[] includes, String[] excludes, String[] force, OutputStream output) {
        super(includes, excludes, force, output);
    }

    public void exportObject(Object object) throws Exception {
        OWRole role;
        if (object instanceof OWRole && !this.skipRole(role = (OWRole)object)) {
            this.exportRole(role, this.output);
        }
    }

    private void exportRole(OWRole role, PrintStreamWriter out) throws Exception {
        System.out.println("Export Role : " + OWRole.class + " [" + role.getKEY() + "]");
        out.println("<Bean  xsi:id='1' xmlns:xsi='http://www.w3.org/1999/XMLSchema-instance'>");
        out.println("<class >com.dorado.oware.core.usermanagement.OWRole</class>");
        out.println("<BPAttributes>");
        out.println("<OW_KEY>" + role.getKEY() + "</OW_KEY>");
        out.println("</BPAttributes>");
        out.println("<com.dorado.oware.core.usermanagement.OWRole.Attributes>");
        out.println("<Description>");
        out.println("<value  xsi:type='xsd:string'>" + role.getDescription() + "</value>");
        out.println("</Description>");
        out.println("<Name>");
        out.println("<value  xsi:type='xsd:string'>" + role.getName() + "</value>");
        out.println("</Name>");
        out.println("<Protected>");
        out.println("<value  xsi:type='xsd:boolean'>" + role.getProtected() + "</value>");
        out.println("</Protected>");
        out.println("<RoleId>");
        out.println("<value  xsi:type='xsd:string'>" + role.getRoleId() + "</value>");
        out.println("</RoleId>");
        out.println("</com.dorado.oware.core.usermanagement.OWRole.Attributes>");
        out.println("</Bean>");
        out.flush();
    }

    private boolean skipRole(OWRole role) {
        for (int i = 0; i < rolesToSkip.length; ++i) {
            if (!rolesToSkip[i].equals(role.getRoleId())) continue;
            return true;
        }
        return false;
    }
}

