/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup.migration;

import RedCell.Config.NetworkResource;
import RedCell.Config.NetworkResourceKey;
import com.dorado.common.utility.OWOID;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.IOWBOMInternalUseMarker;
import com.dorado.core.bom.OWBOMDupAddObjectException;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQueryByKey;
import com.dorado.core.bom.OWBOMQueryByOWOID;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.OWBean;
import com.dorado.runtime.OWSet;
import com.dorado.runtime.OWVector;
import com.ngnms.setup.migration.Base64Decoder;
import com.ngnms.setup.migration.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ObjectHandler
extends DefaultHandler
implements IOWBOMInternalUseMarker {
    private Stack objectStack = new Stack();
    private Stack collectionStack = new Stack();
    private Stack attributesStack = new Stack();
    private Stack bodyStack = new Stack();
    private Stack propStack = new Stack();
    private Stack propTypeStack = new Stack();
    private boolean wasNull = false;
    private Hashtable objects = new Hashtable();
    private IOWBOMClient bomAPI = null;
    private Hashtable objectCount = new Hashtable();
    private long objectCountLong = 0L;
    private ArrayList circularReferences = new ArrayList();

    public ObjectHandler(IOWBOMClient bomAPI) {
        this.bomAPI = bomAPI;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        block29: {
            this.attributesStack.push(atts);
            this.bodyStack.push(new StringBuffer());
            if ("object".equals(qName)) {
                try {
                    Class<?> clazz = Class.forName(atts.getValue("type"));
                    OWBean bean = (OWBean)clazz.newInstance();
                    bean.setHandle((IOWBOMInternalUseMarker)this, atts.getValue("owoid"));
                    this.objectStack.push(bean);
                    this.objects.put(atts.getValue("owoid"), bean);
                    Log.info("CREATED " + atts.getValue("type") + " w/ " + atts.getValue("owoid"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if ("ref".equals(qName)) {
                try {
                    OWBOMQueryByKey query;
                    String owoid = atts.getValue("owoid");
                    String key = atts.getValue("key");
                    String type = atts.getValue("type");
                    Log.debug("Looking for ref: " + atts.getValue("owoid") + " as " + atts.getValue("type"));
                    Object obj = this.objects.get(owoid);
                    if (obj == null && !"".equals(key)) {
                        try {
                            query = new OWBOMQueryByKey(type, key);
                            obj = this.bomAPI.getObject(query).getRtnObject();
                        }
                        catch (OWBOMNotFoundException e) {
                            // empty catch block
                        }
                    }
                    if (obj == null) {
                        try {
                            query = new OWBOMQueryByOWOID(new OWOID(owoid));
                            obj = this.bomAPI.getObject(query).getRtnObject();
                        }
                        catch (OWBOMNotFoundException e) {
                            // empty catch block
                        }
                    }
                    if (obj != null) {
                        this.objectStack.push(obj);
                        break block29;
                    }
                    Log.info("UNSATISFIED reference: " + key + "(" + owoid + ") of type " + atts.getValue("type"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (!"serialized".equals(qName)) {
                if ("primitive".equals(qName)) {
                    try {
                        Class<?> clazz = Class.forName(atts.getValue("type"));
                        String value = atts.getValue("value");
                        Log.trace("Got primitive " + atts.getValue("type") + " " + value);
                        Constructor<?> constr = clazz.getConstructor(String.class);
                        Object obj = constr.newInstance(value);
                        this.objectStack.push(obj);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if ("collection".equals(qName)) {
                    try {
                        String type = atts.getValue("type");
                        String className = atts.getValue("class");
                        Log.trace("Create collection " + type + " for " + className);
                        Class<?> clazz = Class.forName(className);
                        OWVector collection = null;
                        if ("OWVector".equals(type)) {
                            collection = new OWVector(clazz);
                        } else if ("OWSet".equals(type)) {
                            collection = new OWSet(clazz);
                        } else {
                            throw new Exception("Invalid collection type: " + type);
                        }
                        this.objectStack.push(collection);
                        this.collectionStack.push(collection);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if ("attribute".equals(qName)) {
                    String propName = atts.getValue("name");
                    String propType = atts.getValue("type");
                    this.propStack.push(propName);
                    this.propTypeStack.push(propType);
                    Log.trace("Got property " + propName + " as " + propType);
                }
            }
        }
    }

    private void updateCollection() throws Exception {
        if (!this.collectionStack.isEmpty()) {
            Object collection = this.collectionStack.peek();
            Object obj = this.objectStack.pop();
            if (!this.objectStack.isEmpty()) {
                if (collection.equals(this.objectStack.peek())) {
                    if (collection instanceof OWVector) {
                        ((OWVector)collection).add((IOWBean)obj);
                    } else if (collection instanceof OWSet) {
                        ((OWSet)collection).add((Serializable)obj);
                    }
                } else {
                    this.objectStack.push(obj);
                }
            } else {
                this.objectStack.push(obj);
            }
        }
    }

    private void updateObjectCount(Object obj) {
        MutableInteger mi = (MutableInteger)this.objectCount.get(obj.getClass());
        if (mi == null) {
            this.objectCount.put(obj.getClass(), new MutableInteger(1));
        } else {
            mi.plusPlus();
        }
        ++this.objectCountLong;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        block17: {
            Attributes atts = (Attributes)this.attributesStack.pop();
            StringBuffer body = (StringBuffer)this.bodyStack.pop();
            try {
                if ("object".equals(qName)) {
                    OWBean bean = (OWBean)this.objectStack.peek();
                    this.updateObjectCount(bean);
                    try {
                        this.bomAPI.commitObject((IOWBean)bean);
                        if (this.objectStack.size() == 1) {
                            this.bomAPI.commitAll();
                            Log.info("COMMITING all objects on " + bean.getClass().getName());
                            this.objectStack.pop();
                            this.fixCircularReferences();
                            break block17;
                        }
                        this.updateCollection();
                    }
                    catch (OWBOMDupAddObjectException e) {
                        Log.debug("DUPLICATE object " + bean.getClass().getName() + " " + bean.getKEY());
                        OWBOMQueryByKey qbk = new OWBOMQueryByKey(bean.getClass().getName(), bean.getKEY());
                        OWBean obj = (OWBean)this.bomAPI.getObject(qbk).getRtnObject();
                        this.objects.put(bean.getHandle().toString(), obj);
                    }
                    break block17;
                }
                if ("ref".equals(qName)) {
                    this.updateObjectCount(this.objectStack.peek());
                    this.updateCollection();
                } else if ("primitive".equals(qName)) {
                    this.updateCollection();
                } else if ("serialized".equals(qName)) {
                    ByteArrayOutputStream decoded = new ByteArrayOutputStream();
                    Base64Decoder decoder = new Base64Decoder(new ByteArrayInputStream(body.toString().getBytes()), decoded);
                    decoder.process();
                    ByteArrayInputStream in = new ByteArrayInputStream(decoded.toByteArray());
                    ObjectInputStream inObj = new ObjectInputStream(in);
                    this.objectStack.push(inObj.readObject());
                    inObj.close();
                    in.close();
                    this.updateObjectCount(this.objectStack.peek());
                    this.updateCollection();
                } else if ("collection".equals(qName)) {
                    this.collectionStack.pop();
                    this.updateCollection();
                } else if ("null".equals(qName)) {
                    this.wasNull = true;
                } else if ("attribute".equals(qName)) {
                    Object value = this.wasNull ? null : this.objectStack.pop();
                    this.wasNull = false;
                    String property = (String)this.propStack.pop();
                    String propType = (String)this.propTypeStack.pop();
                    IOWBean bean = (IOWBean)this.objectStack.peek();
                    this.setProperty(bean, property, propType, value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void fixCircularReferences() throws Exception {
        for (CircularReference ref : this.circularReferences) {
            OWBOMQueryByKey query;
            IOWBean bean = (IOWBean)ref.object;
            IOWBean obj = null;
            try {
                query = new OWBOMQueryByKey(bean.getClass().getName(), bean.getKEY());
                obj = (IOWBean)this.bomAPI.getObject(query).getRtnObject();
            }
            catch (OWBOMNotFoundException e) {
                // empty catch block
            }
            if (obj == null) {
                try {
                    query = new OWBOMQueryByOWOID(bean.getHandle());
                    obj = (IOWBean)this.bomAPI.getObject(query).getRtnObject();
                }
                catch (OWBOMNotFoundException e) {
                    // empty catch block
                }
            }
            obj = this.bomAPI.getObjectForUpdate(obj);
            IOWBean value = this.bomAPI.refreshObject((IOWBean)ref.value);
            this.setPropertyInternal(obj, ref.attributeName, value);
            this.bomAPI.commitObject(obj);
            if (!(obj instanceof NetworkResourceKey)) continue;
            Log.trace("Fixing key: " + obj);
            NetworkResource nwRes = ((NetworkResourceKey)obj).getNetworkResource();
            if (nwRes.getKey() != null) continue;
            nwRes = (NetworkResource)this.bomAPI.getObjectForUpdate((IOWBean)nwRes);
            nwRes.storeProperty("Key", (Object)obj);
            this.bomAPI.commitObject((IOWBean)nwRes);
        }
        this.bomAPI.commitAll();
        this.circularReferences.clear();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuffer body = (StringBuffer)this.bodyStack.peek();
        body.append(ch, start, length);
    }

    private void setProperty(IOWBean bean, String property, String propertyType, Object value) throws Exception {
        Log.trace("SET property " + bean.getClass().getName() + " " + property + " " + value);
        if (this.objectStack.search(value) > 0) {
            this.circularReferences.add(new CircularReference(bean, property, propertyType, value));
            Log.debug("CIRCULAR reference: " + bean.getClass().getName() + " " + property + " " + value.getClass().getName());
        }
        this.setPropertyInternal(bean, property, value);
    }

    private void setPropertyInternal(IOWBean bean, String property, Object value) throws Exception {
        bean.storeProperty(property, value, false, (IOWBOMInternalUseMarker)this);
    }

    public Hashtable getObjectCount() {
        return this.objectCount;
    }

    private class CircularReference {
        Object object;
        String attributeName;
        String attributeType;
        Object value;

        public CircularReference(Object object, String attributeName, String attributeType, Object value) {
            this.object = object;
            this.attributeName = attributeName;
            this.attributeType = attributeType;
            this.value = value;
        }
    }

    private class MutableInteger {
        private int value;

        public MutableInteger(int value) {
            this.value = value;
        }

        public int intValue() {
            return this.value;
        }

        public int plusPlus() {
            return ++this.value;
        }

        public String toString() {
            return "" + this.value;
        }
    }
}

