/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup.migration;

import com.dorado.runtime.OWBean;
import com.dorado.runtime.OWSet;
import com.dorado.runtime.OWVector;
import com.ngnms.setup.migration.Base64Encoder;
import com.ngnms.setup.migration.PrintStreamWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ObjectExportHandler {
    private static final int PRIMITIVE = 0;
    private static final int SERIALIZABLE = 1;
    private static final int OWBEAN = 2;
    private static final int OWSET = 3;
    private static final int OWVECTOR = 4;
    private String[] includes;
    private String[] excludes;
    private Set force;
    private int tabStack = 0;
    private Set primitiveClasses;
    private String[] primitiveClassesArray = new String[]{"java.lang.Integer", "java.lang.Long", "java.lang.Char", "java.lang.Byte", "java.lang.Short", "java.lang.Float", "java.lang.Double", "java.lang.Boolean", "java.lang.String"};
    private Set excludeAttributes;
    private Set exportedObjects = new HashSet();
    protected PrintStreamWriter output;

    public ObjectExportHandler(String[] includes, String[] excludes, String[] force, OutputStream output) {
        this.includes = includes;
        this.excludes = excludes;
        this.force = new HashSet<String>(Arrays.asList(force));
        try {
            this.output = new PrintStreamWriter(output, "UTF8");
            System.out.println("Set UTF8 Encoding");
        }
        catch (UnsupportedEncodingException e) {
            this.output = new PrintStreamWriter(output);
            System.out.println("Failed to set UTF8 Encoding - Use Default");
        }
        this.primitiveClasses = new HashSet<String>(Arrays.asList(this.primitiveClassesArray));
        this.excludeAttributes = new HashSet();
        try {
            Class<?> owBeanClass = Class.forName("com.dorado.runtime.OWBean");
            Method[] methods = owBeanClass.getMethods();
            for (int metIdx = 0; metIdx < methods.length; ++metIdx) {
                Method method = methods[metIdx];
                String name = method.getName();
                Class<?> type = method.getReturnType();
                if (!name.startsWith("get") || method.getParameterTypes().length != 0) continue;
                String setterName = "s" + name.substring(1);
                boolean hasSetter = true;
                try {
                    owBeanClass.getMethod(setterName, type);
                }
                catch (NoSuchMethodException e) {
                    hasSetter = false;
                }
                if (!hasSetter || !Modifier.isPublic(method.getModifiers())) continue;
                this.excludeAttributes.add(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getTypeClassification(Object object) {
        Class<?> type = object.getClass();
        if (this.primitiveClasses.contains(type.getName())) {
            return 0;
        }
        if (object instanceof OWSet) {
            return 3;
        }
        if (object instanceof OWVector) {
            return 4;
        }
        if (object instanceof OWBean) {
            return 2;
        }
        if (object instanceof Serializable) {
            return 1;
        }
        return -1;
    }

    private void doTabs(PrintStreamWriter out) throws IOException {
        for (int i = 0; i < this.tabStack; ++i) {
            out.print('\t');
        }
    }

    private void exportPrimitive(Object object, PrintStreamWriter out) throws Exception {
        this.doTabs(out);
        out.print("<primitive");
        out.print(" type=\"" + object.getClass().getName() + "\"");
        out.print(" value=\"" + this.normalize(object.toString()) + "\"");
        out.println("/>");
    }

    private void exportOWSet(OWSet owSet, PrintStreamWriter out) throws Exception {
        this.doTabs(out);
        out.print("<collection");
        out.print(" type=\"OWSet\"");
        out.print(" class=\"" + owSet.getType().getName() + "\"");
        out.println(">");
        Iterator i = owSet.iterator();
        while (i.hasNext()) {
            this.exportObject(i.next(), out);
        }
        this.doTabs(out);
        out.println("</collection>");
    }

    private void exportOWVector(OWVector owVector, PrintStreamWriter out) throws Exception {
        this.doTabs(out);
        out.print("<collection");
        out.print(" type=\"OWVector\"");
        out.print(" class=\"" + owVector.getType().getName() + "\"");
        out.println(">");
        Iterator i = owVector.iterator();
        while (i.hasNext()) {
            this.exportObject(i.next(), out);
        }
        this.doTabs(out);
        out.println("</collection>");
    }

    private void exportOWBean(OWBean bean, PrintStreamWriter out) throws Exception {
        Class<?> objectClass = bean.getClass();
        String objectClassName = objectClass.getName();
        boolean doExport = false;
        String owoid = bean.getHandle().toString();
        String key = "";
        try {
            key = bean.getKEY();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!this.exportedObjects.contains(owoid)) {
            int i;
            for (i = 0; i < this.includes.length && !doExport; ++i) {
                doExport = doExport || objectClassName.startsWith(this.includes[i]);
            }
            for (i = 0; i < this.excludes.length && doExport; ++i) {
                doExport = doExport && !objectClassName.startsWith(this.excludes[i]);
            }
            if (this.force.contains(objectClassName)) {
                doExport = true;
            }
            this.exportedObjects.add(owoid);
        }
        this.doTabs(out);
        if (!doExport) {
            out.print("<ref");
            out.print(" type=\"" + objectClassName + "\"");
            out.print(" owoid=\"" + owoid + "\"");
            out.print(" key=\"" + key + "\"");
            out.println("/>");
        } else {
            System.out.println("Export Object : " + objectClassName + " [" + owoid + "]");
            out.print("<object");
            out.print(" type=\"" + objectClassName + "\"");
            out.print(" owoid=\"" + owoid + "\"");
            out.print(" key=\"" + key + "\"");
            out.println(">");
            try {
                Method[] methods = objectClass.getMethods();
                for (int metIdx = 0; metIdx < methods.length; ++metIdx) {
                    Method method = methods[metIdx];
                    String name = method.getName();
                    Class<?> type = method.getReturnType();
                    if (!name.startsWith("get") || this.excludeAttributes.contains(name) || method.getParameterTypes().length != 0) continue;
                    String setterName = "s" + name.substring(1);
                    boolean hasSetter = true;
                    try {
                        objectClass.getMethod(setterName, type);
                    }
                    catch (NoSuchMethodException e) {
                        hasSetter = false;
                    }
                    if (!hasSetter || !Modifier.isPublic(method.getModifiers())) continue;
                    String propertyName = name.substring(3);
                    try {
                        Object value = method.invoke((Object)bean, new Object[0]);
                        ++this.tabStack;
                        this.doTabs(out);
                        out.print("<attribute");
                        out.print(" name=\"" + propertyName + "\"");
                        out.print(" type=\"" + type.getName() + "\"");
                        out.println(">");
                        this.exportObject(value, out);
                        this.doTabs(out);
                        out.println("</attribute>");
                        --this.tabStack;
                        continue;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.doTabs(out);
            out.println("</object>");
        }
    }

    private void exportSerializable(Serializable object, PrintStreamWriter out) throws Exception {
        this.doTabs(out);
        out.print("<serialized");
        out.print(" type=\"" + object.getClass().getName() + "\"");
        out.println(">");
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        ObjectOutputStream outObj = new ObjectOutputStream(buff);
        outObj.writeObject(object);
        outObj.close();
        ByteArrayOutputStream out64 = new ByteArrayOutputStream();
        Base64Encoder encoder = new Base64Encoder(new ByteArrayInputStream(buff.toByteArray()), out64);
        encoder.process();
        out.println(new String(out64.toByteArray()));
        this.doTabs(out);
        out.println("</serialized>");
    }

    private void exportNull(PrintStreamWriter out) throws Exception {
        this.doTabs(out);
        out.println("<null/>");
    }

    public void exportObject(Object object) throws Exception {
        this.exportObject(object, this.output);
    }

    private void exportObject(Object object, PrintStreamWriter out) throws Exception {
        ++this.tabStack;
        if (object == null) {
            this.exportNull(out);
        } else {
            switch (this.getTypeClassification(object)) {
                case 0: {
                    this.exportPrimitive(object, out);
                    break;
                }
                case 3: {
                    this.exportOWSet((OWSet)object, out);
                    break;
                }
                case 4: {
                    this.exportOWVector((OWVector)object, out);
                    break;
                }
                case 2: {
                    this.exportOWBean((OWBean)object, out);
                    break;
                }
                case 1: {
                    this.exportSerializable((Serializable)object, out);
                    break;
                }
                default: {
                    throw new Exception("Not exportable: " + object.getClass().getName());
                }
            }
        }
        out.flush();
        --this.tabStack;
    }

    private String normalize(String str) {
        StringBuffer buf = new StringBuffer();
        int len = str == null ? 0 : str.length();
        block7: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    buf.append("&#");
                    buf.append(Integer.toString(ch));
                    buf.append(';');
                    continue block7;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        System.err.println(str + " : " + buf.toString());
        return buf.toString();
    }
}

