/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup.migration;

import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.IOWBOMInternalUseMarker;
import com.dorado.core.bom.OWBOMFatClient;
import com.ngnms.setup.migration.Log;
import com.ngnms.setup.migration.ObjectHandler;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class Importer
implements IOWBOMInternalUseMarker {
    private IOWBOMClient bomAPI = new OWBOMFatClient((IOWBOMInternalUseMarker)this, true);
    private FileInputStream file;
    private ZipInputStream zip;
    private InputStream in;

    public Importer(String inputFileName) throws Exception {
        this.file = new FileInputStream(inputFileName);
        this.zip = new ZipInputStream(this.file);
        ZipEntry backup = this.zip.getNextEntry();
        this.in = this.zip;
    }

    public void doImport() throws Exception {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        SAXParser parser = parserFactory.newSAXParser();
        long time = System.currentTimeMillis();
        ObjectHandler handler = new ObjectHandler(this.bomAPI);
        parser.parse(new InputSource(this.in), (DefaultHandler)handler);
        this.bomAPI.commitAll();
        long timeDiff = (System.currentTimeMillis() - time) / 1000L;
        long hours = timeDiff / 3600L;
        long minutes = (timeDiff %= 3600L) / 60L;
        timeDiff %= 60L;
        System.out.print("Completed in ");
        if (hours > 0L) {
            System.out.print(hours + ":");
        }
        System.out.println(minutes + "m" + timeDiff + "s");
        System.out.println();
        Hashtable objectCount = handler.getObjectCount();
        for (Class clazz : objectCount.keySet()) {
            System.out.println("Created " + objectCount.get(clazz) + " instances of " + clazz.getName());
        }
    }

    private void close() {
        try {
            this.zip.close();
            this.file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static final void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: owlaunch com.ngnms.setup.dbtools.Importer importFile");
            System.exit(0);
        }
        if (args[0].startsWith("-")) {
            if ("-debug".equals(args[0])) {
                Log.setDebugLevel(2);
            } else if ("-trace".equals(args[0])) {
                Log.setDebugLevel(3);
            } else if ("-silent".equals(args[0])) {
                Log.setDebugLevel(0);
            }
        } else {
            Log.setDebugLevel(1);
        }
        Importer importer = null;
        try {
            importer = new Importer(args[args.length - 1]);
            importer.doImport();
            if (importer != null) {
                importer.close();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not open input file.");
            if (importer != null) {
                importer.close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            if (importer != null) {
                importer.close();
            }
            {
                catch (Throwable throwable) {
                    if (importer != null) {
                        super.close();
                    }
                    throw throwable;
                }
            }
        }
        System.exit(0);
    }
}

