/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup.migration;

import RedCell.Config.Equipment;
import RedCell.Config.Location;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.IOWBOMInternalUseMarker;
import com.dorado.core.bom.OWBOMAPIException;
import com.dorado.core.bom.OWBOMFatClient;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryAllByClass;
import com.dorado.oware.core.security.OWObjectGroup;
import com.dorado.runtime.OWVector;
import com.ngnms.setup.migration.ConsoleProgressObserver;
import com.ngnms.setup.migration.ObjectExportHandler;
import com.ngnms.setup.migration.PrintStreamWriter;
import com.ngnms.setup.migration.ProgressObserver;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import redcell.core.security.RCBOMInternalUseMarker;

public class Exporter
implements IOWBOMInternalUseMarker {
    protected IOWBOMClient bomAPI;
    protected String[] exports;
    protected String[] excludes;
    protected String[] includes;
    protected String[] force;
    protected ObjectExportHandler objectExporter;
    protected OutputStream out;
    protected FileOutputStream file;
    protected ZipOutputStream zip;
    ProgressObserver progress = new ConsoleProgressObserver();

    public Exporter(String inputFile, String outputFile) throws Exception {
        String line;
        ArrayList<String> exportArray = new ArrayList<String>();
        ArrayList<String> excludeArray = new ArrayList<String>();
        ArrayList<String> includeArray = new ArrayList<String>();
        ArrayList<String> forceArray = new ArrayList<String>();
        this.file = new FileOutputStream(outputFile);
        this.zip = new ZipOutputStream(this.file);
        BufferedReader in = new BufferedReader(new FileReader(inputFile));
        while ((line = in.readLine()) != null) {
            if (line.trim().length() == 0 || line.startsWith("#")) continue;
            if (line.startsWith("export")) {
                exportArray.add(line.substring(6).trim());
                continue;
            }
            if (line.startsWith("exclude")) {
                excludeArray.add(line.substring(7).trim());
                continue;
            }
            if (line.startsWith("include")) {
                includeArray.add(line.substring(7).trim());
                continue;
            }
            if (!line.startsWith("force")) continue;
            forceArray.add(line.substring(5).trim());
        }
        this.exports = new String[exportArray.size()];
        exportArray.toArray(this.exports);
        this.excludes = new String[excludeArray.size()];
        excludeArray.toArray(this.excludes);
        this.includes = new String[includeArray.size()];
        includeArray.toArray(this.includes);
        this.force = new String[forceArray.size()];
        forceArray.toArray(this.force);
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void close() {
        try {
            this.zip.closeEntry();
            this.zip.close();
            this.file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doExport() throws Exception {
        this.bomAPI = new OWBOMFatClient((IOWBOMInternalUseMarker)this, true);
        ZipEntry backup = new ZipEntry("backup.xml");
        backup.setMethod(8);
        this.zip.putNextEntry(backup);
        BufferedOutputStream output = new BufferedOutputStream(this.zip);
        PrintStreamWriter stream = null;
        try {
            stream = new PrintStreamWriter((OutputStream)output, "UTF8");
            System.out.println("Set UTF8 Encoding");
        }
        catch (UnsupportedEncodingException e) {
            stream = new PrintStreamWriter(output);
            System.out.println("Failed to set UTF8 Encoding - Use Default");
        }
        stream.println("<objects date=\"" + new Date() + "\">");
        stream.flush();
        ObjectExportHandler exportHandler = new ObjectExportHandler(this.includes, this.excludes, this.force, output);
        for (int i = 0; i < this.exports.length; ++i) {
            String clazz = this.exports[i];
            Collection v = null;
            try {
                OWBOMQueryAllByClass qbc = new OWBOMQueryAllByClass(clazz, false);
                v = (Collection)this.bomAPI.getObjects((OWBOMQuery)qbc).getReturnObject();
            }
            catch (OWBOMNotFoundException e) {
                // empty catch block
            }
            if (v == null) continue;
            System.out.println("Exporting " + clazz + " instance count: " + v.size());
            if (v.size() <= 0) continue;
            this.progress.setMinValue(0);
            this.progress.setMaxValue(v.size());
            int val = 0;
            this.progress.startTask();
            Iterator it = v.iterator();
            while (it.hasNext()) {
                exportHandler.exportObject(it.next());
                this.progress.setProgress(++val);
            }
            this.progress.endTask();
        }
        stream.println("</objects>");
        stream.flush();
        this.close();
    }

    private void doSecurityTest() {
        this.printObjectGroups(this.bomAPI);
        this.printEquipmentSecurity(this.bomAPI);
        this.printLocationsSecurity(this.bomAPI);
    }

    private void printObjectGroups(IOWBOMClient pBOM) {
        try {
            OWBOMQueryAllByClass qbc = new OWBOMQueryAllByClass(OWObjectGroup.class.getName());
            Vector results = (Vector)pBOM.getObjects((OWBOMQuery)qbc).getRtnObject();
            for (OWObjectGroup objGroup : results) {
                System.out.println("==========  ObjectGroup: " + objGroup.getGroupID());
            }
        }
        catch (OWBOMNotFoundException nfe) {
            System.out.println("==========  NO Object Groups!");
        }
        catch (OWBOMAPIException bome) {
            bome.printStackTrace();
        }
    }

    private void printEquipmentSecurity(IOWBOMClient pBOM) {
        try {
            RCBOMInternalUseMarker marker = RCBOMInternalUseMarker.getInstance();
            OWBOMQueryAllByClass qba = new OWBOMQueryAllByClass(Equipment.class.getName(), false);
            Collection devices = (Collection)pBOM.getObjects((OWBOMQuery)qba).getReturnObject();
            for (Equipment b : devices) {
                OWVector sec = b.getOwareSecurityGroups((IOWBOMInternalUseMarker)marker);
                StringBuffer sb = new StringBuffer();
                sb.append("-------------  Security on: " + b.getName() + " Location is " + (null != b.getLocation() ? b.getLocation().getLocationID() : "NULL") + " --> ");
                for (int i = 0; i < sec.size(); ++i) {
                    sb.append("[" + ((OWObjectGroup)sec.get(i)).getGroupID() + "]");
                    sb.append("   ");
                }
                System.out.println(sb.toString());
            }
        }
        catch (OWBOMNotFoundException nfe) {
            System.out.println("==========  NO Equipments!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printLocationsSecurity(IOWBOMClient pBOM) {
        try {
            RCBOMInternalUseMarker marker = RCBOMInternalUseMarker.getInstance();
            OWBOMQueryAllByClass qba = new OWBOMQueryAllByClass(Location.class.getName(), false);
            Collection locations = (Collection)pBOM.getObjects((OWBOMQuery)qba).getReturnObject();
            for (Location b : locations) {
                OWVector sec = b.getOwareSecurityGroups((IOWBOMInternalUseMarker)marker);
                StringBuffer sb = new StringBuffer();
                sb.append("-------------  Security on location: " + b.getLocationID() + " --> ");
                for (int i = 0; i < sec.size(); ++i) {
                    sb.append("[" + ((OWObjectGroup)sec.get(i)).getGroupID() + "]");
                    sb.append("   ");
                }
                System.out.println(sb.toString());
            }
        }
        catch (OWBOMNotFoundException nfe) {
            System.out.println("==========  NO Locations!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

