/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup.migration;

import com.ngnms.setup.migration.ProgressObserver;

public class ConsoleProgressObserver
implements ProgressObserver {
    private String message;
    private int value;
    private int minValue;
    private int maxValue;
    private long startTime = 0L;

    public void endTask() {
        System.out.println();
        long timeDiff = (System.currentTimeMillis() - this.startTime) / 1000L;
        long hours = timeDiff / 3600L;
        long minutes = (timeDiff %= 3600L) / 60L;
        timeDiff %= 60L;
        System.out.print("Completed in ");
        if (hours > 0L) {
            System.out.print(hours + ":");
        }
        System.out.println(minutes + "m" + timeDiff + "s");
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public void setProgress(int value) {
        int percent = (value - this.minValue) * 40 / (this.maxValue - this.minValue);
        StringBuffer out = new StringBuffer();
        out.append(' ');
        for (int i = 0; i < percent; ++i) {
            out.append('.');
        }
        System.out.print(out.toString());
        System.out.print("\r");
    }

    public void startTask() {
        System.out.println("0%        25%       50%       75%      100%");
        System.out.println(" |         |         |         |        | ");
        this.startTime = System.currentTimeMillis();
    }
}

