/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup.jar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class JarPatcher {
    private static final String PREPEND = "_prepend.";
    private static final String APPEND = "_append.";

    public static void patchJarFromJar(String jarFile, String jarPatch) throws IOException {
        System.out.println("Patching " + jarFile + " from\n " + "         " + jarPatch);
        ZipPatchSource source = new ZipPatchSource(jarPatch);
        JarPatcher.patchJarFromSource(jarFile, source);
        source.close();
    }

    public static void patchJarFromFolder(String jarFile, String jarFolder) throws IOException {
        System.out.println("Patching " + jarFile + " from\n " + "         " + jarFolder);
        FolderPatchSource source = new FolderPatchSource(jarFolder);
        JarPatcher.patchJarFromSource(jarFile, source);
        source.close();
    }

    private static boolean isDirectory(String entryName) {
        return entryName.endsWith("/");
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buff = new byte[10240];
        while ((read = in.read(buff)) > 0) {
            out.write(buff, 0, read);
        }
        out.flush();
    }

    private static void patchJarFromSource(String jarFile, PatchSource source) throws IOException {
        ZipEntry destEntry;
        ZipEntry currentEntry;
        File tempFile = File.createTempFile("avpatcher", "patch");
        File sourceFile = new File(jarFile);
        Collection patchEntries = source.getEntries();
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tempFile));
        ZipInputStream sourceIn = new ZipInputStream(new FileInputStream(sourceFile));
        byte[] buff = new byte[10240];
        while ((currentEntry = sourceIn.getNextEntry()) != null) {
            String entryName = currentEntry.getName();
            if (!currentEntry.isDirectory()) {
                InputStream in;
                int lastSlashIndex = entryName.lastIndexOf(47) + 1;
                String prependEntryName = entryName.substring(0, lastSlashIndex) + PREPEND + entryName.substring(lastSlashIndex);
                String appendEntryName = entryName.substring(0, lastSlashIndex) + APPEND + entryName.substring(lastSlashIndex);
                if (patchEntries.contains(entryName)) {
                    System.out.println("Patching " + entryName);
                    in = source.getInputStream(entryName);
                    destEntry = new ZipEntry(entryName);
                    out.putNextEntry(destEntry);
                    JarPatcher.copyStream(in, out);
                    in.close();
                    out.closeEntry();
                    patchEntries.remove(entryName);
                    continue;
                }
                if (patchEntries.contains(prependEntryName)) {
                    System.out.println("Prepending " + entryName);
                    in = source.getInputStream(prependEntryName);
                    destEntry = new ZipEntry(entryName);
                    out.putNextEntry(destEntry);
                    JarPatcher.copyStream(in, out);
                    JarPatcher.copyStream(sourceIn, out);
                    in.close();
                    out.closeEntry();
                    patchEntries.remove(prependEntryName);
                    continue;
                }
                if (patchEntries.contains(appendEntryName)) {
                    System.out.println("Appending " + entryName);
                    in = source.getInputStream(appendEntryName);
                    destEntry = new ZipEntry(entryName);
                    out.putNextEntry(destEntry);
                    JarPatcher.copyStream(sourceIn, out);
                    JarPatcher.copyStream(in, out);
                    in.close();
                    out.closeEntry();
                    patchEntries.remove(appendEntryName);
                    continue;
                }
                destEntry = new ZipEntry(currentEntry);
                out.putNextEntry(destEntry);
                JarPatcher.copyStream(sourceIn, out);
                out.closeEntry();
                continue;
            }
            destEntry = new ZipEntry(currentEntry);
            out.putNextEntry(destEntry);
            out.closeEntry();
            patchEntries.remove(entryName);
        }
        for (String entryName : patchEntries) {
            System.out.println("Adding " + entryName);
            if (JarPatcher.isDirectory(entryName)) {
                destEntry = new ZipEntry(entryName);
                out.putNextEntry(destEntry);
                out.closeEntry();
                continue;
            }
            destEntry = new ZipEntry(entryName);
            out.putNextEntry(destEntry);
            InputStream in = source.getInputStream(entryName);
            JarPatcher.copyStream(in, out);
            in.close();
            out.closeEntry();
        }
        out.close();
        sourceIn.close();
        System.out.println("Replacing orginal jar");
        sourceFile.delete();
        int read = -1;
        FileInputStream copyIn = new FileInputStream(tempFile);
        FileOutputStream copyOut = new FileOutputStream(sourceFile);
        while ((read = copyIn.read(buff)) > 0) {
            copyOut.write(buff, 0, read);
        }
        copyOut.flush();
        copyOut.close();
        copyIn.close();
        System.out.println("Done");
    }

    public static final void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java com.ngnms.setup.jar.JarPatcher <source jar> <patch jar>");
            System.out.println("\t<source jar> is the jar to be patched");
            System.out.println("\t<patch jar>  is the jar that contains the patches");
            System.exit(9999);
        } else {
            try {
                File from;
                File to = new File(args[0]);
                if (!to.exists() || !to.isFile()) {
                    System.out.println("Jar to patch does not exist.");
                    System.exit(1);
                }
                if ((from = new File(args[1])).exists()) {
                    if (from.isFile()) {
                        JarPatcher.patchJarFromJar(args[0], args[1]);
                    } else {
                        JarPatcher.patchJarFromFolder(args[0], args[1]);
                    }
                } else {
                    System.out.println("Patch jar/folder does not exist.");
                    System.exit(1);
                }
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static class FolderPatchSource
    implements PatchSource {
        private File root = null;
        private String rootFileName = null;
        private Vector entries = new Vector();

        public FolderPatchSource(String rootName) throws IOException {
            this.root = new File(rootName);
            this.rootFileName = this.root.getAbsolutePath().replace('\\', '/');
            if (!this.rootFileName.endsWith("/")) {
                this.rootFileName = this.rootFileName + "/";
            }
            this.entries.addAll(this.getRecursiveListing(this.root));
        }

        private List getRecursiveListing(File folder) throws IOException {
            ArrayList<String> ret = new ArrayList<String>();
            File[] files = folder.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i].getAbsolutePath().replace('\\', '/');
                fileName = fileName.substring(this.rootFileName.length());
                if (files[i].isDirectory() && !fileName.endsWith("/")) {
                    fileName = fileName + "/";
                }
                ret.add(fileName);
                if (!files[i].isDirectory()) continue;
                ret.addAll(this.getRecursiveListing(files[i]));
            }
            return ret;
        }

        public Collection getEntries() {
            return this.entries;
        }

        public InputStream getInputStream(String entryName) throws IOException {
            return new FileInputStream(new File(this.root, entryName));
        }

        public void close() {
        }
    }

    private static class ZipPatchSource
    implements PatchSource {
        private ZipFile patchZip = null;
        private Vector entries = new Vector();

        public ZipPatchSource(String zipFile) throws IOException {
            this.patchZip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> e = this.patchZip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                this.entries.add(entry.getName());
            }
        }

        public Collection getEntries() throws IOException {
            return this.entries;
        }

        public InputStream getInputStream(String entryName) throws IOException {
            return this.patchZip.getInputStream(this.patchZip.getEntry(entryName));
        }

        public void close() throws IOException {
            this.patchZip.close();
        }
    }

    private static interface PatchSource {
        public Collection getEntries() throws IOException;

        public InputStream getInputStream(String var1) throws IOException;

        public void close() throws IOException;
    }
}

