/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup.dbtools.oracle;

import com.ngnms.setup.dbtools.oracle.Repository;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipRepository
implements Repository {
    private String fileName;
    private ZipFile zipFile;
    private ZipOutputStream zipStream;
    private ZipEntry currentEntry = null;

    public ZipRepository(String pFileName) {
        this.fileName = pFileName;
    }

    public void closeRepository() throws IOException {
        if (this.zipFile != null) {
            this.zipFile.close();
        }
        if (this.zipStream != null) {
            if (this.currentEntry != null) {
                this.zipStream.closeEntry();
            }
            this.zipStream.close();
        }
    }

    public synchronized InputStream getInputStream(String pFileName) throws IOException {
        this.currentEntry = this.zipFile.getEntry(pFileName);
        return this.currentEntry != null ? this.zipFile.getInputStream(this.currentEntry) : null;
    }

    public synchronized OutputStream getOutputStream(String pFileName) throws IOException {
        if (this.currentEntry != null) {
            this.zipStream.closeEntry();
        }
        this.currentEntry = new ZipEntry(pFileName);
        this.currentEntry.setMethod(8);
        this.zipStream.putNextEntry(this.currentEntry);
        return this.zipStream;
    }

    public void openRepository(int pOperation) throws IOException {
        switch (pOperation) {
            case 1: {
                this.zipStream = new ZipOutputStream(new FileOutputStream(this.fileName));
                break;
            }
            case 2: {
                this.zipFile = new ZipFile(this.fileName);
            }
        }
    }
}

