/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup.dbtools.oracle;

import com.ngnms.setup.dbtools.oracle.Repository;
import com.ngnms.setup.migration.Base64Decoder;
import com.ngnms.setup.migration.Base64Encoder;
import com.ngnms.setup.migration.Base64FormatException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class OracleHandler {
    private static final String JDBC_DRIVER = "oracle.jdbc.OracleDriver";
    private static final String NULL_STR = "<null>";
    private Connection conn;
    private String username;
    private Repository repository;
    private PrintWriter log;
    private HashSet excludeTables;

    public OracleHandler(String pConnUrl, String pUserName, String pPassword, Repository pRepository) throws SQLException, IOException {
        this.username = pUserName;
        this.repository = pRepository;
        try {
            Class.forName(JDBC_DRIVER);
            this.conn = DriverManager.getConnection(pConnUrl, pUserName, pPassword);
            System.out.println("Connection OK");
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            e.printStackTrace();
        }
        this.excludeTables = new HashSet();
        this.excludeTables.add("OWARE_BASE_CLASS_TABLE_MAP");
        this.excludeTables.add("OWARE_BASE_CLS_TREE");
    }

    public HashMap getSchema() throws SQLException {
        Vector<String> tables = new Vector<String>();
        this.log("Getting table names... ");
        DatabaseMetaData meta = this.conn.getMetaData();
        ResultSet rs = meta.getTables(null, this.username.toUpperCase(), null, new String[]{"TABLE"});
        while (rs.next()) {
            tables.add(rs.getString("TABLE_NAME"));
        }
        rs.close();
        this.log("Got table names: " + tables.size() + " tables.");
        HashMap<String, HashMap> ret = new HashMap<String, HashMap>();
        int tableCount = tables.size();
        int tableNo = 0;
        for (String tableName : tables) {
            this.log("Examining table " + tableName);
            ret.put(tableName, this.getFields(meta, tableName));
            ++tableNo;
        }
        return ret;
    }

    public long exportTable(HashMap pSchema, String pTableName, OutputStream out) throws SQLException, IOException {
        HashMap fields = (HashMap)pSchema.get(pTableName);
        String[] fieldNames = new String[fields.size()];
        int[] fieldTypes = new int[fields.size()];
        int k = 0;
        for (DBField field : fields.values()) {
            fieldNames[k] = field.name;
            fieldTypes[k++] = field.type;
        }
        Statement stat = this.conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM " + pTableName);
        PrintWriter pOut = new PrintWriter(out);
        for (int i = 0; i < fieldNames.length; ++i) {
            pOut.print(fieldNames[i] + " " + fieldTypes[i] + "\t");
        }
        pOut.println();
        long recordCount = 0L;
        while (rs.next()) {
            ++recordCount;
            for (int i = 0; i < fieldNames.length; ++i) {
                switch (fieldTypes[i]) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        long longValue = rs.getLong(fieldNames[i]);
                        if (!rs.wasNull()) {
                            pOut.print(longValue);
                            break;
                        }
                        pOut.print(NULL_STR);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        double doubleValue = rs.getDouble(fieldNames[i]);
                        if (!rs.wasNull()) {
                            pOut.print(doubleValue);
                            break;
                        }
                        pOut.print(NULL_STR);
                        break;
                    }
                    case 1: 
                    case 12: {
                        String strValue = rs.getString(fieldNames[i]);
                        if (!rs.wasNull()) {
                            pOut.print('\"' + new Base64Encoder(strValue).processString() + '\"');
                            break;
                        }
                        pOut.print(NULL_STR);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1111: 
                    case 2004: 
                    case 2005: {
                        pOut.flush();
                        out.flush();
                        InputStream streamValue = rs.getBinaryStream(fieldNames[i]);
                        if (!rs.wasNull()) {
                            pOut.print("\"");
                            pOut.flush();
                            Base64Encoder encoder = new Base64Encoder(streamValue, out);
                            encoder.process();
                            out.flush();
                            pOut.print("\"");
                            pOut.flush();
                            break;
                        }
                        pOut.print(NULL_STR);
                        break;
                    }
                    case 91: {
                        Date dateValue = rs.getDate(fieldNames[i]);
                        if (!rs.wasNull()) {
                            pOut.print(dateValue.getTime());
                            break;
                        }
                        pOut.print(NULL_STR);
                        break;
                    }
                    case 93: {
                        Timestamp timeStampValue = rs.getTimestamp(fieldNames[i]);
                        if (!rs.wasNull()) {
                            pOut.print(timeStampValue.toString());
                            break;
                        }
                        pOut.print(NULL_STR);
                        break;
                    }
                    default: {
                        System.out.println("Unsupported data type: " + fieldNames[i] + " " + fieldTypes[i]);
                        pOut.print(NULL_STR);
                    }
                }
                pOut.print("\t");
            }
            pOut.println();
        }
        stat.close();
        pOut.flush();
        out.flush();
        return recordCount;
    }

    private long importTable(HashMap pSchema, String pTableName, InputStream in) throws SQLException, IOException {
        HashMap fields = (HashMap)pSchema.get(pTableName);
        BufferedReader bin = new BufferedReader(new InputStreamReader(in));
        String line = bin.readLine();
        StringTokenizer tokenizer = new StringTokenizer(line, " \t");
        int fileFieldCount = tokenizer.countTokens() / 2;
        DBField[] fileFields = new DBField[fileFieldCount];
        boolean[] fileFieldExists = new boolean[fileFieldCount];
        for (int i = 0; i < fileFieldCount; ++i) {
            fileFields[i] = new DBField(tokenizer.nextToken(), Integer.parseInt(tokenizer.nextToken()));
            DBField dbField = (DBField)fields.get(fileFields[i].name);
            if (dbField != null) {
                fileFieldExists[i] = true;
                if (dbField.type == fileFields[i].type) continue;
                throw new SQLException("Field type has changed! " + fileFields[i].name + " " + fileFields[i].type + " new: " + dbField.type);
            }
            fileFieldExists[i] = false;
            this.log("\tField was dropped: " + fileFields[i].name);
        }
        String sql = "INSERT INTO " + pTableName + "(";
        String values = " VALUES (";
        for (int i = 0; i < fileFields.length; ++i) {
            if (!fileFieldExists[i]) continue;
            sql = sql + fileFields[i].name + ",";
            values = values + "?,";
        }
        if (!sql.endsWith(",")) {
            this.log("No fields to import!");
            return 0L;
        }
        sql = sql.substring(0, sql.length() - 1);
        values = values.substring(0, values.length() - 1);
        sql = sql + ")" + values + ")";
        Statement delStat = this.conn.createStatement();
        delStat.execute("DELETE FROM " + pTableName);
        delStat.close();
        PreparedStatement stat = this.conn.prepareStatement(sql);
        int recordCount = 0;
        while ((line = bin.readLine()) != null) {
            ++recordCount;
            tokenizer = new StringTokenizer(line, "\t");
            int paramIdx = 1;
            Vector<ByteArrayInputStream> inputStreams = new Vector<ByteArrayInputStream>();
            for (int i = 0; i < fileFields.length; ++i) {
                String fieldValue = tokenizer.nextToken();
                if (!fileFieldExists[i]) continue;
                if (NULL_STR.equals(fieldValue)) {
                    if (1111 == fileFields[i].type) {
                        stat.setNull(paramIdx, -2);
                    } else {
                        stat.setNull(paramIdx, fileFields[i].type);
                    }
                } else {
                    switch (fileFields[i].type) {
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            long longValue = Long.parseLong(fieldValue);
                            stat.setLong(paramIdx, longValue);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: 
                        case 8: {
                            double doubleValue = Double.parseDouble(fieldValue);
                            stat.setDouble(paramIdx, doubleValue);
                            break;
                        }
                        case 1: 
                        case 12: {
                            try {
                                Base64Decoder decoder = new Base64Decoder(fieldValue.substring(1, fieldValue.length() - 1));
                                fieldValue = decoder.processString();
                                stat.setString(paramIdx, fieldValue);
                                break;
                            }
                            catch (Exception e) {
                                throw new SQLException(e.getMessage() + ": " + fileFields[i].name + " " + fieldValue);
                            }
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case -1: 
                        case 1111: 
                        case 2004: 
                        case 2005: {
                            ByteArrayOutputStream output = new ByteArrayOutputStream();
                            ByteArrayInputStream b64In = new ByteArrayInputStream(fieldValue.substring(1, fieldValue.length() - 1).getBytes());
                            Base64Decoder decoder = new Base64Decoder(b64In, output);
                            try {
                                decoder.process();
                            }
                            catch (Base64FormatException e) {
                                throw new SQLException(e.getMessage());
                            }
                            output.flush();
                            byte[] outputBytes = output.toByteArray();
                            ByteArrayInputStream inStream = new ByteArrayInputStream(outputBytes);
                            inputStreams.add(inStream);
                            stat.setBinaryStream(paramIdx, (InputStream)inStream, outputBytes.length);
                            break;
                        }
                        case 91: {
                            Date dateValue = new Date(Long.parseLong(fieldValue));
                            stat.setDate(paramIdx, dateValue);
                            break;
                        }
                        case 93: {
                            Timestamp timeStampValue = Timestamp.valueOf(fieldValue);
                            stat.setTimestamp(paramIdx, timeStampValue);
                            break;
                        }
                        default: {
                            System.out.println("Unsupported data type: " + fileFields[i].name + " " + fileFields[i].type);
                        }
                    }
                }
                ++paramIdx;
            }
            stat.executeUpdate();
            inputStreams.clear();
        }
        stat.close();
        return recordCount;
    }

    public void setConstraintsActive(boolean pActive) throws SQLException {
        String action = pActive ? "ENABLE" : "DISABLE";
        PreparedStatement stat = this.conn.prepareStatement("SELECT OBJECT_NAME FROM USER_OBJECTS WHERE OBJECT_TYPE='TRIGGER'");
        ResultSet rs = stat.executeQuery();
        Vector<String> triggers = new Vector<String>();
        while (rs.next()) {
            triggers.add(rs.getString("OBJECT_NAME"));
        }
        stat.close();
        int triggerCount = triggers.size();
        boolean triggerNo = false;
        for (String triggerName : triggers) {
            Statement stat2 = this.conn.createStatement();
            this.log("Setting trigger " + triggerName + " to " + action);
            stat2.execute("ALTER TRIGGER " + triggerName + " " + action);
            stat2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDB() {
        try {
            this.repository.openRepository(1);
            HashMap schema = this.getSchema();
            TreeSet sortedNames = new TreeSet();
            sortedNames.addAll(schema.keySet());
            for (String tableName : sortedNames) {
                if (this.excludeTables.contains(tableName)) continue;
                this.log("Exporting " + tableName + "...");
                OutputStream out = this.repository.getOutputStream(tableName);
                long recordCount = this.exportTable(schema, tableName, out);
                this.log("Exported  " + tableName + ":" + recordCount + " records.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.repository.closeRepository();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importDB() {
        try {
            this.repository.openRepository(2);
            HashMap schema = this.getSchema();
            TreeSet sortedNames = new TreeSet();
            sortedNames.addAll(schema.keySet());
            this.setConstraintsActive(false);
            for (String tableName : sortedNames) {
                this.log("Importing " + tableName + "...");
                InputStream in = this.repository.getInputStream(tableName);
                if (in != null) {
                    long recordCount = this.importTable(schema, tableName, in);
                    this.log("Imported  " + tableName + ": " + recordCount + " records.");
                    continue;
                }
                this.log("No export data found for " + tableName);
            }
            this.setConstraintsActive(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.repository.closeRepository();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private HashMap getFields(DatabaseMetaData pMeta, String pTableName) throws SQLException {
        ResultSet rs = pMeta.getColumns(null, null, pTableName, null);
        HashMap<String, DBField> ret = new HashMap<String, DBField>();
        while (rs.next()) {
            DBField field = new DBField(rs.getString("COLUMN_NAME"), rs.getInt("DATA_TYPE"));
            ret.put(field.name, field);
        }
        rs.close();
        return ret;
    }

    private void log(String pMessage) {
        System.out.println("[" + new java.util.Date() + "] " + pMessage);
    }

    public void close() throws SQLException {
        this.conn.close();
    }

    private static class DBField {
        String name;
        int type;

        public DBField(String pName, int pType) {
            this.name = pName;
            this.type = pType;
        }
    }
}

