/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup.dbtools.oracle;

import com.ngnms.setup.ParamUtil;
import com.ngnms.setup.dbtools.oracle.OracleHandler;
import com.ngnms.setup.dbtools.oracle.ZipRepository;

public class Migrator {
    private static void checkValid(String pParam, String pDesc) {
        if (pParam == null) {
            System.out.println("Error: " + pDesc + " could not be determined.");
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: migrateoracledb -a <import|export> -r <repository>");
    }

    public static final void main(String[] args) {
        String repository;
        String action;
        String password;
        String username;
        String sid = ParamUtil.getArgValue("s", "sid", true, args);
        if (sid == null) {
            String dbUrl = System.getProperty("com.dorado.jdbc.database_name.oracle");
            Migrator.checkValid(dbUrl, "database SID");
            sid = dbUrl.substring(dbUrl.lastIndexOf(":") + 1);
        }
        if ((username = ParamUtil.getArgValue("u", "username", true, args)) == null) {
            username = System.getProperty("com.dorado.jdbc.user");
            Migrator.checkValid(username, "database user name");
        }
        if ((password = ParamUtil.getArgValue("p", "password", true, args)) == null) {
            password = System.getProperty("com.dorado.jdbc.password");
            Migrator.checkValid(password, "database password");
        }
        if ((action = ParamUtil.getArgValue("a", "action", true, args)) == null) {
            Migrator.printUsage();
            System.exit(1);
        }
        if (!"import".equalsIgnoreCase(action) && !"export".equalsIgnoreCase(action)) {
            System.out.println("Error: invalid action " + action);
            System.exit(1);
        }
        if ((repository = ParamUtil.getArgValue("r", "repository", true, args)) == null) {
            Migrator.printUsage();
            System.exit(1);
        }
        String finalUrl = "jdbc:oracle:oci8:" + username + "/" + password + "@" + sid;
        System.out.println("----------------------------");
        System.out.println("DB             : " + finalUrl);
        System.out.println("Repository     : " + repository);
        System.out.println("Action         : " + action);
        System.out.println("----------------------------");
        ZipRepository rep = new ZipRepository(repository);
        try {
            OracleHandler handler = new OracleHandler(finalUrl, username, password, rep);
            if ("import".equalsIgnoreCase(action)) {
                handler.importDB();
            } else {
                handler.exportDB();
            }
            handler.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

