/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup;

import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAPIException;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryAllByClass;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMRequest;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.OWMutatorException;
import com.ngnms.common.AvTrace;
import com.ngnms.setup.AvModule;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class AvModuleUtil {
    public static final String MODULE_ID = "Content-ID";
    public static final String MODULE_DATE = "Content-Date";
    public static final String MODULE_NAME = "Content-Name";
    public static final String MODULE_VERSION = "Content-Version";
    public static final String MODULE_PUBLISHER = "Created-By";
    public static final String MODULE_CLASS = "Content-Class";
    public static final String MODULE_INSTALL_DATE = "Install-Date";
    public static final String MODULE_INSTALL_PATH = "Install-Path";
    public static final String MODULE_INI_FILES = "Ini-Files";
    public static final String MODULE_INITIAL_INSTALL = "Install-Initial-Date";
    public static DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    public static Collection getLocalModules() throws IOException {
        Vector<Properties> ret = new Vector<Properties>();
        File owareapps = new File(System.getProperty("OWARE_USER_ROOT") + "/owareapps");
        File[] apps = owareapps.listFiles();
        for (int i = 0; i < apps.length; ++i) {
            File lib;
            if (!apps[i].isDirectory() || !(lib = new File(apps[i], "lib")).exists()) continue;
            File[] contents = lib.listFiles();
            for (int j = 0; j < contents.length; ++j) {
                if (!contents[j].getName().endsWith("core.jar")) continue;
                JarFile jarFile = new JarFile(contents[j]);
                Manifest mf = jarFile.getManifest();
                Attributes attrs = mf.getMainAttributes();
                String moduleID = attrs.getValue(MODULE_ID);
                if ("NGNMS".equals(moduleID)) {
                    Properties moduleProps = new Properties();
                    moduleProps.setProperty(MODULE_NAME, attrs.getValue(MODULE_NAME));
                    moduleProps.setProperty(MODULE_VERSION, attrs.getValue(MODULE_VERSION));
                    moduleProps.setProperty(MODULE_DATE, attrs.getValue(MODULE_DATE));
                    moduleProps.setProperty(MODULE_INSTALL_PATH, apps[i].getAbsolutePath());
                    moduleProps.setProperty(MODULE_INI_FILES, attrs.getValue(MODULE_INI_FILES));
                    ret.add(moduleProps);
                }
                jarFile.close();
            }
        }
        return ret;
    }

    public static Collection getServerModules(IOWBOMClient bomAPI) throws IOException, OWBOMAPIException, OWMutatorException {
        Collection localModules = AvModuleUtil.getLocalModules();
        ArrayList modules = new ArrayList();
        try {
            OWBOMQueryAllByClass ovq = new OWBOMQueryAllByClass("com.ngnms.setup.AvModule");
            OWBOMRequest request = bomAPI.getObjects((OWBOMQuery)ovq);
            modules = request.getReturnObjects();
        }
        catch (OWBOMNotFoundException ex) {
            AvTrace.traceln("AvSetup", 3, "No AvModules found.");
        }
        Vector<AvModule> _commitList = new Vector<AvModule>();
        for (Properties localModule : localModules) {
            String localVersion = localModule.getProperty(MODULE_VERSION);
            String localClass = localVersion.substring(0, localVersion.indexOf(46));
            AvModule serverModule = null;
            Iterator j = modules.iterator();
            while (j.hasNext() && serverModule == null) {
                AvModule module = (AvModule)j.next();
                String moduleVersion = module.getModuleVersion();
                String moduleClass = moduleVersion.substring(0, moduleVersion.indexOf(46));
                if (!localClass.equals(moduleClass)) continue;
                serverModule = module;
                if (localVersion.equals(moduleVersion)) continue;
                bomAPI.getObjectForUpdate((IOWBean)serverModule);
                serverModule.setModuleVersion(localVersion);
                serverModule.setUpdateDate(new Date());
                _commitList.add(serverModule);
            }
            if (serverModule == null) {
                serverModule = new AvModule();
                serverModule.setModuleVersion(localVersion);
                Date now = new Date();
                serverModule.setInstallDate(now);
                serverModule.setUpdateDate(now);
                _commitList.add(serverModule);
            }
            localModule.setProperty(MODULE_INSTALL_DATE, dateFormat.format(serverModule.getUpdateDate()));
            localModule.setProperty(MODULE_INITIAL_INSTALL, dateFormat.format(serverModule.getInstallDate()));
        }
        if (!_commitList.isEmpty()) {
            bomAPI.commitObjects(_commitList);
            bomAPI.commitAll();
        }
        return localModules;
    }

    public static AvModule getModuleByClass(IOWBOMClient bomAPI, String moduleClass) {
        try {
            OWBOMQueryByAttribs query = new OWBOMQueryByAttribs("com.ngnms.setup.AvModule", new OWBOMAttribValueOperator("ModuleVersion", "LIKE", (Object)(moduleClass + ".*")));
            ArrayList results = bomAPI.getObjects((OWBOMQuery)query).getReturnObjects();
            if (results.size() == 1) {
                return (AvModule)results.iterator().next();
            }
        }
        catch (Exception ex) {
            AvTrace.traceStack("AvSetup", 1, ex);
        }
        return null;
    }
}

