/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup;

import RedCell.RCMenuObject;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQueryByKey;
import com.dorado.runtime.IOWBean;
import com.ngnms.common.AvException;
import com.ngnms.setup.AbstractRedCellImportListener;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import redcell.common.util.RedCellImporter;
import redcell.common.util.RedCellListManager;
import redcell.common.util.RedCellParser;

public class AvMenuCustomizer
extends AbstractRedCellImportListener {
    private Vector deleted = new Vector();
    private static final String CLASS_NAME = "RedCell.RCMenuObject";
    private static final String IDENTIFIER = "menu.name";
    private static final String NAME = "Menu Object";

    public AvMenuCustomizer(RedCellListManager parent, int mode, boolean pWait) {
        if (this.getBOMClient(true)) {
            RedCellImporter _importer = new RedCellImporter(this.bomAPI, parent, mode, IDENTIFIER, NAME, CLASS_NAME);
            this.run(_importer, pWait);
        }
    }

    public AvMenuCustomizer(IOWBOMClient pAPI, RedCellListManager parent, int mode, boolean pWait) {
        this.bomAPI = pAPI;
        RedCellImporter _importer = new RedCellImporter(this.bomAPI, parent, mode, IDENTIFIER, NAME, CLASS_NAME, null, false, null);
        this.run(_importer, pWait);
    }

    public AvMenuCustomizer(String pFileName, boolean pQuiet, int mode, boolean pWait) {
        if (this.getBOMClient(pQuiet)) {
            RedCellImporter _importer = new RedCellImporter(this.bomAPI, pFileName, pQuiet, mode, IDENTIFIER, NAME, CLASS_NAME);
            this.run(_importer, pWait);
        }
    }

    public AvMenuCustomizer(IOWBOMClient pBOMClient, String pFileName, boolean pQuiet, int mode, boolean pWait) {
        this.bomAPI = pBOMClient;
        RedCellImporter _importer = new RedCellImporter(this.bomAPI, pFileName, pQuiet, mode, IDENTIFIER, NAME, CLASS_NAME, null, false, null);
        this.run(_importer, pWait);
    }

    public void importObjectEx(RedCellParser theParser) throws Exception {
        String menuName = null;
        try {
            menuName = theParser.getValue(IDENTIFIER);
            String setProperty = theParser.getValue("set.property");
            String setValue = theParser.getValue("set.value");
            String delete = theParser.getValue("delete");
            OWBOMQueryByKey qbk = new OWBOMQueryByKey(CLASS_NAME, menuName);
            try {
                RCMenuObject menu = (RCMenuObject)this.bomAPI.getObject(qbk).getReturnObject();
                if ("true".equals(delete)) {
                    System.out.println("Deleting menu: " + menuName);
                    this.bomAPI.deleteObject((IOWBean)menu);
                    this.bomAPI.commitAll();
                } else if (setProperty != null && setValue != null) {
                    System.out.println("Updating: " + menuName);
                    this.setProperty(menu, setProperty, setValue);
                    this.bomAPI.commitObject((IOWBean)menu);
                    this.bomAPI.commitAll();
                }
            }
            catch (OWBOMNotFoundException ex) {
                System.out.println("Menu not found: " + menuName);
            }
        }
        catch (Exception ex) {
            System.out.println("Could not customize menu: " + menuName);
            System.out.println(ex.getMessage());
        }
    }

    public void exportObjectEx(RandomAccessFile theFile, Object theObject) {
    }

    public void setProperty(Object bean, String property, String value) throws AvException {
        try {
            String setterName = "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
            Class<?> beanClass = bean.getClass();
            Method[] methods = beanClass.getMethods();
            Method method = null;
            for (int i = 0; i < methods.length && method == null; ++i) {
                if (!methods[i].getName().equals(setterName) || methods[i].getParameterTypes().length != 1) continue;
                method = methods[i];
            }
            if (method == null) {
                throw new AvException("No setter for property: " + property);
            }
            Class<?> paramClass = method.getParameterTypes()[0];
            Object param = this.convert(paramClass, value);
            method.invoke(bean, param);
        }
        catch (AvException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new AvException(ex.getMessage());
        }
    }

    private Object convert(Class clazz, String value) throws Exception {
        if (!clazz.isPrimitive()) {
            Constructor constr;
            try {
                constr = clazz.getConstructor(String.class);
            }
            catch (Exception ex) {
                throw new AvException("No conversion available from String to: " + clazz.getName());
            }
            return constr.newInstance(value);
        }
        String className = clazz.getName();
        if ("byte".equals(className)) {
            return new Byte(value);
        }
        if ("char".equals(className)) {
            return new Character(value.charAt(0));
        }
        if ("short".equals(className)) {
            return new Short(value);
        }
        if ("int".equals(className)) {
            return new Integer(value);
        }
        if ("long".equals(className)) {
            return new Long(value);
        }
        if ("float".equals(className)) {
            return new Float(value);
        }
        if ("double".equals(className)) {
            return new Double(value);
        }
        if ("boolean".equals(className)) {
            return new Boolean(value);
        }
        throw new AvException("No conversion available from String to " + clazz.getName());
    }
}

