/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.setup;

import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.redcell.inventory.base.RCAttributeValuePair;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.OWVector;
import com.ngnms.common.AvException;
import com.ngnms.setup.AbstractRedCellImportListener;
import com.ngnms.setup.AvGenericCustomizerAction;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import redcell.common.util.RedCellImporter;
import redcell.common.util.RedCellListManager;
import redcell.common.util.RedCellParser;

public class AvGenericCustomizer
extends AbstractRedCellImportListener {
    private static final String CLASS_NAME = "";
    private static final String IDENTIFIER = "class.name";
    private static final String NAME = "Customizer";

    public AvGenericCustomizer(RedCellListManager parent, int mode, boolean pWait) {
        if (this.getBOMClient(true)) {
            RedCellImporter _importer = new RedCellImporter(this.bomAPI, parent, mode, IDENTIFIER, NAME, CLASS_NAME);
            this.run(_importer, pWait);
        }
    }

    public AvGenericCustomizer(IOWBOMClient pAPI, RedCellListManager parent, int mode, boolean pWait) {
        this.bomAPI = pAPI;
        RedCellImporter _importer = new RedCellImporter(this.bomAPI, parent, mode, IDENTIFIER, NAME, CLASS_NAME, null, false, null);
        this.run(_importer, pWait);
    }

    public AvGenericCustomizer(String pFileName, boolean pQuiet, int mode, boolean pWait) {
        if (this.getBOMClient(pQuiet)) {
            RedCellImporter _importer = new RedCellImporter(this.bomAPI, pFileName, pQuiet, mode, IDENTIFIER, NAME, CLASS_NAME);
            this.run(_importer, pWait);
        }
    }

    public AvGenericCustomizer(IOWBOMClient pBOMClient, String pFileName, boolean pQuiet, int mode, boolean pWait) {
        this.bomAPI = pBOMClient;
        RedCellImporter _importer = new RedCellImporter(this.bomAPI, pFileName, pQuiet, mode, IDENTIFIER, NAME, CLASS_NAME, null, false, null);
        this.run(_importer, pWait);
    }

    public void importObjectEx(RedCellParser theParser) throws Exception {
        try {
            String className = theParser.getValue(IDENTIFIER);
            String delete = theParser.getValue("delete");
            String customAction = theParser.getValue("action");
            Hashtable attributes = this.getMultipleValuePairs(theParser, "query");
            Hashtable set = this.getMultipleValuePairs(theParser, "set");
            String propertiesAttribute = theParser.getValue("properties.attribute");
            Hashtable addProps = this.getMultipleValuePairs(theParser, "properties.add");
            Vector delProps = this.getMultipleValues(theParser, "properties.del");
            OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs(className);
            Enumeration e = attributes.keys();
            while (e.hasMoreElements()) {
                String attrib = (String)e.nextElement();
                ValuePair vp = (ValuePair)attributes.get(attrib);
                qba.addAttribValueOperator(new OWBOMAttribValueOperator("AND", attrib, vp.getOper(), (Object)vp.getValue()));
            }
            try {
                Vector results = (Vector)this.bomAPI.getObjects((OWBOMQuery)qba).getRtnObject();
                for (int i = 0; i < results.size(); ++i) {
                    IOWBean obj = (IOWBean)results.elementAt(i);
                    try {
                        if ("true".equals(delete)) {
                            System.out.println("Deleting object: " + obj.getClass().getName() + " (" + obj.getKEY() + ")");
                            this.bomAPI.deleteObject(obj);
                            this.bomAPI.commitAll();
                            continue;
                        }
                        System.out.println("Updating: " + obj.getClass().getName() + " (" + obj.getKEY() + ")");
                        Enumeration e2 = set.keys();
                        while (e2.hasMoreElements()) {
                            String setProp = (String)e2.nextElement();
                            ValuePair vp = (ValuePair)set.get(setProp);
                            this.setProperty(obj, setProp, vp.getValue());
                        }
                        if (propertiesAttribute != null && propertiesAttribute.length() > 0) {
                            this.deleteProperties(obj, propertiesAttribute, delProps);
                        }
                        if (propertiesAttribute != null && propertiesAttribute.length() > 0) {
                            this.addProperties(obj, propertiesAttribute, addProps);
                        }
                        if (customAction != null && customAction.trim().length() > 0) {
                            try {
                                AvGenericCustomizerAction act = (AvGenericCustomizerAction)Class.forName(customAction).newInstance();
                                if (act.executeAction(obj)) {
                                    this.bomAPI.commitObject(obj);
                                }
                            }
                            catch (Exception e3) {
                                e3.printStackTrace();
                            }
                        } else {
                            this.bomAPI.commitObject(obj);
                        }
                        this.bomAPI.commitAll();
                        continue;
                    }
                    catch (Exception ex) {
                        System.out.println("Could not update: " + obj.getClass().getName() + " (" + obj.getKEY() + ")");
                        ex.printStackTrace();
                    }
                }
            }
            catch (OWBOMNotFoundException ex) {
                System.out.println("Obj not found.");
            }
        }
        catch (Exception ex) {
            System.out.println("Something went wrong.");
            ex.printStackTrace();
        }
    }

    public void exportObjectEx(RandomAccessFile theFile, Object theObject) {
    }

    private Vector getMultipleValues(RedCellParser theParser, String prefix) {
        Vector<String> ret = new Vector<String>();
        String attribKey = prefix + ".attrib";
        String attrib = theParser.getValue(attribKey);
        if (attrib == null) {
            int i = 1;
            attrib = theParser.getValue(attribKey + "." + i);
            while (attrib != null) {
                ret.add(attrib);
                attrib = theParser.getValue(attribKey + "." + ++i);
            }
        } else {
            ret.add(attrib);
        }
        return ret;
    }

    private Hashtable getMultipleValuePairs(RedCellParser theParser, String prefix) {
        Hashtable<String, ValuePair> ret = new Hashtable<String, ValuePair>();
        String attribKey = prefix + ".attrib";
        String valueKey = prefix + ".value";
        String operKey = prefix + ".oper";
        String attrib = theParser.getValue(attribKey);
        String value = theParser.getValue(valueKey);
        String oper = theParser.getValue(operKey);
        if (attrib == null || attrib.trim().length() == 0) {
            int i = 1;
            attrib = theParser.getValue(attribKey + "." + i);
            value = theParser.getValue(valueKey + "." + i);
            oper = theParser.getValue(operKey + "." + i);
            if (oper == null || oper.trim().length() == 0) {
                oper = "=";
            }
            while (attrib != null && attrib.trim().length() > 0) {
                ret.put(attrib, new ValuePair(attrib, value, oper));
                System.out.println("Got: " + attrib + " " + oper + " " + value);
                attrib = theParser.getValue(attribKey + "." + ++i);
                value = theParser.getValue(valueKey + "." + i);
                oper = theParser.getValue(operKey + "." + i);
                if (oper != null && oper.trim().length() != 0) continue;
                oper = "=";
            }
        } else {
            ret.put(attrib, new ValuePair(attrib, value, oper));
            System.out.println("Got: " + attrib + " " + oper + " " + value);
        }
        return ret;
    }

    private void addProperties(Object bean, String propAttrib, Hashtable props) throws AvException {
        try {
            OWVector propVector = (OWVector)this.getProperty(bean, propAttrib);
            Enumeration e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                ValuePair vp = (ValuePair)props.get(key);
                String value = vp.getValue();
                boolean updateFlag = false;
                for (int j = 0; j < propVector.size(); ++j) {
                    RCAttributeValuePair avp = (RCAttributeValuePair)propVector.elementAt(j);
                    if (!avp.getAttributeName().equals(key)) continue;
                    avp.setValue(value);
                    System.out.println("Updated property: " + avp.getAttributeName());
                    updateFlag = true;
                    break;
                }
                if (updateFlag) continue;
                RCAttributeValuePair avp = new RCAttributeValuePair();
                avp.setAttributeName(key);
                avp.setValue(value);
                propVector.add((IOWBean)avp);
                System.out.println("Added property: " + key + " = " + value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new AvException(ex.getMessage());
        }
    }

    private void deleteProperties(Object bean, String propAttrib, Vector props) throws AvException {
        try {
            OWVector propVector = (OWVector)this.getProperty(bean, propAttrib);
            Iterator i = props.iterator();
            block2: while (i.hasNext()) {
                String delProp = (String)i.next();
                for (int j = 0; j < propVector.size(); ++j) {
                    RCAttributeValuePair avp = (RCAttributeValuePair)propVector.elementAt(j);
                    if (!avp.getAttributeName().equals(delProp)) continue;
                    propVector.remove((IOWBean)avp);
                    i.remove();
                    System.out.println("Deleted property: " + avp.getAttributeName());
                    continue block2;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new AvException(ex.getMessage());
        }
    }

    public Object getProperty(Object bean, String property) throws AvException {
        try {
            Class<?> beanClass = bean.getClass();
            String getterName = "get" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
            Method method = beanClass.getMethod(getterName, new Class[0]);
            if (method == null) {
                throw new AvException("No getter for property: " + property);
            }
            Object ret = method.invoke(bean, new Object[0]);
            return ret;
        }
        catch (AvException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AvException(ex.getMessage());
        }
    }

    public void setProperty(Object bean, String property, String value) throws AvException {
        try {
            String setterName = "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
            Class<?> beanClass = bean.getClass();
            Method[] methods = beanClass.getMethods();
            Method method = null;
            for (int i = 0; i < methods.length && method == null; ++i) {
                if (!methods[i].getName().equals(setterName) || methods[i].getParameterTypes().length != 1) continue;
                method = methods[i];
            }
            if (method == null) {
                throw new AvException("No setter for property: " + property);
            }
            Class<?> paramClass = method.getParameterTypes()[0];
            Object param = this.convert(paramClass, value);
            method.invoke(bean, param);
        }
        catch (AvException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new AvException(ex.getMessage());
        }
    }

    private Object convert(Class clazz, String value) throws Exception {
        if (!clazz.isPrimitive()) {
            Constructor constr;
            try {
                constr = clazz.getConstructor(String.class);
            }
            catch (Exception ex) {
                throw new AvException("No conversion available from String to: " + clazz.getName());
            }
            return constr.newInstance(value);
        }
        String className = clazz.getName();
        if ("byte".equals(className)) {
            return new Byte(value);
        }
        if ("char".equals(className)) {
            return new Character(value.charAt(0));
        }
        if ("short".equals(className)) {
            return new Short(value);
        }
        if ("int".equals(className)) {
            return new Integer(value);
        }
        if ("long".equals(className)) {
            return new Long(value);
        }
        if ("float".equals(className)) {
            return new Float(value);
        }
        if ("double".equals(className)) {
            return new Double(value);
        }
        if ("boolean".equals(className)) {
            return new Boolean(value);
        }
        throw new AvException("No conversion available from String to " + clazz.getName());
    }

    private class ValuePair {
        private String attrib;
        private String value;
        private String oper;

        public ValuePair(String attrib, String value, String oper) {
            this.attrib = attrib;
            this.value = value;
            this.oper = oper;
        }

        public String getAttrib() {
            return this.attrib;
        }

        public String getValue() {
            return this.value;
        }

        public String getOper() {
            return this.oper;
        }
    }
}

