/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.services.sms;

import com.dorado.common.collections.OWAVPVector;
import com.dorado.common.utility.OWAttributeValuePair;
import com.dorado.core.mediation.snmp.OWSNMPRuntimeException;
import com.dorado.core.mediation.snmp.OWSnmpTxlateUtility;
import com.dorado.core.mediation.snmp.OWVarBind;
import com.ngnms.common.AvException;
import com.ngnms.common.AvSnmpLeaf;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvWorkSpace;
import com.ngnms.services.common.AvMOUtil;
import com.ngnms.services.common.AvServiceUtil;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class AvSMSUtil {
    private static Hashtable prefixMap = new Hashtable();
    private static Hashtable keywordMap = new Hashtable();

    public static void initializeFromWorkSpace() throws AvException {
        AvWorkSpace wrkSpc = null;
        try {
            wrkSpc = AvWorkSpace.getAndLockWorkSpace("AvSMS_WorkSpace", AvServiceUtil.getWorkSpaceTimeout());
            prefixMap = (Hashtable)wrkSpc.getObject("LeafNames");
            keywordMap = (Hashtable)wrkSpc.getObject("SnmpKeywords");
            wrkSpc.closeWorkSpace();
        }
        catch (AvException we) {
            if (null != wrkSpc) {
                try {
                    wrkSpc.closeWorkSpace();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new AvException((Throwable)((Object)we), "Failed to initialize AvLeaf attributes");
        }
    }

    public static void initSnmpLeafAttributes(String pProductLine, OWAVPVector pVec) throws AvException {
        AvTrace.traceln("AvSMS", 3, "initSnmpLeafAttributes: attributes for " + pProductLine + ": ");
        if (prefixMap == null) {
            AvSMSUtil.initializeFromWorkSpace();
        }
        Vector prefixes = null;
        Hashtable keywords = null;
        if (null != pProductLine) {
            prefixes = (Vector)prefixMap.get(pProductLine);
            keywords = (Hashtable)keywordMap.get(pProductLine);
        }
        for (OWAttributeValuePair attr : pVec) {
            String newName;
            String attrName = attr.getAttributeName();
            if (!attrName.startsWith("AvLeaf_")) continue;
            attrName = attrName.substring(7);
            OWVarBind vb = null;
            if (keywords != null && (newName = (String)keywords.get(attrName)) != null) {
                AvTrace.traceln("AvSMS", 3, "Replaced: " + attrName + " with " + newName);
                attrName = newName;
            }
            if (prefixes != null) {
                Iterator p = prefixes.iterator();
                while (p.hasNext()) {
                    try {
                        vb = new OWVarBind((String)p.next() + attrName);
                        break;
                    }
                    catch (OWSNMPRuntimeException x) {
                    }
                }
            }
            if (vb == null) {
                try {
                    vb = new OWVarBind(attrName);
                }
                catch (OWSNMPRuntimeException x) {
                    throw new AvException("Failed to resolve attribute \"" + AvMOUtil.getClassNameFromMOAVPVNoExp(pVec) + ".AvLeaf_" + attrName + "\"");
                }
            }
            Object data = null;
            if (attr.getValue() instanceof AvSnmpLeaf) {
                data = ((AvSnmpLeaf)attr.getValue()).getData();
            } else if (attr.getValue() != null) {
                data = attr.getValue();
            }
            AvSnmpLeaf leaf = new AvSnmpLeaf(vb.getOidWOInstance(), vb.getNameWOInstance(), vb.getType(), data);
            attr.setNewValue((Object)leaf, false, attr.hasChanged());
            AvTrace.traceln("AvSMS", 3, "  " + attr.getAttributeName() + " = " + leaf.toString());
        }
    }

    public static String getAttrNameFromMIB(String pProductLine, String pAttrName) throws AvException {
        String newName = null;
        Vector prefixes = (Vector)prefixMap.get(pProductLine);
        Hashtable keywords = (Hashtable)keywordMap.get(pProductLine);
        if (keywords != null) {
            newName = (String)keywords.get(pAttrName);
        }
        if (newName == null) {
            newName = pAttrName;
        }
        if (prefixes != null) {
            Iterator p = prefixes.iterator();
            while (p.hasNext()) {
                String prefNewName = (String)p.next() + newName;
                try {
                    String oid = OWSnmpTxlateUtility.mapNameToOid((String)prefNewName);
                    if (oid == null || "".equals(oid)) continue;
                    return prefNewName;
                }
                catch (OWSNMPRuntimeException e) {
                }
            }
        }
        try {
            String oid = OWSnmpTxlateUtility.mapNameToOid((String)newName);
            if (oid != null && !"".equals(oid)) {
                return newName;
            }
        }
        catch (OWSNMPRuntimeException e) {
            // empty catch block
        }
        throw new AvException("Failed to resolve attribute \"" + pAttrName);
    }
}

