/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.services.ndm;

import com.ngnms.services.ndm.AvIPBaseRange;
import com.ngnms.services.ndm.AvIPSubnetIterator;
import com.ngnms.services.ndm.AvIPUtil;
import java.util.Iterator;
import redcell.common.util.RedCellIPUtil;

public class AvIPSubnet
extends AvIPBaseRange {
    public AvIPSubnet(String pSubnetAddress, String pSubnetMask) {
        super(pSubnetAddress, pSubnetMask);
    }

    public Iterator ipAddresses() {
        return new AvIPSubnetIterator(this.getValue1(), this.getValue2());
    }

    public boolean containsIP(String pIPAddress) {
        long startIpAddress = AvIPUtil.getRealFirstIpAddressLong(this.getValue1(), this.getValue1());
        long endIpAddress = AvIPUtil.getRealLastIpAddressLong(this.getValue1(), this.getValue2());
        long ipAddress = RedCellIPUtil.convertIPAddressToNumber((String)pIPAddress);
        return startIpAddress <= ipAddress && endIpAddress >= ipAddress;
    }

    public String getFirstIpAddress() {
        return AvIPUtil.getRealFirstIpAddressString(this.getValue1(), this.getValue2());
    }

    public String getLastIpAddress() {
        return AvIPUtil.getRealLastIpAddressString(this.getValue1(), this.getValue2());
    }

    public int size() {
        long startIpAddress = AvIPUtil.getRealFirstIpAddressLong(this.getValue1(), this.getValue1());
        long endIpAddress = AvIPUtil.getRealLastIpAddressLong(this.getValue1(), this.getValue2());
        return (int)(endIpAddress - startIpAddress);
    }

    public String toString() {
        return this.getValue1() + " (" + this.getValue2() + ")";
    }
}

