/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.services.ndm;

import com.ngnms.services.ndm.AvIPBaseRange;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import redcell.common.util.RedCellIPUtil;

public class AvIPSortedSet
extends AvIPBaseRange {
    private TreeSet ipAddresses = new TreeSet(new IPCompare());

    public Iterator ipAddresses() {
        return this.ipAddresses.iterator();
    }

    public boolean containsIP(String pIPAddress) {
        return this.ipAddresses.contains(pIPAddress);
    }

    public String getValue1() {
        try {
            return (String)this.ipAddresses.first();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getValue2() {
        try {
            return (String)this.ipAddresses.last();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public boolean equals(AvIPBaseRange pRange) {
        if (!(pRange instanceof AvIPSortedSet)) {
            return false;
        }
        return this.ipAddresses.equals(((AvIPSortedSet)pRange).ipAddresses);
    }

    public void add(String pIPAddress) {
        this.ipAddresses.add(pIPAddress);
    }

    public void addAll(Collection pIPAddresses) {
        this.ipAddresses.addAll(pIPAddresses);
    }

    public void clear() {
        this.ipAddresses.clear();
    }

    public void remove(String pIPAddress) {
        this.ipAddresses.remove(pIPAddress);
    }

    public String getFirstIpAddress() {
        return this.getValue1();
    }

    public String getLastIpAddress() {
        return this.getValue2();
    }

    public int size() {
        return this.ipAddresses.size();
    }

    class IPCompare
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -829070035372251909L;

        IPCompare() {
        }

        public int compare(Object obj1, Object obj2) {
            long long2;
            if (!(obj1 instanceof String) || !(obj2 instanceof String)) {
                throw new ClassCastException();
            }
            long long1 = RedCellIPUtil.convertIPAddressToNumber((String)((String)obj1));
            if (long1 < (long2 = RedCellIPUtil.convertIPAddressToNumber((String)((String)obj2)))) {
                return -1;
            }
            if (long1 == long2) {
                return 0;
            }
            return 1;
        }
    }
}

