/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.services.ndm;

import RedCell.Config.NetworkResourceIPLookup;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.ngnms.common.AvTrace;
import com.ngnms.services.ndm.AvIPBaseRange;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import redcell.common.util.RedCellIPUtil;

public class AvIPRangesUtil {
    public static Vector getNRIPLookup(IOWBOMClient pBOM, AvIPBaseRange pRange, String pLikeIPAddress) throws Exception {
        Vector<String> ret = new Vector<String>();
        long firstIPAddress = RedCellIPUtil.convertIPAddressToNumber((String)pRange.getFirstIpAddress());
        long lastIPAddress = RedCellIPUtil.convertIPAddressToNumber((String)pRange.getLastIpAddress());
        try {
            OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs("RedCell.Config.NetworkResourceIPLookup", true);
            qba.addAttribValueOperator(new OWBOMAttribValueOperator("IPAddress", "LIKE", (Object)pLikeIPAddress));
            List nrIPLookup = (List)pBOM.getObjects((OWBOMQuery)qba).getRtnObject();
            for (NetworkResourceIPLookup lookup : nrIPLookup) {
                long nrIPAddressLong = RedCellIPUtil.convertIPAddressToNumber((String)lookup.getIPAddress());
                if (nrIPAddressLong >= firstIPAddress && nrIPAddressLong <= lastIPAddress) {
                    ret.add(lookup.getKeyValue());
                    continue;
                }
                AvTrace.traceln("AvNetConfig", 3, "AvNetConfigUtil.getNRIPLookup - IP " + lookup.getIPAddress() + " not in range.");
            }
        }
        catch (OWBOMNotFoundException e) {
            AvTrace.traceln("AvNetConfig", 1, "AvNetConfigUtil.getNRIPLookup - No Devices Found in this Range.");
        }
        AvTrace.traceln("AvNetConfig", 2, "AvNetConfigUtil.getNRIPLookup - Process Like IP: " + pLikeIPAddress + "  Equipment size: " + ret.size());
        return ret;
    }

    public static Vector getNRIPLookupBeans(IOWBOMClient pBOM, AvIPBaseRange pRange, String pLikeIPAddress) throws Exception {
        Vector<NetworkResourceIPLookup> ret = new Vector<NetworkResourceIPLookup>();
        long firstIPAddress = RedCellIPUtil.convertIPAddressToNumber((String)pRange.getFirstIpAddress());
        long lastIPAddress = RedCellIPUtil.convertIPAddressToNumber((String)pRange.getLastIpAddress());
        try {
            OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs("RedCell.Config.NetworkResourceIPLookup", true);
            qba.addAttribValueOperator(new OWBOMAttribValueOperator("IPAddress", "LIKE", (Object)pLikeIPAddress));
            List nrIPLookup = (List)pBOM.getObjects((OWBOMQuery)qba).getRtnObject();
            for (NetworkResourceIPLookup lookup : nrIPLookup) {
                long nrIPAddressLong = RedCellIPUtil.convertIPAddressToNumber((String)lookup.getIPAddress());
                if (nrIPAddressLong >= firstIPAddress && nrIPAddressLong <= lastIPAddress) {
                    ret.add(lookup);
                    continue;
                }
                AvTrace.traceln("AvNetConfig", 3, "AvNetConfigUtil.getNRIPLookup - IP " + lookup.getIPAddress() + " not in range.");
            }
        }
        catch (OWBOMNotFoundException e) {
            AvTrace.traceln("AvNetConfig", 1, "AvNetConfigUtil.getNRIPLookup - No Devices Found in this Range.");
        }
        AvTrace.traceln("AvNetConfig", 2, "AvNetConfigUtil.getNRIPLookup - Process Like IP: " + pLikeIPAddress + "  Equipment size: " + ret.size());
        return ret;
    }

    public static Vector getIPRangeQueries(AvIPBaseRange pRange) {
        Vector<String> ret = new Vector<String>();
        String likeStr = new String();
        StringTokenizer stFirst = new StringTokenizer(pRange.getFirstIpAddress(), ".");
        StringTokenizer stLast = new StringTokenizer(pRange.getLastIpAddress(), ".");
        while (stFirst.hasMoreTokens() && stLast.hasMoreTokens()) {
            String fStr = stFirst.nextToken();
            String lStr = stLast.nextToken();
            boolean bHasMoreTokens = stFirst.hasMoreTokens();
            if (fStr.equals(lStr)) {
                if (bHasMoreTokens) {
                    likeStr = likeStr + fStr + ".";
                    continue;
                }
                pRange.getFirstIpAddress();
                ret.add(likeStr + fStr);
                break;
            }
            if (bHasMoreTokens) {
                int f = Integer.parseInt(fStr);
                int l = Integer.parseInt(lStr);
                for (int i = f; i <= l; ++i) {
                    ret.add(likeStr + i + ".*");
                }
                break;
            }
            ret.add(likeStr + "*");
            break;
        }
        AvTrace.traceln("AvNetConfig", 2, "AvNetConfigUtil.getIPRangeQueries   range: " + pRange.getFirstIpAddress() + " - " + pRange.getLastIpAddress() + "   ret size: " + ret.size());
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            AvTrace.traceln("AvNetConfig", 2, " ------------ ret Item: " + it.next());
        }
        return ret;
    }
}

