/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.services.common;

import com.dorado.common.utility.OWOID;
import com.dorado.core.ejb.ruleengine.IOWRuleEngineRuleInterface;
import com.dorado.core.scheduler.OWScheduleClient;
import com.dorado.core.scheduler.OWScheduleException;
import com.dorado.core.scheduler.OWScheduleItem;
import com.dorado.runtime.IOWEvent;
import com.ngnms.common.AvException;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvWorkSpace;
import com.ngnms.services.common.AvJobID;
import com.ngnms.services.common.AvScheduledServiceJobEvent;
import com.ngnms.services.common.AvServiceJobDescriptor;
import com.ngnms.services.common.AvServiceRequestorJobEndCallbackRuleEvent;
import java.util.Date;
import java.util.Hashtable;

public abstract class AvServiceUtil {
    static final int WORKSPACE_DFLT_TIMEOUT = 60;
    static int timeout = -1;

    private static String getJobIDTraceString(AvJobID pJobID) {
        return pJobID == null ? "NULL" : pJobID.getOID();
    }

    public static boolean isJobActive(AvJobID pJobID) throws AvException {
        try {
            AvTrace.traceln("AvServices", 3, "In isJobActive (pJobID = " + AvServiceUtil.getJobIDTraceString(pJobID) + ").");
            OWScheduleClient schedClient = new OWScheduleClient();
            schedClient.getItem((OWOID)pJobID);
            return true;
        }
        catch (OWScheduleException e) {
            AvTrace.traceln("AvServices", 3, "OWScheduleException -> " + e.getMessage());
            if (4 == e.getMsgNum()) {
                return false;
            }
            throw new AvException(e, "Failure to lookup the job");
        }
    }

    public static boolean isJobBusy(AvJobID pJobID) throws AvException {
        AvWorkSpace wrkSpc = null;
        try {
            AvTrace.traceln("AvServices", 3, "In isJobBusy (pJobID = " + AvServiceUtil.getJobIDTraceString(pJobID) + ").");
            wrkSpc = AvWorkSpace.getAndLockWorkSpace("AvServices_WorkSpace", AvServiceUtil.getWorkSpaceTimeout());
            Hashtable jobs = (Hashtable)wrkSpc.getObject("RunningJobs");
            wrkSpc.closeWorkSpace();
            return jobs.get(pJobID) != null;
        }
        catch (AvException e) {
            AvTrace.traceStack("AvServices", 3, (Exception)((Object)e));
            throw new AvException((Throwable)((Object)e), "Failure to retrieve job " + pJobID);
        }
    }

    public static boolean isJobPaused(AvJobID pJobID) throws AvException {
        try {
            AvTrace.traceln("AvServices", 3, "In isJobPaused (pJobID = " + AvServiceUtil.getJobIDTraceString(pJobID) + ").");
            OWScheduleClient schedClient = new OWScheduleClient();
            OWScheduleItem item = schedClient.getItem((OWOID)pJobID);
            return !item.isEnabled();
        }
        catch (OWScheduleException e) {
            AvTrace.traceStack("AvServices", 3, (Exception)((Object)e));
            throw new AvException(e, "Invalid Job ID");
        }
    }

    protected static AvJobID scheduleJob(AvServiceJobDescriptor pJob, String pScheduledEvent) throws AvException {
        try {
            AvScheduledServiceJobEvent ps = (AvScheduledServiceJobEvent)Class.forName(pScheduledEvent).newInstance();
            return AvServiceUtil.scheduleJob(pJob, pScheduledEvent, ps);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvServices", 3, e);
            throw new AvException(e, "Failure to instantiate AvScheduledServiceJobEvent.");
        }
    }

    protected static AvJobID scheduleJob(AvServiceJobDescriptor pJob, String pScheduledEvent, AvScheduledServiceJobEvent pEvent) throws AvException {
        pJob.setEventClassName(pScheduledEvent);
        try {
            AvTrace.traceln("AvServices", 3, "In scheduleJob.");
            int schedFlags = pJob.getSchedFlags();
            if (schedFlags == 1) {
                schedFlags = 1024;
                pJob.setOccurrences(1);
            }
            pEvent.setJobDescriptor(pJob);
            OWScheduleItem item = null;
            item = pJob.hasOccurrences() ? new OWScheduleItem(pScheduledEvent, (IOWEvent)pEvent, new Date(pJob.getStartDate()), pJob.getOccurrences(), schedFlags, pJob.getInterval(), 20, 101, false, true, true) : new OWScheduleItem(pScheduledEvent, (IOWEvent)pEvent, pJob.getStartDate(), pJob.getEndDate(), schedFlags, pJob.getInterval(), 20, 101, false, true, true);
            OWScheduleClient schedClient = new OWScheduleClient();
            schedClient.submitItem(item);
            AvJobID jobID = new AvJobID(item.getHandle().getOID());
            pJob.setJobID(jobID);
            schedClient.updateAttributeValuePair(item, (IOWEvent)pEvent);
            return jobID;
        }
        catch (Exception e) {
            AvTrace.traceStack("AvServices", 3, e);
            throw new AvException(e, "Failure to schedule the job");
        }
    }

    public static void updateJob(AvServiceJobDescriptor pJob) throws AvException {
        try {
            AvTrace.traceln("AvServices", 3, "In updateJob.");
            OWScheduleClient schedClient = new OWScheduleClient();
            OWScheduleItem item = schedClient.getItem((OWOID)pJob.getJobID());
            AvScheduledServiceJobEvent ps = (AvScheduledServiceJobEvent)item.getRuntimeEvent();
            ps.setJobDescriptor(pJob);
            schedClient.updateAttributeValuePair(item, (IOWEvent)ps);
        }
        catch (OWScheduleException e) {
            AvTrace.traceStack("AvServices", 3, (Exception)((Object)e));
            if (4 == e.getMsgNum()) {
                throw new AvException("Invalid Job ID");
            }
            throw new AvException(e, "Failure to update job " + pJob.getJobID());
        }
        catch (Exception e) {
            AvTrace.traceStack("AvServices", 3, e);
            throw new AvException(e, "Failure to update job " + pJob.getJobID());
        }
    }

    public static void pauseJob(AvJobID pJobID) throws AvException {
        try {
            AvTrace.traceln("AvServices", 3, "In pauseJob (pJobID = " + AvServiceUtil.getJobIDTraceString(pJobID) + ").");
            OWScheduleClient schedClient = new OWScheduleClient();
            OWScheduleItem item = schedClient.getItem((OWOID)pJobID);
            schedClient.setEnabled(item, false);
        }
        catch (OWScheduleException e) {
            AvTrace.traceln("AvServices", 3, "OWScheduleException -> " + e.getMessage());
            if (4 == e.getMsgNum()) {
                throw new AvException("Invalid Job ID " + pJobID);
            }
            throw new AvException(e, "Failure to pause job " + pJobID);
        }
    }

    public static void resumeJob(AvJobID pJobID) throws AvException {
        AvWorkSpace wrkSpc = null;
        try {
            AvTrace.traceln("AvServices", 3, "In resumeJob (pJobID = " + AvServiceUtil.getJobIDTraceString(pJobID) + ").");
            OWScheduleClient schedClient = new OWScheduleClient();
            OWScheduleItem item = schedClient.getItem((OWOID)pJobID);
            schedClient.setEnabled(item, true);
            wrkSpc = AvWorkSpace.getAndLockWorkSpace("AvServices_WorkSpace", AvServiceUtil.getWorkSpaceTimeout());
            Hashtable jobs = (Hashtable)wrkSpc.getObject("RunningJobs");
            if (jobs.remove(pJobID) != null) {
                wrkSpc.putObject("RunningJobs", jobs);
                AvServiceJobDescriptor job = (AvServiceJobDescriptor)item.getRuntimeEvent().readProperty("JobDescriptor");
                AvScheduledServiceJobEvent ps = (AvScheduledServiceJobEvent)Class.forName(job.getEventClassName()).newInstance();
                ps.setJobDescriptor(job);
                ps.emit();
            }
        }
        catch (OWScheduleException e) {
            AvTrace.traceln("AvServices", 3, "OWScheduleException -> " + e.getMessage());
            if (4 == e.getMsgNum()) {
                throw new AvException("Invalid Job ID");
            }
            throw new AvException(e, "Failure to resume the job");
        }
        catch (Exception e) {
            AvTrace.traceStack("AvServices", 3, e);
            throw new AvException(e, "Failure to resume the job");
        }
        finally {
            try {
                if (wrkSpc != null) {
                    wrkSpc.closeWorkSpace();
                }
            }
            catch (Exception x) {
                throw new AvException(x, "Failure to close workspace AvServices_WorkSpace");
            }
        }
    }

    public static void deleteJob(IOWRuleEngineRuleInterface pRE, AvJobID pJobID) throws AvException {
        AvWorkSpace wrkSpc = null;
        try {
            AvTrace.traceln("AvServices", 3, "In deleteJob (pJobID = " + AvServiceUtil.getJobIDTraceString(pJobID) + ").");
            wrkSpc = AvWorkSpace.getAndLockWorkSpace("AvServices_WorkSpace", AvServiceUtil.getWorkSpaceTimeout());
            Hashtable jobs = (Hashtable)wrkSpc.getObject("RunningJobs");
            if (jobs.remove(pJobID) != null) {
                wrkSpc.putObject("RunningJobs", jobs);
            }
            OWScheduleClient schedClient = new OWScheduleClient();
            OWScheduleItem item = schedClient.getItem((OWOID)pJobID);
            AvServiceJobDescriptor job = (AvServiceJobDescriptor)item.getRuntimeEvent().readProperty("JobDescriptor");
            schedClient.removeItem(item);
            if (job.getEndJobClbkRuleName() != null) {
                AvServiceRequestorJobEndCallbackRuleEvent evt = new AvServiceRequestorJobEndCallbackRuleEvent();
                evt.setClientData(job.getClientData());
                evt.setJobID(job.getJobID());
                evt.setResponseStatus("AvServices_JOB_STOPPED");
                evt.setExtendedError(null);
                pRE.callRule(job.getEndJobClbkRuleName(), (IOWEvent)evt);
            }
        }
        catch (AvException e) {
            AvTrace.traceStack("AvServices", 3, (Exception)((Object)e));
            throw new AvException((Throwable)((Object)e), "Failure to delete job " + pJobID);
        }
        catch (OWScheduleException e) {
            AvTrace.traceln("AvServices", 3, "OWScheduleException -> " + e.getMessage());
            if (4 == e.getMsgNum()) {
                throw new AvException("Invalid Job ID");
            }
            throw new AvException(e, "Failure to delete job " + pJobID);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvServices", 3, e);
            throw new AvException(e, "Failure to delete job " + pJobID);
        }
        finally {
            try {
                if (wrkSpc != null) {
                    wrkSpc.closeWorkSpace();
                }
            }
            catch (Exception x) {
                throw new AvException(x, "Failure to close workspace AvServices_WorkSpace");
            }
        }
    }

    public static AvServiceJobDescriptor getJobDescriptor(AvJobID pJobID) throws AvException {
        try {
            AvTrace.traceln("AvServices", 3, "In getJobDescriptor (pJobID = " + AvServiceUtil.getJobIDTraceString(pJobID) + ").");
            OWScheduleClient schedClient = new OWScheduleClient();
            OWScheduleItem item = schedClient.getItem((OWOID)pJobID);
            return (AvServiceJobDescriptor)item.getRuntimeEvent().readProperty("JobDescriptor");
        }
        catch (OWScheduleException e) {
            AvTrace.traceln("AvServices", 3, "OWScheduleException -> " + e.getMessage());
            if (4 == e.getMsgNum()) {
                throw new AvException("Invalid Job ID");
            }
            throw new AvException(e, "Failure to retrieve the job");
        }
    }

    protected static boolean setJobBusy(AvJobID pJobID) throws AvException {
        AvWorkSpace wrkSpc = null;
        try {
            AvTrace.traceln("AvServices", 3, "In setJobBusy (pJobID = " + AvServiceUtil.getJobIDTraceString(pJobID) + ").");
            wrkSpc = AvWorkSpace.getAndLockWorkSpace("AvServices_WorkSpace", AvServiceUtil.getWorkSpaceTimeout());
            Hashtable jobs = (Hashtable)wrkSpc.getObject("RunningJobs");
            Integer count = (Integer)jobs.get(pJobID);
            if (count != null) {
                jobs.put(pJobID, new Integer(1));
                wrkSpc.putObject("RunningJobs", jobs);
                boolean bl = false;
                return bl;
            }
            jobs.put(pJobID, new Integer(0));
            wrkSpc.putObject("RunningJobs", jobs);
            boolean bl = true;
            return bl;
        }
        catch (AvException e) {
            AvTrace.traceStack("AvServices", 3, (Exception)((Object)e));
            throw new AvException((Throwable)((Object)e), "Failure to mark job " + pJobID + " busy");
        }
        finally {
            try {
                if (wrkSpc != null) {
                    wrkSpc.closeWorkSpace();
                }
            }
            catch (Exception x) {
                throw new AvException(x, "Failure to close workspace AvServices_WorkSpace");
            }
        }
    }

    protected static void setJobIdle(AvJobID pJobID) throws AvException {
        AvWorkSpace wrkSpc = null;
        try {
            AvTrace.traceln("AvServices", 3, "In setJobIdle (pJobID = " + AvServiceUtil.getJobIDTraceString(pJobID) + ").");
            wrkSpc = AvWorkSpace.getAndLockWorkSpace("AvServices_WorkSpace", AvServiceUtil.getWorkSpaceTimeout());
            Hashtable jobs = (Hashtable)wrkSpc.getObject("RunningJobs");
            Integer count = (Integer)jobs.get(pJobID);
            if (count == null) {
                throw new AvException("Invalid job ID");
            }
            jobs.remove(pJobID);
            wrkSpc.putObject("RunningJobs", jobs);
            if (count > 0) {
                AvServiceJobDescriptor job = AvServiceUtil.getJobDescriptor(pJobID);
                AvScheduledServiceJobEvent ps = (AvScheduledServiceJobEvent)Class.forName(job.getEventClassName()).newInstance();
                ps.setJobDescriptor(job);
                ps.emit();
            }
        }
        catch (Exception e) {
            AvTrace.traceStack("AvServices", 3, e);
            throw new AvException(e, "Failure to mark job " + pJobID + " idle");
        }
        finally {
            try {
                if (wrkSpc != null) {
                    wrkSpc.closeWorkSpace();
                }
            }
            catch (Exception x) {
                throw new AvException(x, "Failure to close workspace AvServices_WorkSpace");
            }
        }
    }

    public static int getWorkSpaceTimeout() {
        if (timeout <= 0) {
            try {
                int tmout = Integer.valueOf(System.getProperty("redcell.ngnms.general_workspace_timeout", String.valueOf(60)));
                timeout = tmout <= 0 ? 60 : tmout;
            }
            catch (Exception e) {
                AvTrace.traceStack("AvServices", 3, e);
                timeout = 60;
            }
        }
        return timeout;
    }
}

