/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.services.common;

import com.ngnms.common.AvException;
import com.ngnms.services.common.AvJobID;
import com.ngnms.services.common.AvJobItems;
import com.ngnms.services.common.AvServiceUtil;
import com.ngnms.services.common.IAvJobItemsIterator;
import java.io.Serializable;

public abstract class AvServiceJobDescriptor
implements Serializable {
    AvJobID jobID = null;
    String requestorID = null;
    boolean persist = false;
    AvJobItems jobItems = null;
    int depth = 0;
    long startDate = 0L;
    long endDate = 0L;
    int schedFlags = 4;
    int interval = 0;
    String startJobClbkRuleName = null;
    String endJobClbkRuleName = null;
    String startIterationClbkRuleName = null;
    String endIterationClbkRuleName = null;
    Serializable clientData = null;
    String communitySource = "AvServices_COMMUNITY_READ";
    int occurrences = -1;
    IAvJobItemsIterator pausedItems = null;
    String eventClassName = null;

    public AvServiceJobDescriptor(String pRequestorID, String pCommunitySource, boolean pPersist, AvJobItems pItems, int pDepth, long pStartDate, long pEndDate, int pSchedFlags, int pInterval, String pStartJobClbkRuleName, String pEndJobClbkRuleName, String pStartIterationClbkRuleName, String pEndIterationClbkRuleName, Serializable pClientData) {
        this.requestorID = pRequestorID;
        this.persist = pPersist;
        this.communitySource = pCommunitySource;
        this.jobItems = pItems;
        this.depth = pDepth;
        this.startDate = pStartDate;
        this.endDate = pEndDate;
        this.schedFlags = pSchedFlags;
        this.interval = pInterval;
        this.startJobClbkRuleName = pStartJobClbkRuleName;
        this.endJobClbkRuleName = pEndJobClbkRuleName;
        this.startIterationClbkRuleName = pStartIterationClbkRuleName;
        this.endIterationClbkRuleName = pEndIterationClbkRuleName;
        this.clientData = pClientData;
    }

    public AvServiceJobDescriptor(String pRequestorID, String pCommunitySource, boolean pPersist, AvJobItems pItems, int pDepth, String pStartJobClbkRuleName, String pEndJobClbkRuleName, String pStartIterationClbkRuleName, String pEndIterationClbkRuleName, Serializable pClientData) {
        this.requestorID = pRequestorID;
        this.communitySource = pCommunitySource;
        this.persist = pPersist;
        this.jobItems = pItems;
        this.depth = pDepth;
        this.startJobClbkRuleName = pStartJobClbkRuleName;
        this.endJobClbkRuleName = pEndJobClbkRuleName;
        this.startIterationClbkRuleName = pStartIterationClbkRuleName;
        this.endIterationClbkRuleName = pEndIterationClbkRuleName;
        this.clientData = pClientData;
    }

    public AvJobID getJobID() {
        return this.jobID;
    }

    public String getRequestorID() {
        return this.requestorID;
    }

    public String getCommunitySource() {
        return this.communitySource;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public long getEndDate() {
        return this.endDate;
    }

    public int getSchedFlags() {
        return this.schedFlags;
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean getPersist() {
        return this.persist;
    }

    public boolean hasOccurrences() {
        return this.occurrences > -1;
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    public String getEventClassName() {
        return this.eventClassName;
    }

    public String getStartJobClbkRuleName() {
        return this.startJobClbkRuleName;
    }

    public String getEndJobClbkRuleName() {
        return this.endJobClbkRuleName;
    }

    public String getStartIterationClbkRuleName() {
        return this.startIterationClbkRuleName;
    }

    public String getEndIterationClbkRuleName() {
        return this.endIterationClbkRuleName;
    }

    public Serializable getClientData() {
        return this.clientData;
    }

    public int numOfItems() {
        return this.jobItems.size();
    }

    public boolean isActive() throws AvException {
        if (this.jobID == null) {
            return true;
        }
        return AvServiceUtil.isJobActive(this.jobID);
    }

    public boolean isToBePaused() throws AvException {
        if (this.jobID == null) {
            return false;
        }
        return AvServiceUtil.isJobPaused(this.jobID);
    }

    public IAvJobItemsIterator iterator() {
        return this.jobItems.iterator();
    }

    public boolean isPersistJob() {
        return this.jobItems.isPersist();
    }

    public int getDepth() {
        return this.depth;
    }

    void setJobID(AvJobID pJobID) {
        this.jobID = pJobID;
    }

    public void setStartDate(long pStartDate) {
        this.startDate = pStartDate;
    }

    public void setOccurrences(int pOccurrences) {
        this.occurrences = pOccurrences;
    }

    public void setEventClassName(String pEventClassName) {
        this.eventClassName = pEventClassName;
    }

    public void pause(IAvJobItemsIterator pPausedItems) throws AvException {
        this.pausedItems = pPausedItems;
        AvServiceUtil.updateJob(this);
    }

    public IAvJobItemsIterator resume() throws AvException {
        IAvJobItemsIterator pItems = this.pausedItems;
        this.pausedItems = null;
        if (pItems != null) {
            AvServiceUtil.updateJob(this);
        }
        return pItems;
    }
}

