/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.services.common;

import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.scheduler.OWScheduleClient;
import com.dorado.core.scheduler.OWScheduleItem;
import com.dorado.runtime.IOWEvent;
import com.ngnms.services.common.AvObjectCacheCleanupEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public class AvObjectCache {
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.services.common.AvObjectCache.debug");
    private static Vector instances = new Vector();
    private static String cleanupItemOID = null;
    private long expirationInterval;
    private long lastCleanup;
    private ObjectFactory objectFactory;
    private HashMap cache;
    private TreeSet agingCache;

    public static AvObjectCache getInstance(long pExpirationInterval, ObjectFactory pObjectFactory) {
        AvObjectCache instance = new AvObjectCache(pExpirationInterval, pObjectFactory);
        instances.add(instance);
        if (null == cleanupItemOID) {
            AvObjectCache.scheduleCleanup();
        }
        return instance;
    }

    public static synchronized void disposeInstance(AvObjectCache instance) {
        instances.remove(instance);
    }

    private AvObjectCache(long pExpirationInterval, ObjectFactory pObjectFactory) {
        this.expirationInterval = pExpirationInterval;
        this.objectFactory = pObjectFactory;
        this.lastCleanup = System.currentTimeMillis();
        this.cache = new HashMap();
        this.agingCache = new TreeSet();
    }

    public Object getObject(IOWBOMClient pBOM, Object pParam) {
        Object ret;
        if (this.objectFactory != null) {
            Object cacheKey = this.objectFactory.getCacheKey(pParam);
            CacheEntry cacheEntry = (CacheEntry)this.cache.get(cacheKey);
            if (cacheEntry != null) {
                ret = cacheEntry.value;
            } else {
                ret = this.objectFactory.getObject(pBOM, pParam);
                this.putObjectToCache(cacheKey, ret);
            }
        } else {
            CacheEntry cacheEntry = (CacheEntry)this.cache.get(pParam);
            ret = cacheEntry != null ? cacheEntry.value : null;
        }
        return ret;
    }

    public void getObjects(IOWBOMClient pBOM, Iterator keyIterator, Map results, Collection misses) {
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            Object entry = this.getObject(pBOM, key);
            if (null != entry) {
                results.put(key, entry);
                continue;
            }
            misses.add(key);
        }
    }

    public synchronized void putObjectToCache(Object pParam, Object pValue) {
        long timestamp = System.currentTimeMillis();
        CacheEntry cacheEntry = new CacheEntry(timestamp, pValue);
        CacheEntry agingEntry = new CacheEntry(timestamp, pParam);
        this.cache.put(pParam, cacheEntry);
        this.agingCache.add(agingEntry);
        if (debugOn) {
            System.out.println("AvObjectCache: size " + this.agingCache.size());
        }
    }

    public synchronized void removeObjectFromCache(Object pParam) {
        if (debugOn) {
            System.out.println("AvObjectCache: removeObjectFromCache");
        }
        this.cache.remove(pParam);
        Iterator i = this.agingCache.iterator();
        while (i.hasNext()) {
            CacheEntry entry = (CacheEntry)i.next();
            if (entry.value != pParam) continue;
            i.remove();
            return;
        }
    }

    private synchronized void cleanCache() {
        int cleanCount = 0;
        Iterator i = this.agingCache.iterator();
        while (i.hasNext()) {
            CacheEntry cacheEntry = (CacheEntry)i.next();
            if (System.currentTimeMillis() - cacheEntry.timestamp < this.expirationInterval) {
                if (debugOn) {
                    System.out.println("AvObjectCache: cleanup " + cleanCount + " objects.");
                }
                return;
            }
            Object cacheKey = cacheEntry.value;
            i.remove();
            this.cache.remove(cacheKey);
            ++cleanCount;
        }
        this.lastCleanup = System.currentTimeMillis();
    }

    public long getExpirationInterval() {
        return this.expirationInterval;
    }

    public long getLastCleanup() {
        return this.lastCleanup;
    }

    private static synchronized void scheduleCleanup() {
        block5: {
            if (cleanupItemOID != null) {
                return;
            }
            if (debugOn) {
                System.out.println("AvObjectCache: scheduling cleanup event");
            }
            try {
                AvObjectCacheCleanupEvent paramSet = new AvObjectCacheCleanupEvent();
                OWScheduleItem _item = new OWScheduleItem("com.ngnms.services.common.AvObjectCacheCleanupRule", (IOWEvent)paramSet, System.currentTimeMillis(), 0L, 2, 5, 100, false, false, true);
                OWScheduleClient _schedClient = new OWScheduleClient();
                _schedClient.submitItem(_item);
                cleanupItemOID = _item.getHandle().getOID();
                if (debugOn) {
                    System.out.println("AvObjectCache: Scheduled cleanup event.");
                }
            }
            catch (Exception e) {
                if (!debugOn) break block5;
                e.printStackTrace();
            }
        }
    }

    public static synchronized void cleanAllInstances() {
        if (debugOn) {
            System.out.println("AvObjectCache: cleanAllInstances called");
        }
        long _start = System.currentTimeMillis();
        for (AvObjectCache cache : instances) {
            if (System.currentTimeMillis() - cache.getLastCleanup() <= cache.getExpirationInterval() / 2L) continue;
            cache.cleanCache();
        }
        if (debugOn) {
            System.out.println("AvObjectCache: cleanup finished " + (System.currentTimeMillis() - _start) + " millis");
        }
    }

    public static interface ObjectFactory {
        public Object getObject(IOWBOMClient var1, Object var2);

        public Object getCacheKey(Object var1);
    }

    private static class CacheEntry
    implements Comparable {
        long timestamp;
        Object value;

        public CacheEntry(long pTimeStamp, Object pValue) {
            this.timestamp = pTimeStamp;
            this.value = pValue;
        }

        public int compareTo(Object o) {
            CacheEntry candidate = (CacheEntry)o;
            if (this.timestamp < candidate.timestamp) {
                return -1;
            }
            if (this.timestamp > candidate.timestamp) {
                return 1;
            }
            return 0;
        }
    }
}

