/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.services.common;

import RedCell.Config.Equipment;
import RedCell.Config.EquipmentKey;
import RedCell.Config.ManagementInterface;
import RedCell.Config.NetworkResource;
import RedCell.Config.NetworkResourceIPLookup;
import RedCell.Config.NetworkResourceKey;
import com.dorado.common.collections.OWAVPVector;
import com.dorado.common.exception.OWException;
import com.dorado.common.utility.OWAttributeValuePair;
import com.dorado.common.utility.OWOID;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMObjectLockByAnotherException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMQueryByKey;
import com.dorado.core.bom.OWBOMQueryByOWOID;
import com.dorado.core.bom.OWBOMRequest;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWIntrinsic;
import com.dorado.runtime.OWBaseBean;
import com.dorado.runtime.OWBean;
import com.dorado.runtime.OWHashtable;
import com.dorado.runtime.OWSet;
import com.dorado.runtime.OWVector;
import com.ngnms.common.AvBeanProxy;
import com.ngnms.common.AvCard;
import com.ngnms.common.AvDevice;
import com.ngnms.common.AvDynamicTableRow;
import com.ngnms.common.AvDynamicTableRowLogical;
import com.ngnms.common.AvEquipment;
import com.ngnms.common.AvException;
import com.ngnms.common.AvLookup;
import com.ngnms.common.AvLookupItemNotFoundException;
import com.ngnms.common.AvNetworkResourceTableRow;
import com.ngnms.common.AvPort;
import com.ngnms.common.AvSnmpLeaf;
import com.ngnms.common.AvStaticTableRow;
import com.ngnms.common.AvStaticTableRowLogical;
import com.ngnms.common.AvTableRow;
import com.ngnms.common.AvTableRowLogical;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvWorkSpace;
import com.ngnms.services.common.AvMOAuthParams;
import com.ngnms.services.common.AvServiceUtil;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AvMOUtil {
    public static final String GET_OBJECT_FOR_UPDATE_TIMEOUT_PROP_NAME = "MOLockTimeOut";
    public static final String GET_OBJECT_FOR_UPDATE_WAIT_PROP_NAME = "MOLockWait";
    private static final int DEFAULT_GET_OBJECT_FOR_UPDATE_TIMEOUT = 3000;
    private static final int DEFAULT_GET_OBJECT_FOR_UPDATE_WAIT = 100;
    private static int getObjectForUpdateTimeOut = -1;
    private static int getObjectForUpdateWait = -1;
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.services.common.AvMOUtil.debug");

    public static Vector getAllIPLookupByIpAddress(IOWBOMClient pBOM, String pIPAddress) throws AvException {
        try {
            OWBOMAttribValueOperator attVal = new OWBOMAttribValueOperator("IPAddress", "=", (Object)pIPAddress);
            OWBOMQueryByAttribs attribsQuery = new OWBOMQueryByAttribs("RedCell.Config.NetworkResourceIPLookup", true);
            attribsQuery.addAttribValueOperator(attVal);
            return (Vector)pBOM.getObjects((OWBOMQuery)attribsQuery).getRtnObject();
        }
        catch (OWBOMNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new AvException(e, "Failed To Get Equipment for IPAddress = " + pIPAddress);
        }
    }

    public static Equipment getEquipmentByIpAddress(IOWBOMClient pBOM, String pIPAddress) throws AvException {
        try {
            Vector ipLookupVector = AvMOUtil.getAllIPLookupByIpAddress(pBOM, pIPAddress);
            if (ipLookupVector == null) {
                return null;
            }
            NetworkResourceIPLookup iplookup = (NetworkResourceIPLookup)ipLookupVector.elementAt(0);
            OWBOMQueryByKey keyQuery = new OWBOMQueryByKey("RedCell.Config.EquipmentKey", iplookup.getKeyValue());
            EquipmentKey key = (EquipmentKey)pBOM.getObject(keyQuery).getRtnObject();
            return (Equipment)(key == null ? null : key.getNetworkResource());
        }
        catch (OWBOMNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new AvException(e, "Failed To Get Equipment for IPAddress = " + pIPAddress);
        }
    }

    public static AvDevice getAvDeviceByIpAddress(IOWBOMClient pBOM, String pIPAddress) throws AvException {
        try {
            Equipment eqp = AvMOUtil.getEquipmentByIpAddress(pBOM, pIPAddress);
            if (eqp instanceof AvDevice) {
                return (AvDevice)eqp;
            }
            return null;
        }
        catch (Exception e) {
            throw new AvException(e, "Failed To Get AvDevice for IPAddress = " + pIPAddress);
        }
    }

    public static NetworkResource getAvEquipmentOrAvDeviceFromMO(NetworkResource pNetRes, boolean pDeviceOnly) throws AvException {
        if (pNetRes == null) {
            throw new AvException("Object is NULL !!!");
        }
        AvTrace.traceln("AvMOUtil", 2, "In getAvEquipmentOrAvDeviceFromMO - pNetRes Class = " + pNetRes.getClass().getName() + " ,pDeviceOnly = " + pDeviceOnly);
        NetworkResourceKey key = pNetRes.getKey();
        do {
            NetworkResource netRes;
            if ((netRes = key.getNetworkResource()) != null) {
                AvTrace.traceln("AvMOUtil", 2, "netRes = " + netRes.getClass().getName());
                if (!(netRes instanceof AvDevice) && (pDeviceOnly || !(netRes instanceof AvCard) && !(netRes instanceof AvPort))) continue;
                AvTrace.traceln("AvMOUtil", 2, "Found: netRes = " + netRes.getClass().getName());
                return netRes;
            }
            AvTrace.traceln("AvMOUtil", 2, "Object is NULL !!!");
        } while ((key = key.getParentKey()) != null);
        throw new AvException("Object Has No Parent Device - " + pNetRes.getClass().getName());
    }

    public static AvDevice getTopLevelDeviceFromMO(NetworkResource pNetRes) throws AvException {
        NetworkResourceKey parentKey;
        AvDevice device = AvMOUtil.getAvDeviceFromMO(pNetRes);
        if (device == null) {
            return null;
        }
        NetworkResourceKey nrKey = device.getKey();
        while ((parentKey = nrKey.getParentKey()) != null) {
            nrKey = parentKey;
        }
        return (AvDevice)nrKey.getNetworkResource();
    }

    public static AvDevice getAvDeviceFromMO(NetworkResource pNetRes) throws AvException {
        return (AvDevice)AvMOUtil.getAvEquipmentOrAvDeviceFromMO(pNetRes, true);
    }

    public static Vector getAvDevicesFromBeans(Vector pBeansV) throws AvException {
        try {
            Hashtable<String, AvDevice> devH = new Hashtable<String, AvDevice>();
            Vector devBeansV = new Vector();
            for (int i = 0; i < pBeansV.size(); ++i) {
                OWBean bean = (OWBean)pBeansV.elementAt(i);
                try {
                    if (bean instanceof NetworkResource) {
                        AvDevice avBean = AvMOUtil.getAvDeviceFromMO((NetworkResource)bean);
                        devH.put(avBean.getHandle().getOID(), avBean);
                        continue;
                    }
                    AvTrace.traceln("AvMOUtil", 1, "nr is not NR. OWOID : " + bean.getKEY());
                    continue;
                }
                catch (Exception e) {
                    AvTrace.traceStack("AvMOUtil", 1, e);
                }
            }
            Enumeration en = devH.elements();
            while (en.hasMoreElements()) {
                devBeansV.add(en.nextElement());
            }
            return devBeansV;
        }
        catch (Exception e) {
            throw new AvException(e, "Failed toget AvDevices From Beans  ");
        }
    }

    public static NetworkResource getNetworkResourceByOWOID(IOWBOMClient pBOM, OWOID pOWOID, int pDepth) throws AvException {
        OWBOMQueryByOWOID query = new OWBOMQueryByOWOID(pOWOID);
        query.setDepth(pDepth);
        try {
            Object obj = pBOM.getObject((OWBOMQueryByKey)query).getRtnObject();
            if (!(obj instanceof NetworkResource)) {
                AvTrace.traceln("AvMOUtil", 1, "Object for OWOID : " + pOWOID + " is not NetworkResource !!!   but: " + obj.getClass().getName());
                return null;
            }
            return (NetworkResource)obj;
        }
        catch (OWBOMNotFoundException e) {
            return null;
        }
        catch (OWException e) {
            throw new AvException("Failed to retrieve the object for OWOID " + pOWOID);
        }
    }

    public static String getMOIPAddress(IOWBOMClient pBOM, AvBeanProxy pMOProxy) throws AvException {
        return AvMOUtil.getMOIPAddress(pBOM, pMOProxy.getOWOID());
    }

    public static String getMOIPAddress(IOWBOMClient pBOM, OWOID pOWOID) throws AvException {
        NetworkResource mo = AvMOUtil.getNetworkResourceByOWOID(pBOM, pOWOID, 0);
        if (mo == null) {
            throw new AvException("OWOID " + pOWOID + " is not a NetworkResource");
        }
        return AvMOUtil.getMOIPAddress(mo);
    }

    public static String getMOIPAddress(NetworkResource pMO) throws AvException {
        AvDevice device = AvMOUtil.getAvDeviceFromMO(pMO);
        OWVector authVector = device.getAuthentication();
        if (authVector == null) {
            throw new AvException("Device Has No Authentication Data");
        }
        ManagementInterface managementInterface = (ManagementInterface)authVector.firstElement();
        String ipAddr = managementInterface.getIPAddress();
        if (ipAddr == null) {
            throw new AvException("Device doesn't have an IP Address");
        }
        return ipAddr;
    }

    public static AvMOAuthParams getMOAuthenticationParams(NetworkResource pMO) throws AvException {
        AvMOAuthParams params = new AvMOAuthParams();
        AvDevice device = null;
        AvEquipment equipment = null;
        if (pMO instanceof AvDevice) {
            device = (AvDevice)pMO;
            params.rdCommunity = device.getReadCommunity();
            params.wrCommunity = device.getWriteCommunity();
        } else if (pMO instanceof AvEquipment) {
            equipment = (AvEquipment)pMO;
            params.rdCommunity = equipment.getReadCommunity();
            params.wrCommunity = equipment.getWriteCommunity();
            device = AvMOUtil.getAvDeviceFromMO(pMO);
        } else {
            device = AvMOUtil.getAvDeviceFromMO(pMO);
            params.rdCommunity = device.getReadCommunity();
            params.wrCommunity = device.getWriteCommunity();
        }
        params.productLine = device.getProductLineName();
        params.port = device.getPort();
        OWVector authVector = device.getAuthentication();
        if (authVector == null) {
            throw new AvException("Device Has No Authentication Data");
        }
        ManagementInterface managementInterface = (ManagementInterface)authVector.firstElement();
        params.ipAddress = managementInterface.getIPAddress();
        AvTrace.traceln("AvMOUtil", 1, "params: " + params.toString());
        if (params.ipAddress == null || params.port == 0 || params.rdCommunity == null || params.wrCommunity == null) {
            throw new AvException("Device Has Partial Authentication Data");
        }
        return params;
    }

    public static boolean isTableRow(String pType) throws ClassNotFoundException {
        Class<?> classObj = Class.forName(pType);
        return AvMOUtil.isTableRow(classObj);
    }

    public static boolean isTableRow(Class pClass) throws ClassNotFoundException {
        return Class.forName("com.ngnms.common.AvTableRow").isAssignableFrom(pClass) || Class.forName("com.ngnms.common.AvTableRowLogical").isAssignableFrom(pClass) || Class.forName("com.ngnms.common.AvNetworkResourceTableRow").isAssignableFrom(pClass);
    }

    public static boolean isTableRow(OWBean pBean) {
        return pBean instanceof AvTableRow || pBean instanceof AvTableRowLogical || pBean instanceof AvNetworkResourceTableRow;
    }

    public static boolean isStaticTableRow(String pType) throws ClassNotFoundException {
        Class<?> classObj = Class.forName(pType);
        return AvMOUtil.isStaticTableRow(classObj);
    }

    public static boolean isStaticTableRow(Class pClass) throws ClassNotFoundException {
        return Class.forName("com.ngnms.common.AvStaticTableRow").isAssignableFrom(pClass) || Class.forName("com.ngnms.common.AvStaticTableRowLogical").isAssignableFrom(pClass);
    }

    public static boolean isStaticTableRow(OWBean pBean) {
        return pBean instanceof AvStaticTableRow || pBean instanceof AvStaticTableRowLogical;
    }

    public static boolean isDynamicTableRow(String pType) throws ClassNotFoundException {
        Class<?> classObj = Class.forName(pType);
        return AvMOUtil.isDynamicTableRow(classObj);
    }

    public static boolean isDynamicTableRow(Class pClass) throws ClassNotFoundException {
        return Class.forName("com.ngnms.common.AvDynamicTableRow").isAssignableFrom(pClass) || Class.forName("com.ngnms.common.AvDynamicTableRowLogical").isAssignableFrom(pClass) || Class.forName("com.ngnms.common.AvNetworkResourceTableRow").isAssignableFrom(pClass);
    }

    public static boolean isDynamicTableRow(OWBean pBean) {
        return pBean instanceof AvDynamicTableRow || pBean instanceof AvDynamicTableRowLogical || pBean instanceof AvNetworkResourceTableRow;
    }

    public static String getPropertyAsString(OWBean pMO, String pPropertyName) throws AvException {
        try {
            Object obj = pMO.readProperty(pPropertyName);
            if (obj == null) {
                return null;
            }
            if (pPropertyName.startsWith("AvLeaf_")) {
                return ((AvSnmpLeaf)obj).getDataAsString();
            }
            return obj.toString();
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to get property " + pPropertyName + " as string");
        }
    }

    public static long getPropertyAsLong(OWBean pMO, String pPropertyName) throws AvException {
        try {
            Object obj = pMO.readProperty(pPropertyName);
            if (pPropertyName.startsWith("AvLeaf_")) {
                String strVal = ((AvSnmpLeaf)obj).getDataAsString();
                return Long.parseLong(strVal);
            }
            return Long.parseLong(obj.toString());
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to get property " + pPropertyName + " as long");
        }
    }

    public static int getPropertyAsInteger(OWBean pMO, String pPropertyName) throws AvException {
        try {
            Object obj = pMO.readProperty(pPropertyName);
            if (pPropertyName.startsWith("AvLeaf_")) {
                String strVal = ((AvSnmpLeaf)obj).getDataAsString();
                return Integer.parseInt(strVal);
            }
            return Integer.parseInt(obj.toString());
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to get property " + pPropertyName + " as int");
        }
    }

    public static String getAsOctetString(String pString) throws AvException {
        StringBuffer octet = new StringBuffer();
        StringTokenizer st = new StringTokenizer(pString);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            octet.append(" ");
            if (token.length() < 2) {
                octet.append("0");
            }
            octet.append(token);
        }
        return octet.substring(1);
    }

    public static String lookupClass(String pType, NetworkResource pNR) throws AvException {
        String cls = pType.substring(pType.lastIndexOf(".") + 1);
        try {
            return AvLookup.get(cls + "ClassName", pNR);
        }
        catch (AvLookupItemNotFoundException x) {
            return pType;
        }
    }

    public static OWAVPVector getAVPVfromMO(OWBean pMO) throws AvException {
        if (pMO == null) {
            return null;
        }
        OWAVPVector avpv = new OWAVPVector();
        Enumeration theEnum = pMO.readPropertiesEnum();
        while (theEnum.hasMoreElements()) {
            OWAttributeValuePair avp = (OWAttributeValuePair)theEnum.nextElement();
            if (avp == null) continue;
            String name = avp.getAttributeName();
            Object obj = avp.getValue();
            if (obj == null) {
                String type = pMO.getBeanInfo().getPropertyType(name);
                try {
                    if (!type.equals("java.io.Serializable") && Class.forName(type).newInstance() instanceof OWBean) continue;
                    avpv.add(new OWAttributeValuePair(name, null));
                    continue;
                }
                catch (Exception e) {
                    throw new AvException(e, "Failed to get an AVPV from MO");
                }
            }
            if (obj instanceof OWBean || obj instanceof OWVector || obj instanceof OWHashtable) continue;
            if (name.startsWith("AvLeaf_")) {
                avpv.add(new OWAttributeValuePair(name, ((AvSnmpLeaf)obj).getData()));
                continue;
            }
            if (obj instanceof OWSet) {
                avpv.add(new OWAttributeValuePair(name, (Object)((OWSet)obj).getCollection()));
                continue;
            }
            if (obj instanceof IOWIntrinsic) {
                avpv.add(new OWAttributeValuePair(name, ((IOWIntrinsic)obj).getJavaWrapperType()));
                continue;
            }
            avpv.add(new OWAttributeValuePair(name, obj));
        }
        AvMOUtil.addMetadataAVPVs(pMO, avpv);
        AvTrace.traceln("AvMOUtil", 2, "getAVPVfromMO: output = \n" + avpv.toString());
        return avpv;
    }

    public static OWAVPVector getAVPVfromMO(OWBean pMO, Vector pAttributes) throws AvException {
        if (pMO == null) {
            return null;
        }
        OWAVPVector avpv = new OWAVPVector();
        Enumeration theEnum = pAttributes.elements();
        while (theEnum.hasMoreElements()) {
            String name = (String)theEnum.nextElement();
            OWAttributeValuePair avp = (OWAttributeValuePair)pMO.readProperty(name);
            if (avp == null) continue;
            Object obj = avp.getValue();
            if (obj == null) {
                String type = pMO.getBeanInfo().getPropertyType(name);
                try {
                    if (!type.equals("java.io.Serializable") && Class.forName(type).newInstance() instanceof OWBean) continue;
                    avpv.add(new OWAttributeValuePair(name, null));
                    continue;
                }
                catch (Exception e) {
                    throw new AvException(e, "Failed to get an AVPV from MO");
                }
            }
            if (obj instanceof OWBean || obj instanceof OWVector || obj instanceof OWHashtable) continue;
            if (name.startsWith("AvLeaf_")) {
                avpv.add(new OWAttributeValuePair(name, ((AvSnmpLeaf)obj).getData()));
                continue;
            }
            if (obj instanceof OWSet) {
                avpv.add(new OWAttributeValuePair(name, (Object)((OWSet)obj).getCollection()));
                continue;
            }
            if (obj instanceof IOWIntrinsic) {
                avpv.add(new OWAttributeValuePair(name, ((IOWIntrinsic)obj).getJavaWrapperType()));
                continue;
            }
            avpv.add(new OWAttributeValuePair(name, obj));
        }
        AvMOUtil.addMetadataAVPVs(pMO, avpv);
        AvTrace.traceln("AvMOUtil", 2, "getAVPVfromMO: output = \n" + avpv.toString());
        return avpv;
    }

    public static boolean hasSNMPLeafs(OWBean pMO) {
        Enumeration theEnum = pMO.readPropertiesEnum();
        while (theEnum.hasMoreElements()) {
            OWAttributeValuePair avp = (OWAttributeValuePair)theEnum.nextElement();
            if (avp == null || !avp.getAttributeName().startsWith("AvLeaf_")) continue;
            return true;
        }
        return false;
    }

    public static OWAVPVector getSNMPLeafsAVPVfromMO(OWBean pMO) {
        if (pMO == null) {
            return null;
        }
        OWAVPVector avpv = new OWAVPVector();
        Enumeration theEnum = pMO.readPropertiesEnum();
        while (theEnum.hasMoreElements()) {
            String name;
            OWAttributeValuePair avp = (OWAttributeValuePair)theEnum.nextElement();
            if (avp == null || !(name = avp.getAttributeName()).startsWith("AvLeaf_") && !name.equals("AvRowInstance") && !name.equals("AvRowInstancePartial") && !name.equals("AvFirstInstance") && !name.equals("AvNumberOfRows")) continue;
            Object obj = avp.getValue();
            avpv.add(new OWAttributeValuePair(name, obj));
        }
        AvMOUtil.addMetadataAVPVs(pMO, avpv);
        return avpv;
    }

    private static OWAVPVector getMetadataAVPVs(OWBean pMO) {
        OWAVPVector avpv = new OWAVPVector();
        AvMOUtil.addMetadataAVPVs(pMO, avpv);
        return avpv;
    }

    private static void addMetadataAVPVs(OWBean pMO, OWAVPVector pVec) {
        pVec.add(new OWAttributeValuePair("AvAVPVs_CLASS_NAME", (Object)pMO.getClass().getName()));
        OWOID owoid = pMO.getHandle(true);
        if (owoid != null) {
            pVec.add(new OWAttributeValuePair("AvAVPVs_DB_HANDLE", (Object)owoid));
        }
        pVec.add(new OWAttributeValuePair("AvAVPVs_TIMESTAMP", (Object)new Integer(pMO.getTimestamp())));
    }

    public static void addMetadataAVPVs(OWAVPVector pInVec, OWAVPVector pOutVec) {
        pOutVec.add(new OWAttributeValuePair("AvAVPVs_CLASS_NAME", (Object)AvMOUtil.getClassNameFromMOAVPVNoExp(pInVec)));
        OWOID owoid = AvMOUtil.getOWOIDfromMOAVPVNoExp(pInVec);
        if (owoid != null) {
            pOutVec.add(new OWAttributeValuePair("AvAVPVs_DB_HANDLE", (Object)owoid));
        }
        pOutVec.add(new OWAttributeValuePair("AvAVPVs_TIMESTAMP", (Object)new Integer(AvMOUtil.getTimestampFromMOAVPVNoExp(pInVec))));
    }

    public static OWBean getMOfromAVPV(IOWBOMClient pBOM, OWAVPVector pVec) throws AvException {
        OWOID owoid = AvMOUtil.getOWOIDfromMOAVPVNoExp(pVec);
        if (owoid != null) {
            try {
                OWBOMQueryByOWOID query = new OWBOMQueryByOWOID(owoid);
                OWBean bean = (OWBean)pBOM.getObject((OWBOMQueryByKey)query).getRtnObject();
                if (!bean.getClass().getName().equals(AvMOUtil.getClassNameFromMOAVPV(pVec))) {
                    throw new AvException("Invalid AVPVector: class name doesn't match class in data base");
                }
                return bean;
            }
            catch (Exception e) {
                throw new AvException(e, "Failed to retrieve MO from database");
            }
        }
        return AvMOUtil.getMOfromAVPV(pVec);
    }

    public static OWBean getMOfromAVPV(OWAVPVector pVec) throws AvException {
        try {
            OWBean bean = (OWBean)Class.forName(AvMOUtil.getClassNameFromMOAVPV(pVec)).newInstance();
            for (OWAttributeValuePair avp : pVec) {
                if (avp.getAttributeName().startsWith("AvLeaf_") && !(avp.getValue() instanceof AvSnmpLeaf)) {
                    AvSnmpLeaf leaf = new AvSnmpLeaf();
                    leaf.setData(avp.getValue());
                    avp.setNewValue((Object)leaf);
                }
                bean.storeProperty(avp.getAttributeName(), avp.getValue());
            }
            return bean;
        }
        catch (Exception e) {
            throw new AvException(e, "Invalid attribute name");
        }
    }

    public static OWOID getOWOIDfromMOAVPV(OWAVPVector pVec) throws AvException {
        OWOID owoid = AvMOUtil.getOWOIDfromMOAVPVNoExp(pVec);
        if (owoid == null) {
            throw new AvException("MO AVPVector is missing the DB_HANDLE pair");
        }
        return owoid;
    }

    public static int getTimestampFromMOAVPV(OWAVPVector pVec) throws AvException {
        int t = AvMOUtil.getTimestampFromMOAVPVNoExp(pVec);
        if (t == -1) {
            throw new AvException("MO AVPVector is missing the TIMESTAMP pair");
        }
        return t;
    }

    public static String getClassNameFromMOAVPV(OWAVPVector pVec) throws AvException {
        String className = AvMOUtil.getClassNameFromMOAVPVNoExp(pVec);
        if (className == null) {
            throw new AvException("MO AVPVector is missing the CLASS_NAME pair");
        }
        return className;
    }

    public static String getChangesFromMOAVPV(OWAVPVector pVec) throws AvException {
        String changes = AvMOUtil.getChangesFromMOAVPVNoExp(pVec);
        if (changes == null) {
            throw new AvException("MO AVPVector is missing the CHANGES pair");
        }
        return changes;
    }

    public static OWOID getOWOIDfromMOAVPVNoExp(OWAVPVector pVec) {
        return (OWOID)pVec.firstValueWith("AvAVPVs_DB_HANDLE");
    }

    public static int getTimestampFromMOAVPVNoExp(OWAVPVector pVec) {
        Integer t = (Integer)pVec.firstValueWith("AvAVPVs_TIMESTAMP");
        if (t == null) {
            return 0;
        }
        return t;
    }

    public static String getClassNameFromMOAVPVNoExp(OWAVPVector pVec) {
        return (String)pVec.firstValueWith("AvAVPVs_CLASS_NAME");
    }

    public static String getChangesFromMOAVPVNoExp(OWAVPVector pVec) {
        return (String)pVec.firstValueWith("AvAVPVs_CHANGES");
    }

    public static OWBOMRequest getObjectForUpdate(IOWBOMClient pBOM, OWBOMQueryByKey pQuery) throws AvException {
        return (OWBOMRequest)AvMOUtil.getObjectForUpdateInt(pBOM, pQuery, getObjectForUpdateTimeOut, getObjectForUpdateWait);
    }

    public static OWBOMRequest getObjectForUpdate(IOWBOMClient pBOM, OWBOMQueryByKey pQuery, long pTimeOut, long pWait) throws AvException {
        return (OWBOMRequest)AvMOUtil.getObjectForUpdateInt(pBOM, pQuery, pTimeOut, pWait);
    }

    public static IOWBean getObjectForUpdate(IOWBOMClient pBOM, IOWBean pBean) throws AvException {
        return (IOWBean)AvMOUtil.getObjectForUpdateInt(pBOM, pBean, getObjectForUpdateTimeOut, getObjectForUpdateWait);
    }

    public static IOWBean getObjectForUpdate(IOWBOMClient pBOM, IOWBean pBean, long pTimeOut, long pWait) throws AvException {
        return (IOWBean)AvMOUtil.getObjectForUpdateInt(pBOM, pBean, pTimeOut, pWait);
    }

    public static OWBOMRequest getObjectForUpdate(IOWBOMClient pBOM, OWOID pBeanOWOID) throws AvException {
        OWBOMQueryByOWOID query = new OWBOMQueryByOWOID(pBeanOWOID);
        return (OWBOMRequest)AvMOUtil.getObjectForUpdateInt(pBOM, query, getObjectForUpdateTimeOut, getObjectForUpdateWait);
    }

    public static OWBOMRequest getObjectForUpdate(IOWBOMClient pBOM, OWOID pBeanOWOID, long pTimeOut, long pWait) throws AvException {
        OWBOMQueryByOWOID query = new OWBOMQueryByOWOID(pBeanOWOID);
        return (OWBOMRequest)AvMOUtil.getObjectForUpdateInt(pBOM, query, pTimeOut, pWait);
    }

    private static Object getObjectForUpdateInt(IOWBOMClient pBOM, Object pBeanOrQuery, long pTimeOut, long pWait) throws AvException {
        try {
            OWBOMRequest retVal = null;
            boolean done = false;
            long startTimeLong = System.currentTimeMillis();
            int tryNum = 0;
            AvTrace.traceln("AvMOUtil", 2, "In getObjectForUpdate (" + pTimeOut + ", " + pWait + ", Start=" + startTimeLong + ")");
            if (pBeanOrQuery == null) {
                throw new AvException("pBeanOrQuery can't be NULL !!!");
            }
            String beanOrQueryClassName = pBeanOrQuery.getClass().getName();
            if (debugOn) {
                System.out.println("getObjectForUpdate: " + beanOrQueryClassName + " (" + pTimeOut + ", " + pWait + ", Start=" + startTimeLong + ")");
            }
            while (!done) {
                try {
                    if (pBeanOrQuery instanceof OWBOMQueryByKey) {
                        retVal = pBOM.getObjectForUpdate((OWBOMQueryByKey)pBeanOrQuery);
                    } else if (pBeanOrQuery instanceof IOWBean) {
                        retVal = pBOM.getObjectForUpdate((IOWBean)pBeanOrQuery);
                    } else {
                        throw new AvException("Failed to get Object for Update - Unsupported Type: " + beanOrQueryClassName);
                    }
                    done = true;
                }
                catch (OWBOMObjectLockByAnotherException e) {
                    long currentTimeLong = System.currentTimeMillis();
                    if (startTimeLong + pTimeOut < currentTimeLong) {
                        throw new AvException(e, "Failed to get Object for Update - Waited for " + pTimeOut + " millis.");
                    }
                    if (debugOn) {
                        String id = "";
                        if (pBeanOrQuery instanceof OWBOMQueryByKey) {
                            id = ((OWBOMQueryByKey)pBeanOrQuery).getQueryString();
                        } else if (pBeanOrQuery instanceof IOWBean) {
                            id = ((IOWBean)pBeanOrQuery).getHandle().getOID();
                        }
                        System.out.println("getObjectForUpdate(" + ++tryNum + "): " + beanOrQueryClassName + ": " + id + " is Locekd. Will Wait " + pWait + " millis ...  ");
                    }
                    Thread.sleep(pWait);
                }
            }
            return retVal;
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to get Object for Update.");
        }
    }

    public static void lockObject(IOWBean pBean, boolean pToLock) throws Exception {
        if (pBean == null) {
            throw new AvException("pBean can't be NULL !!!");
        }
        AvMOUtil.lockObject(pBean.getHandle().getOID(), pToLock);
    }

    public static void lockObject(String pOID, boolean pToLock) throws Exception {
        if (pToLock) {
            long startTimeLong = System.currentTimeMillis();
            int tryNum = 0;
            if (debugOn) {
                System.out.println("lockObject: " + pOID + " (" + getObjectForUpdateTimeOut + ", " + getObjectForUpdateWait + ", Start=" + startTimeLong + ")");
            }
            while (!AvMOUtil.lockObjectInt(pOID, pToLock)) {
                if (startTimeLong + (long)getObjectForUpdateTimeOut < System.currentTimeMillis()) {
                    throw new AvException("Failed to Lock Object - Waited for " + getObjectForUpdateTimeOut + " millis.");
                }
                if (debugOn) {
                    System.out.println("lockObject(" + ++tryNum + "): " + pOID + " is Locekd. Will Wait " + getObjectForUpdateWait + " millis ...  ");
                }
                Thread.sleep(getObjectForUpdateWait);
            }
        } else {
            AvMOUtil.lockObjectInt(pOID, pToLock);
            if (debugOn) {
                System.out.println("lockObject: " + pOID + " Unlocked.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean lockObjectInt(String pOID, boolean pToLock) throws Exception {
        AvWorkSpace ws = null;
        AvTrace.traceln("AvMOUtil", 2, "In lockObject: " + pOID + ", pToLock = " + pToLock);
        try {
            ws = AvWorkSpace.getAndLockWorkSpace("MO_LOCK_WORKSPACE", AvServiceUtil.getWorkSpaceTimeout());
            HashSet<String> busyObjects = (HashSet<String>)ws.getObject("BusyObjects");
            if (null == busyObjects) {
                busyObjects = new HashSet<String>();
            }
            if (pToLock) {
                if (busyObjects.contains(pOID)) {
                    ws.closeWorkSpace();
                    ws = null;
                    AvTrace.traceln("AvMOUtil", 2, pOID + " - Object already Locked.");
                    boolean bl = false;
                    return bl;
                }
                busyObjects.add(pOID);
            } else {
                busyObjects.remove(pOID);
            }
            ws.putObject("BusyObjects", busyObjects);
            ws.closeWorkSpace();
            ws = null;
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (null != ws) {
                    ws.closeWorkSpace();
                }
            }
            catch (Exception e) {
                AvTrace.traceStack("AvMOUtil", 1, e);
            }
        }
    }

    public static AvBeanProxy getMOParentProxy(IOWBOMClient pBOM, String pNetworkResourceKey) {
        try {
            NetworkResource nr = AvMOUtil.getMOByKey(pBOM, pNetworkResourceKey);
            AvDevice topLevelNR = AvMOUtil.getTopLevelDeviceFromMO(nr);
            return new AvBeanProxy((OWBaseBean)topLevelNR);
        }
        catch (Exception e) {
            AvTrace.traceln("AvMOUtil", 3, "Failed to get Parent");
            return null;
        }
    }

    public static NetworkResource getMOByKey(IOWBOMClient pBOM, String pKey) {
        try {
            OWBOMQueryByKey qbk = new OWBOMQueryByKey("RedCell.Config.NetworkResourceKey", pKey);
            NetworkResourceKey nrKey = (NetworkResourceKey)pBOM.getObject(qbk).getRtnObject();
            return nrKey.getNetworkResource();
        }
        catch (Exception e) {
            AvTrace.traceStack("AvMOUtil", 3, e);
            return null;
        }
    }

    static {
        AvTrace.traceln("AvMOUtil");
        AvTrace.traceln("AvMOUtil", 1, "Initializing getObjectForUpdate Wait & Timeout ...");
        try {
            getObjectForUpdateTimeOut = Integer.parseInt(System.getProperty(GET_OBJECT_FOR_UPDATE_TIMEOUT_PROP_NAME));
        }
        catch (Exception e) {
            AvTrace.traceln("AvMOUtil", 1, "Failed to get and Parse to int System PropertyMOLockTimeOut - " + e.getMessage());
        }
        try {
            getObjectForUpdateWait = Integer.parseInt(System.getProperty(GET_OBJECT_FOR_UPDATE_WAIT_PROP_NAME));
        }
        catch (Exception e) {
            AvTrace.traceln("AvMOUtil", 1, "Failed to get and Parse to int System Property: MOLockWait - " + e.getMessage());
        }
        if (getObjectForUpdateTimeOut < 500) {
            getObjectForUpdateTimeOut = 3000;
        }
        if (getObjectForUpdateWait < 10) {
            getObjectForUpdateWait = 100;
        }
        AvTrace.traceln("AvMOUtil", 1, "getObjectForUpdateTimeOut = " + getObjectForUpdateTimeOut);
        AvTrace.traceln("AvMOUtil", 1, "getObjectForUpdateWait    = " + getObjectForUpdateWait);
        AvTrace.traceln("AvMOUtil");
    }
}

