/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.services.common;

import RedCell.Config.NetworkResource;
import com.dorado.common.utility.OWAppServerUtility;
import com.dorado.common.utility.OWOID;
import com.dorado.common.utility.OWStringUtility;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.runtime.OWBean;
import com.dorado.runtime.OWVector;
import com.ngnms.common.AvException;
import com.ngnms.common.AvTrace;
import com.ngnms.services.common.AvMOUtil;
import java.util.StringTokenizer;

public class AvAttributesPathParser {
    OWBean bean = null;
    String attributeName = null;
    Object attribute = null;
    String type = null;
    boolean isNullOWBean = false;
    String instanceKey = "";
    String instanceValue = "";
    OWBean parent;
    String parentAttrName;

    public AvAttributesPathParser(IOWBOMClient pBOM, OWOID pRootBean, String pAttributePath) throws AvException {
        if (!OWAppServerUtility.isApplicationServer()) {
            throw new AvException("Method should not be called by client");
        }
        try {
            NetworkResource rootBean = AvMOUtil.getNetworkResourceByOWOID(pBOM, pRootBean, 0);
            this.parse(rootBean, pAttributePath);
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to collect data");
        }
    }

    public AvAttributesPathParser(NetworkResource pRootBean, String pAttributePath) throws AvException {
        this.parse(pRootBean, pAttributePath);
    }

    private void parse(NetworkResource pRootBean, String pAttributePath) throws AvException {
        this.bean = pRootBean;
        NetworkResource rootBean = pRootBean;
        this.type = pRootBean.getClass().getName();
        String path = new String(pAttributePath);
        if (path.startsWith("/")) {
            try {
                rootBean = AvMOUtil.getAvDeviceFromMO(pRootBean);
                this.bean = rootBean;
                path = path.substring(1);
            }
            catch (AvException e) {
                throw new AvException((Throwable)((Object)e), "Attribute path starts with / but root bean is not parented by a device");
            }
        }
        if (OWStringUtility.count((String)pAttributePath, (char)'[') != OWStringUtility.count((String)pAttributePath, (char)']')) {
            throw new AvException("Not completed reference to Instance in path: " + pAttributePath);
        }
        StringTokenizer attributes = new StringTokenizer(path, ".");
        while (attributes.hasMoreTokens()) {
            this.parentAttrName = this.attributeName;
            this.attributeName = attributes.nextToken();
            String instance = "";
            this.instanceKey = "";
            this.instanceValue = "";
            if (this.attributeName.indexOf("[") != -1) {
                if (!this.attributeName.endsWith("]")) {
                    String attributeNamePart = "";
                    while (attributes.hasMoreTokens()) {
                        attributeNamePart = attributes.nextToken();
                        this.attributeName = this.attributeName + "." + attributeNamePart;
                        if (!attributeNamePart.endsWith("]")) continue;
                    }
                }
                StringTokenizer attrs = new StringTokenizer(this.attributeName, "[");
                this.attributeName = new String(attrs.nextToken());
                instance = new String(attrs.nextToken());
                int colon = (instance = instance.substring(0, instance.lastIndexOf(93))).indexOf(":");
                if (colon == -1) {
                    throw new AvException("Instance [" + instance + "] for attribute " + this.attributeName + " should contain colon!");
                }
                this.instanceKey = instance.substring(0, colon);
                this.instanceValue = instance.substring(colon + 1);
                AvTrace.traceln("AvEms", 3, "instanceKey = " + this.instanceKey + "; instanceValue =" + this.instanceValue);
            }
            this.type = this.bean.readPropertyType(this.attributeName);
            if (this.type == null) {
                throw new AvException(this.attributeName + " is not an attribute of class " + this.bean.getClass().getName());
            }
            this.attribute = this.bean.readProperty(this.attributeName);
            if (this.attribute instanceof OWVector) {
                OWVector owVec = (OWVector)this.attribute;
                if (owVec.isEmpty() && attributes.hasMoreTokens()) {
                    throw new AvException("The object hierachy path " + pAttributePath + " ends at " + this.attributeName);
                }
                if (instance.equals("") && attributes.hasMoreTokens()) {
                    throw new AvException("Ambiguity in attribute Path for  " + this.attributeName + " OWVector; instance should be specified!");
                }
                this.parent = this.bean;
                if (!owVec.isEmpty()) {
                    this.type = owVec.get(0).getClass().getName();
                    if (!instance.equals("")) {
                        boolean found = false;
                        for (OWBean element : owVec) {
                            if (!element.readProperty(this.instanceKey).toString().equals(this.instanceValue)) continue;
                            this.type = element.getClass().getName();
                            this.bean = element;
                            found = true;
                            break;
                        }
                        if (!found && attributes.hasMoreTokens()) {
                            throw new AvException("Not Existing Bean " + this.attributeName + "[" + instance + "] in attribute path!");
                        }
                    }
                } else {
                    this.type = AvMOUtil.lookupClass(owVec.getTypeName(), rootBean);
                    this.isNullOWBean = true;
                }
                if (!AvTrace.isTracing("AvEms", 3)) continue;
                AvTrace.traceln("AvEms", 3, "OWVector >> " + this.toString());
                continue;
            }
            if (this.attribute instanceof OWBean) {
                if (!instance.equals("")) {
                    throw new AvException("Invalid reference to instance  [" + instance + "] for attribute = " + this.attributeName + " of type = " + this.type);
                }
                this.parent = this.bean;
                this.bean = (OWBean)this.attribute;
                if (!AvTrace.isTracing("AvEms", 3)) continue;
                AvTrace.traceln("AvEms", 3, "NetworkResource >> " + this.toString());
                continue;
            }
            if (attributes.hasMoreTokens()) {
                throw new AvException("The attributes path " + pAttributePath + " ends at " + this.attributeName);
            }
            if (this.attribute == null) {
                try {
                    if (OWBean.class.isAssignableFrom(Class.forName(this.type))) {
                        this.type = AvMOUtil.lookupClass(this.type, rootBean);
                        this.isNullOWBean = true;
                    } else {
                        this.isNullOWBean = false;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new AvException(e, "Invalid attribute type " + this.type);
                }
            }
            if (!AvTrace.isTracing("AvEms", 3)) continue;
            AvTrace.traceln("AvEms", 3, "not an OWBean or undiscovered OWBean >> " + this.toString());
        }
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getParentAttributeName() {
        return this.parentAttrName;
    }

    public String getAttributeType() {
        return this.type;
    }

    public boolean isNullOWBean() {
        return this.isNullOWBean;
    }

    public Object getAttribute() {
        return this.attribute;
    }

    public OWBean getBean() {
        return this.bean;
    }

    public OWBean getParentBean() {
        return this.parent;
    }

    public String getInstanceKey() {
        return this.instanceKey;
    }

    public String getInstanceValue() {
        return this.instanceValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString() + " =" + "\n  bean = " + this.bean.getClass().getName() + "\n  attributeName = " + this.attributeName + "\n  type = " + this.type + "\n  isNullOWBean = " + this.isNullOWBean + "\n  instanceKey  = " + this.instanceKey + "\n  instanceValue= " + this.instanceValue);
        return sb.toString();
    }
}

