/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.security;

import RedCell.Config.Equipment;
import RedCell.Config.Location;
import RedCell.RCGetOWGroupsParamSet;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.IOWBOMInternalUseMarker;
import com.dorado.core.bom.OWBOMAPIException;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryAllByClass;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.security.IOWSecurityDef;
import com.dorado.core.security.OWPermission;
import com.dorado.core.security.OWPermissionCollection;
import com.dorado.oware.core.security.OWObjectGroup;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.OWEvent;
import com.dorado.runtime.OWInvalidTypeException;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWVector;
import com.ngnms.common.AvBeanProxy;
import com.ngnms.common.AvDevice;
import com.ngnms.common.AvException;
import com.ngnms.common.AvTrace;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import redcell.common.util.RCBOMUtil;
import redcell.common.util.RCBeanProxy;
import redcell.common.util.RedCellRuleEngineUtil;
import redcell.core.security.RCBOMInternalUseMarker;
import redcell.core.security.RCObjectGroupUtility;

public abstract class AvSecurityUtil {
    static boolean psycho = false;

    public static void updateEquipment(AvBeanProxy pEquipmentProxy) throws AvException {
        if (pEquipmentProxy.isChanged("Location")) {
            AvBeanProxy locationProxy = pEquipmentProxy.getAsProxy("Location");
            if (null != locationProxy) {
                pEquipmentProxy.setObjectGroups(locationProxy.getObjectGroups());
            } else {
                OWVector objGroups = new OWVector(OWObjectGroup.class);
                try {
                    OWObjectGroup defaultGroup = AvSecurityUtil.getObjectGroup(null, "Default", null);
                    if (null == defaultGroup) {
                        throw new RuntimeException("Default Object Group Not Found!");
                    }
                    objGroups.add((IOWBean)defaultGroup);
                    pEquipmentProxy.setObjectGroups(objGroups);
                }
                catch (OWInvalidTypeException ite) {
                }
                catch (OWBOMAPIException bome) {
                    throw new AvException(bome, "BOM API Error");
                }
            }
        }
    }

    public static void updateEquipment(RCBeanProxy pEquipmentProxy) {
        RCBeanProxy locationProxy = pEquipmentProxy.getAsProxy("Location");
        if (null != locationProxy) {
            pEquipmentProxy.setRCObjectGroups(locationProxy.getRCObjectGroups());
        } else {
            OWVector objGroups = new OWVector(OWObjectGroup.class);
            try {
                OWObjectGroup defaultGroup = AvSecurityUtil.getObjectGroup(null, "Default", null);
                if (null == defaultGroup) {
                    throw new RuntimeException("Default Object Group Not Found!");
                }
                objGroups.add((IOWBean)defaultGroup);
                pEquipmentProxy.setRCObjectGroups(objGroups);
            }
            catch (OWInvalidTypeException ite) {
            }
            catch (Exception e) {
                AvTrace.traceStack("AvSecurity", 1, e);
            }
        }
    }

    public static OWVector getOWObjectGroups(RCBeanProxy pProxy) {
        try {
            if (null != pProxy) {
                return pProxy.getRCObjectGroups();
            }
            OWVector objGroups = new OWVector(OWObjectGroup.class);
            OWObjectGroup defaultObjGroup = AvSecurityUtil.getObjectGroup(null, "Default", null);
            if (null != defaultObjGroup) {
                objGroups.add((IOWBean)defaultObjGroup);
            }
            return objGroups;
        }
        catch (Exception e) {
            AvTrace.traceStack("AvSecurity", 1, e);
            return null;
        }
    }

    public static OWPermissionCollection addPermissions(OWObjectGroup pGroup1, OWObjectGroup pGroup2) throws OWMutatorException {
        OWPermissionCollection perms2;
        OWPermissionCollection perms = new OWPermissionCollection();
        OWPermissionCollection perms1 = pGroup1.getPerms();
        if (null == perms1) {
            perms1 = new OWPermissionCollection();
        }
        if (null == (perms2 = pGroup2.getPerms())) {
            perms2 = new OWPermissionCollection();
        }
        Enumeration en1 = perms1.elements();
        while (en1.hasMoreElements()) {
            OWPermission perm1 = (OWPermission)en1.nextElement();
            String name1 = perm1.getName();
            boolean roleFlag1 = perm1.getRoleFlag();
            String actions = perm1.getActions();
            Enumeration en2 = perms2.elements();
            while (en2.hasMoreElements()) {
                OWPermission perm2 = (OWPermission)en2.nextElement();
                if (!name1.equals(perm2.getName()) || roleFlag1 != perm2.getRoleFlag()) continue;
                Vector<String> actions1 = new Vector<String>();
                StringTokenizer st1 = new StringTokenizer(perm1.getActions(), ",");
                while (st1.hasMoreTokens()) {
                    actions1.add(st1.nextToken());
                }
                StringTokenizer st2 = new StringTokenizer(perm2.getActions(), ",");
                while (st2.hasMoreTokens()) {
                    String act = st2.nextToken();
                    if (actions1.contains(act)) continue;
                    actions = actions + "," + act;
                }
                break block1;
            }
            OWPermission newPerm = new OWPermission(perm1.getName(), actions, perm1.getTarget());
            newPerm.setRoleFlag(perm1.getRoleFlag());
            perms.add((Permission)newPerm);
        }
        Enumeration en2 = perms2.elements();
        while (en2.hasMoreElements()) {
            OWPermission perm2 = (OWPermission)en2.nextElement();
            String name2 = perm2.getName();
            boolean roleFlag2 = perm2.getRoleFlag();
            boolean bFound = false;
            Enumeration en12 = perms1.elements();
            while (en12.hasMoreElements()) {
                OWPermission perm1 = (OWPermission)en12.nextElement();
                if (!name2.equals(perm1.getName()) || roleFlag2 != perm1.getRoleFlag()) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            perms.add((Permission)perm2);
        }
        return perms;
    }

    public static boolean setPermissions(OWObjectGroup pGroup, OWPermissionCollection pPerms) throws OWMutatorException {
        boolean bChanged = false;
        OWPermissionCollection perms = pGroup.getPerms();
        if (null == perms) {
            perms = new OWPermissionCollection();
        }
        Enumeration en1 = perms.elements();
        if (null == pPerms) {
            pPerms = new OWPermissionCollection();
        }
        Enumeration en2 = pPerms.elements();
        while (en1.hasMoreElements() && en2.hasMoreElements()) {
            OWPermission perm1 = (OWPermission)en1.nextElement();
            OWPermission perm2 = (OWPermission)en2.nextElement();
            if (perm1.getName().equals(perm2.getName()) && perm1.getActions().equals(perm2.getActions())) continue;
            bChanged = true;
            break;
        }
        boolean bl = bChanged = bChanged || en1.hasMoreElements() || en2.hasMoreElements();
        if (bChanged) {
            pGroup.setPerms(pPerms);
        }
        return bChanged;
    }

    public static void checkObjectGroups(IOWBOMClient pBOM, OWVector pObjGroups) {
        if (pObjGroups.size() > 1) {
            Iterator it = pObjGroups.iterator();
            while (it.hasNext()) {
                OWObjectGroup group = (OWObjectGroup)it.next();
                if (!"Default".equals(group.getGroupID())) continue;
                it.remove();
            }
        }
        if (pObjGroups.isEmpty()) {
            try {
                OWObjectGroup defaultGroup = AvSecurityUtil.getObjectGroup(pBOM, "Default", null);
                if (null == defaultGroup) {
                    throw new RuntimeException("Default Object Group Not Found!");
                }
                pObjGroups.add((IOWBean)defaultGroup);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static OWObjectGroup newObjectGroup(IOWBOMClient pBOM, String pName, String pGroupType) {
        try {
            RCObjectGroupUtility groupCreator = RCObjectGroupUtility.getInstance();
            return groupCreator.newObjectGroup(pName + " " + pGroupType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static OWObjectGroup getObjectGroup(IOWBOMClient pBOM, String pName, String pGroupType) throws OWBOMAPIException {
        String groupID;
        String string = groupID = null != pGroupType ? pName + " " + pGroupType : pName;
        if (null != pBOM) {
            try {
                return (OWObjectGroup)RCBOMUtil.getOWObjectByKey((IOWBOMClient)pBOM, (String)OWObjectGroup.class.getName(), (String)groupID);
            }
            catch (OWBOMNotFoundException nfe) {
            }
        } else {
            RCGetOWGroupsParamSet _n2bParamSet = new RCGetOWGroupsParamSet();
            Vector<String> _nameVector = new Vector<String>();
            _nameVector.add(groupID);
            _n2bParamSet.setGroupIDs(_nameVector);
            RedCellRuleEngineUtil.callRule((String)"RedCell.RCGetOWObjectGroups", (OWEvent)_n2bParamSet);
            Vector _rtnVector = _n2bParamSet.getRCBeans();
            if (_rtnVector.size() > 0) {
                return (OWObjectGroup)_rtnVector.firstElement();
            }
        }
        return null;
    }

    public static void initObjectGroups(IOWBOMClient pBOM) {
        try {
            OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs("com.dorado.oware.core.security.OWObjectGroup", new OWBOMAttribValueOperator("GroupID", "NOT_LIKE", (Object)"* Location"));
            qba.addAttribValueOperator(new OWBOMAttribValueOperator("AND", "GroupID", "NOT_LIKE", (Object)"*Location_"));
            qba.addAttribValueOperator(new OWBOMAttribValueOperator("AND", "GroupID", "<>", (Object)"Default"));
            Vector objGroups = (Vector)pBOM.getObjects((OWBOMQuery)qba).getRtnObject();
            AvTrace.traceln("AvSecurity", 2, "Found " + objGroups.size() + "  Obj Groups to delete.");
            for (OWObjectGroup objGroup : objGroups) {
                AvTrace.traceln("AvSecurity", 2, "Deleting obj groups: " + objGroup.getGroupID());
            }
            RCBOMUtil.getOWObjectsForUpdate((IOWBOMClient)pBOM, (Vector)objGroups);
            pBOM.deleteObjects((List)objGroups);
            pBOM.commitObjects((List)objGroups);
            pBOM.commitAll();
            AvTrace.traceln("AvSecurity", 2, "Deleted " + objGroups.size() + " Obj Groups.");
        }
        catch (OWBOMNotFoundException nfe) {
            AvTrace.traceln("AvSecurity", 2, "NO Obj Groups to delete.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            OWVector objGroups;
            Vector<Object> toCommit;
            OWBOMQueryAllByClass qbc;
            OWObjectGroup defaultObjectGroup = AvSecurityUtil.getObjectGroup(pBOM, "Default", null);
            RCBOMInternalUseMarker marker = RCBOMInternalUseMarker.getInstance();
            try {
                qbc = new OWBOMQueryAllByClass("RedCell.Config.Equipment", false);
                qbc.setMaxQuerySize(0);
                Vector equipVect = (Vector)pBOM.getObjects((OWBOMQuery)qbc).getRtnObject();
                AvTrace.traceln("AvSecurity", 2, "Found " + equipVect.size() + " Equipment objects to check.");
                toCommit = new Vector<Object>();
                for (Equipment equip : equipVect) {
                    objGroups = equip.getOwareSecurityGroups((IOWBOMInternalUseMarker)marker);
                    if (null != objGroups && !objGroups.isEmpty()) continue;
                    objGroups = new OWVector(OWObjectGroup.class);
                    objGroups.add((IOWBean)defaultObjectGroup);
                    pBOM.getObjectForUpdate((IOWBean)equip);
                    equip.setOwareSecurityGroups((IOWBOMInternalUseMarker)marker, objGroups);
                    toCommit.add(equip);
                    AvTrace.traceln("AvSecurity", 2, "Added equip: " + equip.getName() + " to default.");
                }
                if (!toCommit.isEmpty()) {
                    pBOM.commitObjects(toCommit);
                    pBOM.commitAll();
                }
                AvTrace.traceln("AvSecurity", 2, "Defaulted " + toCommit.size() + " Equipment Objects.");
            }
            catch (OWBOMNotFoundException nfe) {
                AvTrace.traceln("AvSecurity", 2, "NO Equipment to default.");
            }
            try {
                qbc = new OWBOMQueryAllByClass("RedCell.Config.Location", false);
                qbc.setMaxQuerySize(0);
                Vector locationVect = (Vector)pBOM.getObjects((OWBOMQuery)qbc).getRtnObject();
                AvTrace.traceln("AvSecurity", 2, "Found " + locationVect.size() + " Location Objects to check.");
                toCommit = new Vector();
                for (Location loc : locationVect) {
                    objGroups = loc.getOwareSecurityGroups((IOWBOMInternalUseMarker)marker);
                    if (null != objGroups && !objGroups.isEmpty()) continue;
                    OWObjectGroup objGroup = AvSecurityUtil.getObjectGroup(pBOM, loc.getLocationID() + " Location_", null);
                    if (null == objGroup) {
                        objGroup = AvSecurityUtil.createObjectGroup(loc.getLocationID() + " Location_");
                        toCommit.add(objGroup);
                    }
                    objGroups = new OWVector(OWObjectGroup.class);
                    objGroups.add((IOWBean)objGroup);
                    pBOM.getObjectForUpdate((IOWBean)loc);
                    loc.setOwareSecurityGroups((IOWBOMInternalUseMarker)marker, objGroups);
                    toCommit.add(loc);
                    AvTrace.traceln("AvSecurity", 2, "Updated location: " + loc.getLocationID() + " to default.");
                }
                if (!toCommit.isEmpty()) {
                    pBOM.commitObjects(toCommit);
                    pBOM.commitAll();
                }
                AvTrace.traceln("AvSecurity", 2, "Defaulted " + toCommit.size() + " Location Objects.");
            }
            catch (OWBOMNotFoundException nfe) {
                AvTrace.traceln("AvSecurity", 2, "NO Locations to default.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (AvTrace.isTracing("AvSecurity", 3)) {
            AvSecurityUtil.securityTest(pBOM);
        }
    }

    public static OWObjectGroup createObjectGroup(String pGroupID) throws OWMutatorException {
        OWObjectGroup objGroup = new OWObjectGroup();
        objGroup.setGroupID(pGroupID);
        objGroup.setKEY(pGroupID);
        objGroup.setCanDelete(false);
        objGroup.setPerms(new OWPermissionCollection());
        return objGroup;
    }

    public static void securityTest(final IOWBOMClient pBOM) {
        try {
            Subject sysSubject = new Subject();
            sysSubject.getPrincipals().add((Principal)IOWSecurityDef.OWARE_SYSTEM_USER_PRINCIPAL);
            Subject.doAs(sysSubject, new PrivilegedExceptionAction(){

                public Object run() throws PrivilegedActionException {
                    try {
                        AvSecurityUtil.printObjectGroups(pBOM);
                        AvSecurityUtil.printDevicesSecurity(pBOM);
                        AvSecurityUtil.printLocationsSecurity(pBOM);
                        return null;
                    }
                    catch (RuntimeException e) {
                        throw new PrivilegedActionException(e);
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            pae.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printObjectGroups(IOWBOMClient pBOM) {
        try {
            OWBOMQueryAllByClass qbc = new OWBOMQueryAllByClass(OWObjectGroup.class.getName());
            Vector results = (Vector)pBOM.getObjects((OWBOMQuery)qbc).getRtnObject();
            for (OWObjectGroup objGroup : results) {
                System.out.println("==========  ObjectGroup: " + objGroup.getGroupID());
            }
        }
        catch (OWBOMNotFoundException nfe) {
            System.out.println("==========  NO Object Groups!");
        }
        catch (OWBOMAPIException bome) {
            bome.printStackTrace();
        }
    }

    public static void printDevicesSecurity(IOWBOMClient pBOM) {
        try {
            RCBOMInternalUseMarker marker = RCBOMInternalUseMarker.getInstance();
            OWBOMQueryAllByClass qba = new OWBOMQueryAllByClass(AvDevice.class.getName(), false);
            Vector devices = (Vector)pBOM.getObjects((OWBOMQuery)qba).getRtnObject();
            for (AvDevice b : devices) {
                OWVector sec = b.getOwareSecurityGroups((IOWBOMInternalUseMarker)marker);
                StringBuffer sb = new StringBuffer();
                sb.append("-------------  Security on: " + b.getName() + " Location is " + (null != b.getLocation() ? b.getLocation().getLocationID() : "NULL") + " --> ");
                for (int i = 0; i < sec.size(); ++i) {
                    sb.append("[" + ((OWObjectGroup)sec.get(i)).getGroupID() + "]");
                    sb.append("   ");
                }
                System.out.println(sb.toString());
            }
        }
        catch (OWBOMNotFoundException nfe) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printLocationsSecurity(IOWBOMClient pBOM) {
        try {
            RCBOMInternalUseMarker marker = RCBOMInternalUseMarker.getInstance();
            OWBOMQueryAllByClass qba = new OWBOMQueryAllByClass(Location.class.getName(), false);
            Vector devices = (Vector)pBOM.getObjects((OWBOMQuery)qba).getRtnObject();
            for (Location b : devices) {
                OWVector sec = b.getOwareSecurityGroups((IOWBOMInternalUseMarker)marker);
                StringBuffer sb = new StringBuffer();
                sb.append("-------------  Security on location: " + b.getLocationID() + " --> ");
                for (int i = 0; i < sec.size(); ++i) {
                    sb.append("[" + ((OWObjectGroup)sec.get(i)).getGroupID() + "]");
                    sb.append("   ");
                }
                System.out.println(sb.toString());
            }
        }
        catch (OWBOMNotFoundException nfe) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        boolean debug = Boolean.getBoolean("com.ngnms.security.objectgroups.debug");
        if (debug) {
            AvTrace.addTraceCategory("AvSecurity", 2);
        } else if ("psycho".equals(System.getProperty("com.ngnms.security.objectgroups.debug"))) {
            psycho = true;
            AvTrace.addTraceCategory("AvSecurity", 3);
        }
    }
}

