/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.security;

import RedCell.Config.Location;
import com.bwanms.ruledelegator.redcell.RCGenericSaveRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMCommitObjectException;
import com.dorado.core.bom.OWBOMDupAddObjectException;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMQueryByNullAttribute;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.oware.core.security.OWObjectGroup;
import com.dorado.redcell.inventory.base.commandhandler.RCRuleStatus;
import com.dorado.redcell.inventory.base.commandhandler.RCSaveCommandParamSet;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.common.AvDeviceUtil;
import com.ngnms.common.AvException;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvWorkSpace;
import com.ngnms.security.AvSaveObjectGroupRule;
import com.ngnms.security.AvSecurityUtil;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import redcell.common.util.RCBOMUtil;
import redcell.common.util.RCBeanProxy;

public class AvSaveObjectGroupRuleImpl
extends RCGenericSaveRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvSaveObjectGroupRule.class);

    public void runDelegated(IOWEvent event2) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvSaveObjectGroupRule.run()");
        this.runRule((RCSaveCommandParamSet)event2);
        AvTrace.traceln("AvCS", 1, "<AvSaveObjectGroupRule.run()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRule(RCSaveCommandParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        RCBeanProxy entityProxy = pParamSet.getEntity();
        RCRuleStatus _status = new RCRuleStatus();
        AvWorkSpace ws = null;
        try {
            ws = AvWorkSpace.getAndLockWorkSpace("AvDeviceUtil_WorkSpace");
            boolean _adding = null == entityProxy.getRCOID() || entityProxy.getRCOID().toString().equals("null");
            OWObjectGroup objGroup = null;
            if (!this.isUnique(entityProxy, _adding)) {
                _status.setSuccess(false);
                _status.setMessage(this.getIsDuplicateMessage());
                pParamSet.setStatus(_status);
                return;
            }
            Vector commitVector = this.getBeans(entityProxy, _adding);
            objGroup = (OWObjectGroup)commitVector.get(0);
            this.getBOM().commitObjects((List)commitVector);
            this.getBOM().commitAll();
            pParamSet.setOid(objGroup.getHandle());
            _status.setSuccess(true);
        }
        catch (OWBOMDupAddObjectException _bdaoe) {
            _status.setSuccess(false);
            _status.setMessage(this.getIsDuplicateMessage());
        }
        catch (OWBOMCommitObjectException _bcoe) {
            String _msg = _bcoe.getMessage();
            switch (_bcoe.getMsgNum()) {
                case 116: {
                    _msg = "You must supply a key value.";
                }
            }
            _status.setSuccess(false);
            _status.setMessage(_msg);
        }
        catch (Exception _e) {
            AvTrace.traceStack("AvSecurity", 1, _e);
            _status.setSuccess(false);
            _status.setMessage(_e.getMessage());
        }
        finally {
            if (null != ws) {
                try {
                    ws.closeWorkSpace();
                }
                catch (AvException ave) {
                    ave.printStackTrace();
                }
            }
        }
        pParamSet.setStatus(_status);
    }

    public Vector getBeans(RCBeanProxy pProxy, boolean pAdding) throws Exception {
        Vector ret = super.getBeans(pProxy, pAdding);
        OWObjectGroup objGroup = (OWObjectGroup)ret.get(0);
        String groupID = pProxy.getAsString("GroupID");
        if (groupID.endsWith(" Location")) {
            Location parent;
            Location location;
            block13: {
                location = null;
                parent = null;
                try {
                    location = (Location)RCBOMUtil.getOWObjectByKey((IOWBOMClient)this.getBOM(), (String)"RedCell.Config.Location", (String)groupID.substring(0, groupID.length() - " Location".length()));
                    if (null != location.getParent() && location.getParent().length() > 0) {
                        parent = (Location)RCBOMUtil.getOWObjectByKey((IOWBOMClient)this.getBOM(), (String)"RedCell.Config.Location", (String)location.getParent());
                    }
                }
                catch (OWBOMNotFoundException e) {
                    AvTrace.traceln("AvLocation", 2, "Location for " + groupID + " Not found.");
                    if (!pAdding || null != location) break block13;
                    throw new Exception("Location for Object Group Not Found!");
                }
            }
            if (null != location) {
                AvTrace.traceln("AvLocation", 3, "SaveObjectGroupRule commitVector before updateSecRec: " + ret.size());
                AvDeviceUtil.updateLocationSecurityRec(this.getBOM(), location, parent, objGroup, ret);
                AvTrace.traceln("AvLocation", 3, "SaveObjectGroupRule commitVector after updateSecRec: " + ret.size());
            }
        } else if ("Default".equals(groupID)) {
            AvTrace.traceln("AvLocation", 3, "SaveObjectGroupRule: Default Group");
            Vector topLocations = new Vector();
            try {
                OWBOMQueryByNullAttribute _qbna = new OWBOMQueryByNullAttribute("RedCell.Config.Location", "Parent", false);
                topLocations.addAll((List)this.getBOM().getObjects((OWBOMQuery)_qbna).getRtnObject());
            }
            catch (OWBOMNotFoundException nfe) {
                // empty catch block
            }
            try {
                OWBOMQueryByAttribs _qba = new OWBOMQueryByAttribs("RedCell.Config.Location", new OWBOMAttribValueOperator("Parent", "=", (Object)""), false);
                topLocations.addAll((List)this.getBOM().getObjects((OWBOMQuery)_qba).getRtnObject());
            }
            catch (OWBOMNotFoundException nfe) {
                // empty catch block
            }
            Enumeration _objList = topLocations.elements();
            while (_objList.hasMoreElements()) {
                Location location = (Location)_objList.nextElement();
                OWObjectGroup definedObjGroup = AvSecurityUtil.getObjectGroup(this.getBOM(), location.getLocationID() + " Location", null);
                if (null == definedObjGroup) {
                    AvDeviceUtil.updateLocationSecurityRec(this.getBOM(), location, null, definedObjGroup, ret);
                }
                AvTrace.traceln("AvLocation", 3, "SaveObjectGroupRule commitVector after updateSecRec on " + location.getLocationID() + ": " + ret.size());
            }
        }
        return ret;
    }

    public boolean isUnique(RCBeanProxy pProxy, boolean pAdding) throws Exception {
        if (pAdding) {
            try {
                RCBOMUtil.getOWObjectByKey((IOWBOMClient)this.getBOM(), (String)pProxy.getRCClass(), (String)pProxy.getAsString("GroupID"));
                return false;
            }
            catch (OWBOMNotFoundException oWBOMNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }
}

