/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.security;

import RedCell.ObjectGroupManagerJAVAGUI;
import com.dorado.apps.securitymanager.OWPrincipalInfo;
import com.dorado.common.guiutil.OWDialogUtils;
import com.dorado.common.widget.components.explorer.IOWExplorerNodeContainer;
import com.dorado.common.widget.components.explorer.OWExplorerNodeContainer;
import com.dorado.common.widget.components.formlauncher.IOWFormLauncher;
import com.dorado.core.security.OWPermission;
import com.dorado.core.security.OWPermissionCollection;
import com.dorado.redcell.inventory.base.commandhandler.RCRuleStatus;
import com.dorado.redcell.inventory.base.commandhandler.RCSaveCommandParamSet;
import com.dorado.runtime.OWEvent;
import com.ngnms.security.AvObjectGroupFrame;
import com.ngnms.security.AvObjectGroupPermissionFrame;
import com.ngnms.security.AvObjectGroupSecurityMain;
import com.ngnms.security.AvSecurityUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.security.Permission;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import oracle.help.Help;
import redcell.common.util.IRedCellTypeDefs;
import redcell.common.util.RCBeanProxy;
import redcell.common.util.RCBeanProxyUtil;
import redcell.common.util.RCMessageQuery;
import redcell.common.util.RCOptionPaneUtil;
import redcell.common.util.RCQueryBlock;
import redcell.common.util.RedCellHelpUtil;
import redcell.common.util.RedCellManagerButtonPanel;
import redcell.common.util.RedCellRuleEngineUtil;
import redcell.common.util.RedCellRuntimeUtil;
import redcell.common.util.RedCellWorkSpaceUtil;
import redcell.core.usersys.RCUserUtil;
import redcell.core.usersys.RedCellRuntimeUser;

public class AvObjectGroupSecurityMainPanel
extends ObjectGroupManagerJAVAGUI
implements ActionListener,
MouseListener,
IRedCellTypeDefs {
    private AvObjectGroupSecurityMain frame;
    private Vector vecGroups = null;
    private RCBeanProxy objGrpProxy = null;
    private RedCellManagerButtonPanel btnPanel;
    private static RCMessageQuery rb = new RCMessageQuery("RC_USER");
    private static String defaultGroupName = RedCellWorkSpaceUtil.getProperty((String)"redcell.security.defaultObjectGroup", (String)"Default");
    private HashMap groupMap = null;
    private HashMap model = null;

    public AvObjectGroupSecurityMainPanel(AvObjectGroupSecurityMain pFrame) {
        this.frame = pFrame;
        if (RedCellRuntimeUtil.onServer()) {
            throw new RuntimeException(this.getClass().getName() + " is not a webable class");
        }
        this.initPanel();
    }

    private void initPanel() {
        this.setupButtons();
        this.configNewButton(false);
        this.configDeleteButton(false);
        this.newButton.setVisible(false);
        this.deleteButton.setVisible(false);
        this.getObjectGroups();
        this.addObjectGroupsToList();
    }

    public void fillTable(OWPermissionCollection pPermCol) {
        if (pPermCol == null) {
            this.prmTable.clearNodes();
            this.prmTable.refresh();
            this.enabledEdit(false);
            this.enabledDelete(false);
            this.enabledAdd(false);
        } else if (!pPermCol.elements().hasMoreElements()) {
            this.prmTable.clearNodes();
            this.prmTable.refresh();
        } else {
            this.prmTable.clearNodes();
            Enumeration _enum = pPermCol.elements();
            OWPermission _perm = null;
            OWExplorerNodeContainer _root = (OWExplorerNodeContainer)this.prmTable.getRoot();
            while (_enum.hasMoreElements()) {
                _perm = (OWPermission)_enum.nextElement();
                OWExplorerNodeContainer _row = new OWExplorerNodeContainer(_perm.getName(), _perm.getName(), _perm.getName(), "Style");
                OWExplorerNodeContainer _node = new OWExplorerNodeContainer("", _perm.getName(), "", "Style");
                _row.add((IOWExplorerNodeContainer)_node);
                _node = new OWExplorerNodeContainer("", _perm.getActions(), "", "Style");
                _row.add((IOWExplorerNodeContainer)_node);
                _root.add((IOWExplorerNodeContainer)_row);
                OWPrincipalInfo _pinfo = new OWPrincipalInfo(_perm.getName(), _perm.getRoleFlag());
                Object[] _newElement = new Object[]{_pinfo, _perm.getActions()};
                this.model.put(_perm.getName(), _newElement);
            }
            this.prmTable.refresh();
            if (this.prmTable.getSelectionCount() > 0) {
                this.enabledEdit(false);
                this.enabledDelete(false);
                this.enabledAdd(true);
            } else {
                this.enabledEdit(true);
                this.enabledDelete(true);
                this.enabledAdd(true);
            }
        }
        this.tableValueChanged();
    }

    private String getSelectedName() {
        IOWExplorerNodeContainer[] _containers = this.prmTable.getSelectedRowNodeContainers();
        if (_containers != null && _containers.length > 0) {
            IOWExplorerNodeContainer _row = _containers[0];
            return _row.getNode().getValue();
        }
        return null;
    }

    private OWPrincipalInfo getSelectedRowData() {
        Object[] _newElement;
        OWPrincipalInfo _principal = null;
        String _name = this.getSelectedName();
        if (_name != null && (_newElement = (Object[])this.model.get(_name)) != null) {
            _principal = (OWPrincipalInfo)_newElement[0];
            return _principal;
        }
        return null;
    }

    private String getSelectedRowActions() {
        Object[] _newElement;
        String _name = this.getSelectedName();
        if (_name != null && (_newElement = (Object[])this.model.get(_name)) != null) {
            String _actions = (String)_newElement[1];
            return _actions;
        }
        return null;
    }

    private void loadObjectGroupData(String pObjGrpName) {
        this.objGrpProxy = RCBeanProxyUtil.getProxyBeanByKeyWithPermissions((String)pObjGrpName, (String)"com.dorado.oware.core.security.OWObjectGroup");
        OWPermissionCollection _permCol = this.objGrpProxy.getRCPermissionCollection();
        this.fillTable(_permCol);
    }

    private void addObjectGroupsToList() {
        String[] groupIDs = this.sortObjectGroups(this.vecGroups);
        this.lstObjGrps.clearNodes();
        OWExplorerNodeContainer _root = (OWExplorerNodeContainer)this.lstObjGrps.getRoot();
        OWExplorerNodeContainer _node = null;
        for (int i = 0; i < groupIDs.length; ++i) {
            String _id = groupIDs[i];
            _node = new OWExplorerNodeContainer("", _id, "", "Style");
            _root.add((IOWExplorerNodeContainer)_node);
        }
        this.lstObjGrps.refresh();
    }

    private void getObjectGroups() {
        this.groupMap = new HashMap();
        try {
            if (!AvSecurityUtil.psycho) {
                RCQueryBlock queryBlock = new RCQueryBlock("GroupID", (Object)"*_", "LIKE", "NOT");
                this.vecGroups = RCBeanProxyUtil.getProxysByAttrib((String)"com.dorado.oware.core.security.OWObjectGroup", (RCQueryBlock)queryBlock, (boolean)true);
                System.out.println("RCQUERY BLOCKS size: " + this.vecGroups.size());
                this.vecGroups = new Vector();
                Vector allGroups = RCBeanProxyUtil.getProxysByAttrib((String)"com.dorado.oware.core.security.OWObjectGroup", (boolean)true);
                for (RCBeanProxy grp : allGroups) {
                    if (grp.getAsString("GroupID").endsWith("_")) continue;
                    this.vecGroups.add(grp);
                }
            } else {
                this.vecGroups = RCBeanProxyUtil.getProxysByAttrib((String)"com.dorado.oware.core.security.OWObjectGroup", (boolean)true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void newObjectGroup() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Hashtable _hash = RedCellRuntimeUtil.createParameterHash((IOWFormLauncher)this.frame.getFormLauncher());
        _hash.put("Action", "NEW");
        _hash.put("CallingPanel", this);
        RedCellRuntimeUtil.showPanel((Object[])new Object[]{AvObjectGroupFrame.class.getName(), _hash, Boolean.TRUE});
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void deleteObjectGroup() {
        int response = RCOptionPaneUtil.showSwingConfirmDialog((Component)((Object)this), (Object)rb.getString(79L), (String)rb.getString(77L), (int)0, (int)3);
        this.requestFocus();
        if (response == 0) {
            throw new RuntimeException("DELETE NOT IMPLEMENTED");
        }
    }

    private void saveObjectGroup() {
    }

    public void permissionClick() {
        this.editPermission();
    }

    private void addPermission() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Hashtable _hash = RedCellRuntimeUtil.createParameterHash((IOWFormLauncher)this.frame.getFormLauncher());
        _hash.put("ObjectGroupProxy", this.objGrpProxy);
        _hash.put("Principal", "bogus");
        _hash.put("RoleFlag", Boolean.TRUE);
        _hash.put("CallingPanel", this);
        RedCellRuntimeUtil.showPanel((Object[])new Object[]{AvObjectGroupPermissionFrame.class.getName(), _hash, Boolean.TRUE});
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void editPermission() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        OWPrincipalInfo _principal = this.getSelectedRowData();
        String _name = _principal.getName();
        String _actions = this.getSelectedRowActions();
        Hashtable _hash = RedCellRuntimeUtil.createParameterHash((IOWFormLauncher)this.frame.getFormLauncher());
        _hash.put("ObjectGroupProxy", this.objGrpProxy);
        _hash.put("Principal", _principal.getName());
        _hash.put("RoleFlag", _principal.isRole() ? Boolean.TRUE : Boolean.FALSE);
        _hash.put("Actions", _actions);
        _hash.put("CallingPanel", this);
        RedCellRuntimeUser redCellRuntimeUser = RCUserUtil.getCurrentUser();
        RCUserUtil.getCurrentUser();
        if (!redCellRuntimeUser.isFunctionAllowed("RCCore:ManagePermissions", RedCellRuntimeUser.WRITE_PERM)) {
            _hash.put("EditorReadOnly", " ");
        }
        RedCellRuntimeUtil.showPanel((Object[])new Object[]{AvObjectGroupPermissionFrame.class.getName(), _hash, Boolean.TRUE});
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void helpButtonClick() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Help.registerClientWindow((Window)RedCellRuntimeUtil.getLaunchConsole());
            RedCellHelpUtil.showHelp((Window)RedCellRuntimeUtil.getLaunchConsole(), (String)RedCellWorkSpaceUtil.getProperty((String)"redcell.object_security", (String)"RedcellPortalNavigation"));
        }
        catch (Throwable _e) {
            RedCellRuntimeUtil.printStackTrace((Throwable)_e);
            RCOptionPaneUtil.showSwingMessageDialog((Component)((Object)this.frame), (Object)(rb.getString(5L) + "\n\n" + rb.getString(6L) + _e.getMessage()), (String)rb.getString(7L), (int)0);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String[] sortObjectGroups(Vector pVec) {
        for (int i = 0; i < pVec.size(); ++i) {
            for (int j = i; j < pVec.size(); ++j) {
                if (((String)((RCBeanProxy)pVec.elementAt(i)).get("GroupID")).compareToIgnoreCase((String)((RCBeanProxy)pVec.elementAt(j)).get("GroupID")) <= 0) continue;
                RCBeanProxy _temp = (RCBeanProxy)pVec.elementAt(j);
                pVec.setElementAt(pVec.elementAt(i), j);
                pVec.setElementAt(_temp, i);
            }
        }
        return this.buildObjectGroupArray(pVec);
    }

    private String[] buildObjectGroupArray(Vector pVec) {
        String[] dispNames = new String[pVec.size()];
        for (int i = 0; i < pVec.size(); ++i) {
            String _id;
            RCBeanProxy _temp = (RCBeanProxy)pVec.elementAt(i);
            dispNames[i] = _id = _temp.getAsString("GroupID");
            this.groupMap.put(_id, _temp);
        }
        return dispNames;
    }

    private void close() {
        this.frame.closeForm();
    }

    private void configNewButton(boolean pEnabled) {
        this.newButton.setEnabled(pEnabled);
    }

    private void configDeleteButton(boolean pEnabled) {
        if (pEnabled && this.lstObjGrps.getSelectionCount() > 0) {
            this.deleteButton.setEnabled(true);
            this.btnPanel.btnNew.setEnabled(true);
            this.btnPanel.btnEdit.setEnabled(true);
            this.btnPanel.btnDelete.setEnabled(true);
        } else {
            this.deleteButton.setEnabled(false);
            this.btnPanel.btnNew.setEnabled(false);
            this.btnPanel.btnEdit.setEnabled(false);
            this.btnPanel.btnDelete.setEnabled(false);
        }
    }

    public void refreshObjectGroupList() {
        this.getObjectGroups();
        this.addObjectGroupsToList();
        this.listValueChanged();
    }

    public void refreshObjectGroupList(RCBeanProxy pProxy) {
        this.getObjectGroups();
        this.addObjectGroupsToList();
        String _id = pProxy.getAsString("GroupID");
        IOWExplorerNodeContainer _n = this.lstObjGrps.getNodeContainerByNodeAttribValue(this.lstObjGrps.getRoot(), _id, 4);
        if (_n != null) {
            this.lstObjGrps.selectNode(_n);
        }
        this.listValueChanged();
    }

    public void refreshObjectGroupListWithNew(RCBeanProxy pProxy) {
        this.getObjectGroups();
        this.addObjectGroupsToList();
        String _id = pProxy.getAsString("GroupID");
        IOWExplorerNodeContainer _n = this.lstObjGrps.getNodeContainerByNodeAttribValue(this.lstObjGrps.getRoot(), _id, 4);
        if (_n != null) {
            this.lstObjGrps.selectNode(_n);
        }
        this.listValueChanged();
    }

    private void setupButtons() {
        this.btnPanel = new RedCellManagerButtonPanel((ActionListener)this, false, 14, false, true);
        this.buttonPanel.setLayout((LayoutManager)new FlowLayout(0));
        this.buttonPanel.add((Component)this.btnPanel);
        this.frame.getAuxPane().setLayout(new FlowLayout(2));
        this.newButton.addActionListener((ActionListener)this);
        this.deleteButton.addActionListener((ActionListener)this);
    }

    private void deleteSelectedItem() {
        String _name = this.getSelectedName();
        if (this.model.containsKey(_name)) {
            this.model.remove(_name);
            this.prmTable.removeSelectedNodes();
        }
    }

    private Vector getDataVector() {
        Vector _list = new Vector();
        Iterator _iter = this.model.keySet().iterator();
        while (_iter.hasNext()) {
            try {
                String _key = (String)_iter.next();
                Object _obj = this.model.get(_key);
                _list.add(_obj);
            }
            catch (Exception _e) {
                OWDialogUtils.popExceptionDialog((String)_e.getMessage(), (Throwable)_e, (boolean)true);
                _e.printStackTrace();
            }
        }
        return _list;
    }

    private void deletePermission() {
        int response = RCOptionPaneUtil.showSwingConfirmDialog((Component)((Object)this), (Object)rb.getString(78L), (String)rb.getString(77L), (int)0, (int)3);
        this.requestFocus();
        if (response == 0) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String _name = this.getSelectedName();
            if (_name != null) {
                OWPermissionCollection _permCollection = new OWPermissionCollection();
                this.deleteSelectedItem();
                Vector _dataVector = this.getDataVector();
                for (int count = 0; count < _dataVector.size(); ++count) {
                    Object[] _permission = (Object[])_dataVector.elementAt(count);
                    OWPermission _perm = new OWPermission(_permission[0].toString(), _permission[1].toString(), "[Entry]");
                    _perm.setRoleFlag(((OWPrincipalInfo)_permission[0]).isRole());
                    _permCollection.add((Permission)_perm);
                }
                this.objGrpProxy.setRCPermissionCollection(_permCollection);
                RCSaveCommandParamSet ps = new RCSaveCommandParamSet();
                ps.setEntity(this.objGrpProxy);
                RedCellRuleEngineUtil.callRule((String)"com.ngnms.security.AvSaveObjectGroupRule", (OWEvent)ps);
                RCRuleStatus status = ps.getStatus();
                if (!status.getSuccess()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), status.getMessage(), rb.getString(7L), 0);
                    return;
                }
                this.fillTable(_permCollection);
                this.enabledDelete(false);
                this.enabledEdit(false);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void enabledEdit(boolean pFlag) {
        this.btnPanel.btnEdit.setEnabled(pFlag);
    }

    private void enabledAdd(boolean pFlag) {
        this.btnPanel.btnNew.setEnabled(pFlag);
    }

    private void enabledDelete(boolean pFlag) {
        this.btnPanel.btnDelete.setEnabled(pFlag);
    }

    public AvObjectGroupSecurityMain getFrame() {
        return this.frame;
    }

    private void importPermissions() {
    }

    private void exportPermissions() {
    }

    public void actionPerformed(ActionEvent ae) {
        Object obj = ae.getSource();
        if (obj instanceof JButton) {
            JButton but = (JButton)obj;
            String _action = ae.getActionCommand();
            if (but == this.newButton) {
                this.newObjectGroup();
                return;
            }
            if (but == this.deleteButton) {
                this.deleteObjectGroup();
                return;
            }
            if (but == this.btnPanel.btnNew) {
                this.addPermission();
            } else if (but == this.btnPanel.btnEdit) {
                this.editPermission();
            } else if (but == this.btnPanel.btnDelete) {
                this.deletePermission();
            }
        }
    }

    public void mouseClicked(MouseEvent me) {
        if (me.getClickCount() == 2) {
            // empty if block
        }
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    private RCBeanProxy getProxyByGroupID(String pGroupID) {
        if (this.groupMap.containsKey(pGroupID)) {
            return (RCBeanProxy)this.groupMap.get(pGroupID);
        }
        return null;
    }

    private String getSelectedGroupID() {
        if (this.lstObjGrps.getSelectionCount() > 0) {
            String _id = this.lstObjGrps.getSelectedText();
            return _id;
        }
        return null;
    }

    public void listValueChanged() {
        if (this.model == null) {
            this.model = new HashMap();
        } else {
            this.model.clear();
        }
        String _id = this.getSelectedGroupID();
        if (_id != null) {
            RCBeanProxy _proxy = this.getProxyByGroupID(_id);
            this.setCursor(Cursor.getPredefinedCursor(3));
            Boolean _canDelete = _proxy.getAsBoolean("CanDelete");
            this.deleteButton.setEnabled(_canDelete.booleanValue());
            this.loadObjectGroupData(_id);
            this.setCursor(Cursor.getDefaultCursor());
            this.enabledAdd(true);
        } else {
            this.prmTable.clearNodes();
            this.prmTable.refresh();
            this.enabledAdd(false);
        }
    }

    public void tableValueChanged() {
        if (this.prmTable.getSelectionCount() > 0) {
            this.enabledEdit(true);
            this.enabledDelete(true);
        } else {
            this.enabledEdit(false);
            this.enabledDelete(false);
        }
    }
}

