/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.patches.mediation;

import com.dorado.common.utility.OWIPUtility;
import com.dorado.mbeans.OWMedServerTrackerMBean;
import com.dorado.oware.core.mediation.agent.OWAssignmentBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class AvMedServerTrackerMBean
extends OWMedServerTrackerMBean {
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.patches.mediation.debugOn");
    TreeMap ipRanges = new TreeMap();

    protected void startService() throws Exception {
        super.startService();
    }

    public synchronized void addAgent(OWAssignmentBean pBean) throws Exception {
        if (debugOn) {
            System.out.println("addAgent(). agent is " + pBean.getIPAddress());
        }
        super.addAgent(pBean);
        String _key = AvMedServerTrackerMBean.createKey(pBean);
        Vector _ranges = (Vector)this.ipRanges.get(_key);
        if (null == _ranges || _ranges.isEmpty()) {
            if (debugOn) {
                System.out.println("agent ranges not found. creating... ");
            }
            _ranges = AvMedServerTrackerMBean.parseIPRanges(pBean);
            this.ipRanges.put(_key, _ranges);
        } else if (debugOn) {
            System.out.println("agent already in ipRanges list. skipping...");
        }
    }

    public synchronized void removeAgent(String pKey) {
        if (debugOn) {
            System.out.println("  removeAgent(). key is " + pKey);
        }
        super.removeAgent(pKey);
        this.ipRanges.remove(pKey);
    }

    public synchronized void refreshAgentList() {
        if (debugOn) {
            System.out.println("  refreshAgentList().");
        }
        super.refreshAgentList();
        this.refreshRanges();
    }

    private void refreshRanges() {
        TreeMap<String, Vector> _newIpRanges = new TreeMap<String, Vector>();
        Set agents = this.getAllAgents();
        if (debugOn) {
            System.out.println("  refreshRanges().  agents size: " + agents.size());
        }
        for (OWAssignmentBean _nextAgent : agents) {
            String _key = AvMedServerTrackerMBean.createKey(_nextAgent);
            Vector _ranges = (Vector)this.ipRanges.get(_key);
            if (null == _ranges || _ranges.isEmpty()) {
                _ranges = AvMedServerTrackerMBean.parseIPRanges(_nextAgent);
                _newIpRanges.put(_key, _ranges);
                continue;
            }
            _newIpRanges.put(_key, _ranges);
        }
        if (debugOn) {
            System.out.println("refreshRanges():  old ranges size: " + this.ipRanges.size() + "  new ranges size: " + _newIpRanges.size());
        }
        this.ipRanges = _newIpRanges;
    }

    public Set getAgents(String pIpDest, String pSubNet) throws Exception {
        if (debugOn) {
            System.out.println("pIpDest = " + pIpDest + "  pSubNet = " + pSubNet + "    Search in allRanges - size is " + this.ipRanges.size());
        }
        HashSet<OWAssignmentBean> _ordered = new HashSet<OWAssignmentBean>();
        Set activeAgents = this.getAllAgents();
        try {
            InetAddress _address = InetAddress.getByName(pIpDest);
            pIpDest = _address.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            if (debugOn) {
                System.out.println("unknown host: " + pIpDest);
            }
            return activeAgents;
        }
        long _ipAddr = AvMedServerTrackerMBean.ipStringToLong(pIpDest);
        block2: for (OWAssignmentBean _nextAgent : activeAgents) {
            String _key = AvMedServerTrackerMBean.createKey(_nextAgent);
            Vector _ranges = (Vector)this.ipRanges.get(_key);
            if (null == _ranges) {
                _ranges = AvMedServerTrackerMBean.parseIPRanges(_nextAgent);
                this.ipRanges.put(_key, _ranges);
            }
            Iterator it = _ranges.iterator();
            while (it.hasNext()) {
                if (!AvMedServerTrackerMBean.isInRange(_ipAddr, (long[])it.next())) continue;
                _ordered.add(_nextAgent);
                continue block2;
            }
        }
        return _ordered;
    }

    private static String createKey(OWAssignmentBean pBean) {
        return pBean.getPartitionName() + "::" + pBean.getIPAddress() + "::" + pBean.getAgentPort();
    }

    private static boolean isInRange(long pIpAddr, long[] pRange) {
        if (pIpAddr >= pRange[0] && pIpAddr <= pRange[1]) {
            if (debugOn) {
                System.out.println("-----  FOUND ip " + AvMedServerTrackerMBean.ipLongToString(pIpAddr) + "  in range " + AvMedServerTrackerMBean.ipLongToString(pRange[0]) + "-" + AvMedServerTrackerMBean.ipLongToString(pRange[1]));
            }
            return true;
        }
        return false;
    }

    static Vector parseIPRanges(OWAssignmentBean pBean) {
        String pRanges = pBean.getSubnetMask();
        if (debugOn) {
            System.out.println(" parseIPRanges() - pRanges is " + pRanges);
        }
        if (null == pRanges) {
            return null;
        }
        Vector<long[]> ranges = new Vector<long[]>();
        StringTokenizer st = new StringTokenizer(pRanges, ",");
        while (st.hasMoreTokens()) {
            long[] range;
            long[] range2;
            String _token = st.nextToken();
            int pos = _token.indexOf(47);
            if (-1 != pos) {
                String ipAddr = _token.substring(0, pos).trim();
                String mask = _token.substring(pos + 1).trim();
                if (!OWIPUtility.validIPAddress((String)ipAddr) || !OWIPUtility.validIPMask((String)mask) || null == (range2 = AvMedServerTrackerMBean.convertIPSubnetToRange(ipAddr, mask))) continue;
                ranges.add(range2);
                if (!debugOn) continue;
                System.out.println("Added new range 1 " + AvMedServerTrackerMBean.ipLongToString(range2[0]) + " - " + AvMedServerTrackerMBean.ipLongToString(range2[1]));
                continue;
            }
            pos = _token.indexOf(45);
            if (-1 != pos) {
                String startIpAddr = _token.substring(0, pos).trim();
                String endIpAddr = _token.substring(pos + 1).trim();
                if (!OWIPUtility.validIPAddress((String)startIpAddr) || !OWIPUtility.validIPAddress((String)endIpAddr)) continue;
                range2 = new long[]{AvMedServerTrackerMBean.ipStringToLong(startIpAddr), AvMedServerTrackerMBean.ipStringToLong(endIpAddr)};
                ranges.add(range2);
                if (!debugOn) continue;
                System.out.println("Added new range 2 " + AvMedServerTrackerMBean.ipLongToString(range2[0]) + " - " + AvMedServerTrackerMBean.ipLongToString(range2[1]));
                continue;
            }
            if (OWIPUtility.validIPMask((String)_token)) {
                range = AvMedServerTrackerMBean.convertIPSubnetToRange(pBean.getIPAddress(), _token);
                ranges.add(range);
                if (!debugOn) continue;
                System.out.println("Added new range 3 " + AvMedServerTrackerMBean.ipLongToString(range[0]) + " - " + AvMedServerTrackerMBean.ipLongToString(range[1]));
                continue;
            }
            if (!OWIPUtility.validIPAddress((String)_token)) continue;
            range = new long[]{AvMedServerTrackerMBean.ipStringToLong(_token), AvMedServerTrackerMBean.ipStringToLong(_token)};
            ranges.add(range);
            if (!debugOn) continue;
            System.out.println("Added new range 4 " + AvMedServerTrackerMBean.ipLongToString(range[0]) + " - " + AvMedServerTrackerMBean.ipLongToString(range[1]));
        }
        return ranges;
    }

    private static long[] convertIPSubnetToRange(String pIpAddr, String pIpMask) {
        long _ipAddr = AvMedServerTrackerMBean.ipStringToLong(pIpAddr);
        long _mask = AvMedServerTrackerMBean.ipStringToLong(pIpMask);
        long[] _range = new long[]{_ipAddr & _mask, _ipAddr | 0xFFFFFFFFL & (_mask ^ 0xFFFFFFFFFFFFFFFFL)};
        if (debugOn) {
            System.out.println("convertIPSubnetToRange: " + pIpAddr + "/" + pIpMask + " to " + AvMedServerTrackerMBean.ipLongToString(_range[0]) + "-" + AvMedServerTrackerMBean.ipLongToString(_range[1]));
        }
        return _range;
    }

    public static String ipLongToString(long ip) {
        StringBuffer _sb = new StringBuffer();
        _sb.append(ip >> 24 & 0xFFL);
        _sb.append('.');
        _sb.append(ip >> 16 & 0xFFL);
        _sb.append('.');
        _sb.append(ip >> 8 & 0xFFL);
        _sb.append('.');
        _sb.append(ip & 0xFFL);
        return _sb.toString();
    }

    private static long ipStringToLong(String pIpAddress) {
        StringTokenizer _st = new StringTokenizer(pIpAddress, ".");
        if (_st.countTokens() != 4) {
            throw new NumberFormatException("Invalid Ip Address: " + pIpAddress);
        }
        long _ip = Long.parseLong(_st.nextToken()) << 24 | Long.parseLong(_st.nextToken()) << 16 | Long.parseLong(_st.nextToken()) << 8 | Long.parseLong(_st.nextToken());
        return _ip;
    }

    static {
        if (debugOn) {
            System.out.println("LOADED AV mediation tracker.");
        }
    }
}

