/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.patches.inventory;

import com.bwanms.gui.configuration.ConfigApplicationView;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.services.ServiceRegistry;
import com.dorado.common.widget.components.formlauncher.IOWFormLauncher;
import com.dorado.runtime.IOWRuntimeForm;
import java.util.Hashtable;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import redcell.common.commandhandler.RCEditEntityHandler;
import redcell.common.interfaces.IRCEntityManager;
import redcell.common.util.RCBeanProxy;
import redcell.common.util.RCEquipmentUtil;

public class EditEquipmentHandler
extends RCEditEntityHandler {
    private static final Logger logger = Logger.getLogger(EditEquipmentHandler.class);
    protected IRCEntityManager manager = null;

    public void execute(IRCEntityManager pManager) {
        this.manager = pManager;
        super.execute(pManager);
    }

    public void launchEditor() {
        IOWFormLauncher formLauncher = this.manager.getFormLauncher();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("id", String.valueOf(props.hashCode()));
        props.put("FormLauncher", formLauncher);
        props.put("_title", this.getTitle(this.selectedProxy));
        if (null != formLauncher) {
            JPanel panel = this.getEditPanel(this.selectedProxy);
            props.put("SwingForm", panel);
            try {
                IOWRuntimeForm form = formLauncher.addPanel("RedCell.SwingFormContainer", props);
                formLauncher.showPanel(form, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getTitle(RCBeanProxy pEntity) {
        String _name = (String)pEntity.get("Name");
        String _title = _name == null ? "Editing (" + pEntity.getRCClass() + ")" : "Editing Equipment (" + RCEquipmentUtil.getEditorTitle((RCBeanProxy)pEntity) + ")";
        return _title;
    }

    private JPanel getEditPanel(RCBeanProxy selectedProxy) {
        String equipmentEUID = (String)selectedProxy.get("EUID");
        logger.info((Object)("Got EUID: [" + equipmentEUID + "]"));
        EquipmentConfiguration configuration = ServiceRegistry.getInventoryManagementService().findFullCurrentConfiguration(equipmentEUID);
        if (configuration == null) {
            throw new RuntimeException("Configuration does not exist for equipment with euid=" + equipmentEUID);
        }
        return (JPanel)new ConfigApplicationView(configuration).getUI();
    }
}

