/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.patches.inventory;

import com.dorado.common.utility.OWUtility;
import com.dorado.common.widget.components.formlauncher.IOWFormLauncher;
import com.dorado.redcell.inventory.base.RCDropInCustodian;
import com.dorado.redcell.inventory.base.RCFilterDefNPC;
import com.dorado.redcell.inventory.base.RCManagerDefNPC;
import com.dorado.runtime.IOWBaseBean;
import com.dorado.runtime.IOWRuntimeForm;
import com.dorado.runtime.OWBaseVector;
import com.dorado.runtime.OWInvalidTypeException;
import com.dorado.runtime.OWSet;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import redcell.common.interfaces.IRCEntityManager;
import redcell.common.interfaces.IRCEntitySelectionRequestor;

public class AvGenericManagerConfig {
    private static final String DEFAULT_PANEL_NAME = "com.dorado.redcell.inventory.base.RCManagerPanel";
    private static final boolean timingDebugOn = Boolean.getBoolean("com.dorado.redcell.gui.config.performance.debug");
    IOWFormLauncher formLauncher = null;
    private OWBaseVector filters = null;
    private OWBaseVector filterPanels = null;
    private OWSet commandHandlers = null;
    private Vector attribNames = null;
    private Vector columnNames = null;
    private String panelName = null;
    private String entityName = null;
    private Hashtable paramHash = null;
    private String title = null;
    private boolean modal = false;
    private IOWRuntimeForm form = null;
    private RCManagerDefNPC managerDef = null;
    private Hashtable userProps = new Hashtable();
    private IRCEntitySelectionRequestor selectionReqForm = null;

    public AvGenericManagerConfig(IOWFormLauncher pFormLauncher, String pEntityName) {
        this(pFormLauncher, pEntityName, true, null, (String)null);
    }

    public AvGenericManagerConfig(IOWFormLauncher pFormLauncher, String pEntityName, boolean pManagerMode, IRCEntitySelectionRequestor pForm) {
        this(pFormLauncher, pEntityName, pManagerMode, pForm, (String)null);
    }

    public AvGenericManagerConfig(IOWFormLauncher pFormLauncher, String pEntityName, boolean pManagerMode, IRCEntitySelectionRequestor pForm, RCFilterDefNPC pFilter) {
        this.formLauncher = pFormLauncher;
        this.modal = !pManagerMode;
        this.entityName = pEntityName;
        this.selectionReqForm = pForm;
        try {
            this.filters = new OWBaseVector(RCFilterDefNPC.class);
            this.filters.add((IOWBaseBean)pFilter);
        }
        catch (OWInvalidTypeException _e) {
            // empty catch block
        }
        long _start = timingDebugOn ? System.currentTimeMillis() : 0L;
        this.fetchFormData(pEntityName, pFilter.getFilterName(), pManagerMode);
        if (timingDebugOn) {
            OWUtility.timingDebugOut((long)(System.currentTimeMillis() - _start), (String)("fetchFormData() for " + pEntityName), (String)"RCGenericManagerConfig");
        }
        this.buildParamHash();
    }

    public AvGenericManagerConfig(IOWFormLauncher pFormLauncher, String pEntityName, boolean pManagerMode, IRCEntitySelectionRequestor pForm, String pFilterName) {
        this.formLauncher = pFormLauncher;
        this.modal = !pManagerMode;
        this.entityName = pEntityName;
        this.selectionReqForm = pForm;
        long _start = timingDebugOn ? System.currentTimeMillis() : 0L;
        this.fetchFormData(pEntityName, pFilterName, pManagerMode);
        if (timingDebugOn) {
            OWUtility.timingDebugOut((long)(System.currentTimeMillis() - _start), (String)("fetchFormData() for " + pEntityName), (String)"RCGenericManagerConfig");
        }
        this.buildParamHash();
    }

    private void buildParamHash() {
        this.paramHash = new Hashtable();
        Boolean _managerMode = new Boolean(!this.modal);
        this.paramHash.put("FormLauncher", this.formLauncher);
        this.paramHash.put("_commandHandlers", this.commandHandlers);
        this.paramHash.put("_columnNames", this.columnNames);
        this.paramHash.put("_attribNames", this.attribNames);
        this.paramHash.put("_entityType", this.entityName);
        this.paramHash.put("_filterData", this.filters);
        this.paramHash.put("_filterPanelData", this.filterPanels);
        this.paramHash.put("_managerMode", _managerMode);
        this.paramHash.put("_managerDefProp", this.managerDef);
        this.paramHash.put("_title", this.title);
        if (this.panelName == null || this.panelName.trim().length() == 0) {
            this.panelName = DEFAULT_PANEL_NAME;
        }
        if (this.selectionReqForm != null) {
            this.paramHash.put("_callback", this.selectionReqForm);
        }
        if (!this.modal && (this.managerDef.getProperties() & 1L) == 0L) {
            this.paramHash.put("id", this.entityName + ":MGR");
        } else {
            this.paramHash.put("id", this.entityName + ":" + System.currentTimeMillis());
        }
    }

    public Object getProperty(String pPropName) {
        return this.paramHash.get(pPropName);
    }

    public void putProperty(String pPropName, Object pPropValue) {
        this.paramHash.put(pPropName, pPropValue);
    }

    public void putUserProperty(String pPropName, Object pPropValue) {
        this.userProps.put(pPropName, pPropValue);
    }

    public IRCEntityManager getManager() {
        if (this.form == null) {
            this.paramHash.putAll(this.userProps);
            try {
                this.form = this.formLauncher.addPanel(this.panelName, this.paramHash);
            }
            catch (Exception _e) {
                _e.printStackTrace();
            }
        }
        return (IRCEntityManager)this.form;
    }

    public void run() throws Exception {
        this.getManager();
        this.formLauncher.showPanel(this.form, this.modal);
    }

    private void fetchFormData(String pManagerName, String pFilterName, boolean pManagerMode) {
        boolean _hasDefaultFilter;
        try {
            RCDropInCustodian _dropIns = RCDropInCustodian.getInstance();
            this.managerDef = _dropIns.getManagerDef(pManagerName, pManagerMode);
            Vector _handlers = _dropIns.getHandlersForManager(pManagerName);
            this.filterPanels = _dropIns.getFilterPanelsForManager(pManagerName);
            if (this.filters == null) {
                this.filters = _dropIns.getSelectedFiltersForManager(pManagerName, pFilterName);
            }
            if (_handlers != null) {
                this.commandHandlers = new OWSet(Serializable.class, _handlers);
            }
        }
        catch (Exception _e) {
            _e.printStackTrace();
        }
        if (this.managerDef == null) {
            System.out.println("\n\n*****************");
            System.out.println("RCGenericManagerConfig.fetchFormData() - COULD NOT FIND RCManagerDef RECORD!");
            System.out.println(" ManagerName    : " + pManagerName);
            System.out.println(" ManagerMode    : " + pManagerMode);
            System.out.println("*****************\n\n");
        }
        if (pFilterName != null && pFilterName.trim().length() > 0 && this.managerDef != null) {
            try {
                this.managerDef.setDefaultFilterName(pFilterName);
            }
            catch (Exception _e) {
                _e.printStackTrace();
            }
        }
        Enumeration _attribNameList = this.managerDef.getAttribNames().elements();
        Enumeration _columnTitleList = this.managerDef.getColumnTitles().elements();
        this.attribNames = new Vector();
        while (_attribNameList.hasMoreElements()) {
            String _attribName = (String)_attribNameList.nextElement();
            this.attribNames.add(_attribName);
        }
        this.columnNames = new Vector();
        while (_columnTitleList.hasMoreElements()) {
            String _columnTitle = (String)_columnTitleList.nextElement();
            this.columnNames.add(_columnTitle);
        }
        this.title = this.managerDef.getTitle();
        this.panelName = this.managerDef.getFormName();
        if (this.filterPanels == null || this.filterPanels.size() == 0) {
            System.out.println("\n\n*****************");
            System.out.println("RCGenericManagerConfig.fetchFormData() - NO FILTER PANELS RETURNED!");
            System.out.println(" ManagerName    : " + pManagerName);
            System.out.println(" ManagerMode    : " + pManagerMode);
            System.out.println("*****************\n\n");
        }
        boolean bl = _hasDefaultFilter = this.managerDef != null && this.managerDef.getDefaultFilterName() != null && this.managerDef.getDefaultFilterName().trim().length() > 0;
        if ((this.filters == null || this.filters.size() == 0) && _hasDefaultFilter) {
            System.out.println("\n\n*****************");
            System.out.println("RCGenericManagerConfig.fetchFormData() - NO FILTERS RETURNED!");
            System.out.println(" ManagerName    : " + pManagerName);
            System.out.println(" ManagerMode    : " + pManagerMode);
            System.out.println(" Default Filter : " + this.managerDef.getDefaultFilterName());
            System.out.println("*****************\n\n");
        }
    }
}

