/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation.tftpupload;

import com.dorado.core.ejb.ruleengine.OWRuleEngineClient;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.IOWEventListener;
import com.dorado.runtime.OWEvent;
import com.ngnms.mediation.AvMediationServerUtil;
import com.ngnms.mediation.filetransfer.AvFileTransferUtil;
import com.ngnms.mediation.tftpupload.AvTFTPUploadBatchRequest;
import com.ngnms.mediation.tftpupload.AvTFTPUploadBatchResponse;
import com.ngnms.mediation.tftpupload.AvTFTPUploadMediationRequest;
import com.ngnms.mediation.tftpupload.IAvTFTPUploadResponseHandler;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class AvTFTPUploadRequestor
implements IOWEventListener {
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.mediation.tftpupload.debug");
    private static AvTFTPUploadRequestor singleton = null;
    private static final String REQUESTOR_RULE = "com.ngnms.mediation.tftpupload.AvTFTPUploadBatchRequestorRule";
    private Hashtable handlersBySession = new Hashtable();
    private Hashtable sessionsByMediationAgent = new Hashtable();
    private Hashtable mediationLastResponseTime = new Hashtable();
    AvTFTPUploadBatchResponse listener;

    private AvTFTPUploadRequestor() {
        try {
            this.listener = new AvTFTPUploadBatchResponse();
            this.listener.addEventListener((IOWEventListener)this);
        }
        catch (Exception e) {
            System.out.println("AvTFTPUploadRequestor: PANIC!!!!!");
            e.printStackTrace();
        }
    }

    public static AvTFTPUploadRequestor getInstance() {
        if (singleton == null) {
            singleton = new AvTFTPUploadRequestor();
        }
        return singleton;
    }

    public void newRequest(String pSessionID, Vector pRequests, IAvTFTPUploadResponseHandler pHandler) {
        if (debugOn) {
            System.out.println("TFTPUploadRequestor.newRequest: " + pSessionID + " with " + pRequests.size() + " requests");
        }
        if (pHandler != null) {
            this.handlersBySession.put(pSessionID, pHandler);
        }
        Hashtable<String, Vector<AvTFTPUploadMediationRequest>> requestsByMediation = new Hashtable<String, Vector<AvTFTPUploadMediationRequest>>();
        for (AvTFTPUploadMediationRequest request : pRequests) {
            String mediationAgent = AvMediationServerUtil.getMedPartitionForIPAddress(request.getRemoteHost());
            Vector<AvTFTPUploadMediationRequest> requestsByMed = (Vector<AvTFTPUploadMediationRequest>)requestsByMediation.get(mediationAgent);
            if (requestsByMed == null) {
                requestsByMed = new Vector<AvTFTPUploadMediationRequest>();
                requestsByMediation.put(mediationAgent, requestsByMed);
            }
            requestsByMed.add(request);
        }
        for (String mediationAgent : requestsByMediation.keySet()) {
            Vector requests = (Vector)requestsByMediation.get(mediationAgent);
            AvTFTPUploadBatchRequest paramSet = new AvTFTPUploadBatchRequest();
            paramSet.setSessionID(pSessionID);
            paramSet.setAction("AvTFTPUpload.ADD_SESSION");
            paramSet.setData((Serializable)requests);
            paramSet.set_OW_RuleName(REQUESTOR_RULE);
            try {
                OWRuleEngineClient medRE = AvMediationServerUtil.getMedServerRuleEngine(mediationAgent);
                medRE.callRule((IOWEvent)paramSet);
                HashSet<String> sessionsOnMediation = (HashSet<String>)this.sessionsByMediationAgent.get(mediationAgent);
                if (sessionsOnMediation == null) {
                    sessionsOnMediation = new HashSet<String>();
                    this.sessionsByMediationAgent.put(mediationAgent, sessionsOnMediation);
                }
                sessionsOnMediation.add(pSessionID);
            }
            catch (Exception e) {
                this.batchUpdateStatus(pSessionID, requests, "AvTFTPUpload.ERROR_MEDIATION_ERROR");
                if (!debugOn) continue;
                System.out.println("TFTPUploadRequestor:");
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean isSessionRunning(String pSessionID) {
        for (HashSet sessions : this.sessionsByMediationAgent.values()) {
            if (!sessions.contains(pSessionID)) continue;
            return true;
        }
        return false;
    }

    private synchronized Vector getMediationAgentsForSession(String pSessionID) {
        Vector<String> ret = new Vector<String>();
        for (String mediationAgent : this.sessionsByMediationAgent.keySet()) {
            HashSet sessions = (HashSet)this.sessionsByMediationAgent.get(mediationAgent);
            if (!sessions.contains(pSessionID)) continue;
            ret.add(mediationAgent);
        }
        return ret;
    }

    private void emitControlEventToSessionMediationAgents(String pSessionID, String pControlEvent) {
        Vector mediationAgents = this.getMediationAgentsForSession(pSessionID);
        for (String mediationAgent : mediationAgents) {
            AvTFTPUploadBatchRequest paramSet = new AvTFTPUploadBatchRequest();
            paramSet.setSessionID(pSessionID);
            paramSet.setAction(pControlEvent);
            paramSet.setData(null);
            paramSet.set_OW_RuleName(REQUESTOR_RULE);
            try {
                OWRuleEngineClient medRE = AvMediationServerUtil.getMedServerRuleEngine(mediationAgent);
                medRE.callRule((IOWEvent)paramSet);
            }
            catch (Exception e) {
                if (!debugOn) continue;
                System.out.println("TFTPUploadRequestor:");
                e.printStackTrace();
            }
        }
    }

    public synchronized void pauseSession(String pSessionID) {
        this.emitControlEventToSessionMediationAgents(pSessionID, "AvTFTPUpload.PAUSE_SESSION");
    }

    public synchronized void resumeSession(String pSessionID) {
        this.emitControlEventToSessionMediationAgents(pSessionID, "AvTFTPUpload.RESUME_SESSION");
    }

    public synchronized void cancelSession(String pSessionID) {
        this.emitControlEventToSessionMediationAgents(pSessionID, "AvTFTPUpload.CANCEL_SESSION");
    }

    private void batchUpdateStatus(String pSessionID, Vector pRequests, String pStatusString) {
        IAvTFTPUploadResponseHandler handler = (IAvTFTPUploadResponseHandler)this.handlersBySession.get(pSessionID);
        if (handler != null) {
            for (AvTFTPUploadMediationRequest request : pRequests) {
                handler.tftpUploadStatus(pSessionID, request.getRemoteHost(), request.getRemoteFileName(), request.getClientData(), pStatusString, null, null);
            }
        }
    }

    private void sessionFinished(String pSessionID, String pMediationAgent) {
        HashSet sessionsOnMediation;
        if (debugOn) {
            System.out.println("TFTPUploadRequestor: " + pSessionID + " finished on \"" + pMediationAgent + "\"");
        }
        if ((sessionsOnMediation = (HashSet)this.sessionsByMediationAgent.get(pMediationAgent)) != null) {
            sessionsOnMediation.remove(pSessionID);
        }
        if (this.getMediationAgentsForSession(pSessionID).size() == 0) {
            if (debugOn) {
                System.out.println("TFTPUploadRequestor: Finished on all mediations.");
            }
            this.handlersBySession.remove(pSessionID);
        }
    }

    private synchronized void updateStatus(String pMediationAgent, String pSessionID, String pRemoteHost, String pRemoteFileName, Object pClientData, String pStatusString, String pDetailString, Object pDetailData) {
        if (pRemoteHost == null) {
            if ("AvTFTPUpload.RESPONSE_SESSION_ENDED".equals(pStatusString)) {
                this.sessionFinished(pMediationAgent, pSessionID);
            }
        } else {
            IAvTFTPUploadResponseHandler handler = (IAvTFTPUploadResponseHandler)this.handlersBySession.get(pSessionID);
            if (handler != null) {
                handler.tftpUploadStatus(pSessionID, pRemoteHost, pRemoteFileName, pClientData, pStatusString, pDetailString, pDetailData);
            }
        }
    }

    public static String getTFTPUploadRoot() {
        return AvFileTransferUtil.FILETRANSFER_ROOT;
    }

    public void action(OWEvent pEvent) {
        AvTFTPUploadBatchResponse event = (AvTFTPUploadBatchResponse)pEvent;
        this.updateStatus(event.getMediationAgentPartition(), event.getSessionID(), event.getRemoteHost(), event.getRemoteFileName(), event.getClientData(), event.getStatusString(), event.getDetailString(), event.getDetailData());
    }

    public void disconnectOccurred(String str) {
    }

    public void exceptionOccurred(Exception exception) {
    }
}

