/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation.tftpupload;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

class AvTFTPUploadQueue {
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.mediation.tftpupload.debug");
    private Hashtable uploadsBySession = new Hashtable();
    private Hashtable handlersByJob = new Hashtable();
    private Vector runningSessions = new Vector();
    private Vector pausedSessions = new Vector();
    private int currentSessionIndex = 0;
    private String currentSession = null;
    private JobAcceptor jobAcceptor = null;

    AvTFTPUploadQueue() {
    }

    public synchronized void addSessionRequest(String sessionID, Vector requests) {
        LinkedList localRequests;
        if (debugOn) {
            System.out.println("AvMediationUploadManager: Adding " + requests.size() + " requests for session " + sessionID);
        }
        if ((localRequests = (LinkedList)this.uploadsBySession.get(sessionID)) == null) {
            localRequests = new LinkedList();
            this.uploadsBySession.put(sessionID, localRequests);
        }
        localRequests.addAll(requests);
        if (!this.runningSessions.contains(sessionID)) {
            this.runningSessions.add(sessionID);
        }
    }

    public synchronized String getCurrentSession() {
        return this.currentSession;
    }

    public synchronized Object getNextRequest() {
        Object ret = null;
        int seekSessionIndex = this.currentSessionIndex;
        Vector localSessions = (Vector)this.runningSessions.clone();
        while (ret == null) {
            String seekSession;
            LinkedList localRequests;
            if (seekSessionIndex >= localSessions.size()) {
                seekSessionIndex = 0;
                if (localSessions.size() == 0) {
                    if (debugOn) {
                        System.out.println("AvMediationUploadManager: No job to return.");
                    }
                    return null;
                }
            }
            if ((localRequests = (LinkedList)this.uploadsBySession.get(seekSession = (String)localSessions.elementAt(seekSessionIndex))) == null || localRequests.size() == 0) continue;
            if (debugOn) {
                System.out.println("AvMediationUploadManager: Found request for session " + this.currentSession);
            }
            Iterator i = localRequests.iterator();
            while (i.hasNext() && ret == null) {
                ret = i.next();
                if (this.jobAcceptor != null && !this.jobAcceptor.acceptJob(ret)) {
                    ret = null;
                    continue;
                }
                i.remove();
            }
            if (ret == null) {
                localSessions.remove(seekSessionIndex);
                continue;
            }
            this.currentSessionIndex = this.runningSessions.indexOf(seekSession) + 1;
            this.currentSession = seekSession;
            if (localRequests.size() != 0) continue;
            if (debugOn) {
                System.out.println("AvMediationUploadManager: Session " + this.currentSession + " complete. Removing.");
            }
            this.runningSessions.remove(seekSession);
            this.uploadsBySession.remove(seekSession);
        }
        return ret;
    }

    public synchronized boolean isSessionActive(String sessionID) {
        return this.runningSessions.contains(sessionID);
    }

    public synchronized void cancelSession(String sessionID) {
        if (debugOn) {
            System.out.println("AvMediationUploadManager: Canceling session " + sessionID);
        }
        this.pausedSessions.remove(sessionID);
        this.runningSessions.remove(sessionID);
        this.uploadsBySession.remove(sessionID);
    }

    public synchronized void pauseSession(String sessionID) {
        if (debugOn) {
            System.out.println("AvMediationUploadManager: Pausing session " + sessionID);
        }
        if (this.runningSessions.contains(sessionID)) {
            this.pausedSessions.add(sessionID);
            this.runningSessions.remove(sessionID);
        }
    }

    public synchronized void resumeSession(String sessionID) {
        if (debugOn) {
            System.out.println("AvMediationUploadManager: Resume session " + sessionID);
        }
        if (this.pausedSessions.contains(sessionID)) {
            this.pausedSessions.remove(sessionID);
            this.runningSessions.add(sessionID);
        }
    }

    public synchronized void setJobAcceptor(JobAcceptor pJobAcceptor) {
        this.jobAcceptor = pJobAcceptor;
    }

    public static interface JobAcceptor {
        public boolean acceptJob(Object var1);
    }
}

