/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation.tftpupload;

import com.dorado.common.utility.OWAppServerUtility;
import com.ngnms.common.AvTrace;
import com.ngnms.mediation.filetransfer.AvFileTransferUtil;
import com.ngnms.mediation.tftp.AvTftpClient;
import com.ngnms.mediation.tftp.AvTftpEndTransferEvent;
import com.ngnms.mediation.tftp.AvTftpErrorEvent;
import com.ngnms.mediation.tftp.AvTftpEventListener;
import com.ngnms.mediation.tftp.AvTftpStartTransferEvent;
import com.ngnms.mediation.tftp.AvTftpTransferEvent;
import com.ngnms.mediation.tftpupload.AvTFTPUploadBatchResponse;
import com.ngnms.mediation.tftpupload.AvTFTPUploadMediationRequest;
import com.ngnms.mediation.tftpupload.AvTFTPUploadQueue;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Vector;

public class AvTFTPUploadMediationManager
implements AvTFTPUploadQueue.JobAcceptor {
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.mediation.tftpupload.debug");
    private static int CONCURRENT_UPLOADS = Integer.getInteger("com.ngnms.mediation.tftpupload.concurrentUploads", 20);
    public static final String TFTP_ROOT_PROP_NAME = "com.ngnms.mediation.filetransfer.root";
    public static String DEFAULT_ROOT_DIR = System.getProperty("oware.user.root") + "/firmware";
    private AvTFTPUploadQueue queue = new AvTFTPUploadQueue();
    private Vector runningThreads = new Vector();
    private HashSet runningHosts = new HashSet();
    private static AvTFTPUploadMediationManager singleton = null;
    private String mediationAgentPartition = "";

    private AvTFTPUploadMediationManager() {
        if (OWAppServerUtility.isMediationServer()) {
            this.mediationAgentPartition = OWAppServerUtility.getPartitionName();
        }
        System.out.println("TFTP Upload Manager - Partition name is: \"" + this.mediationAgentPartition + "\"");
        this.queue.setJobAcceptor(this);
    }

    public static synchronized AvTFTPUploadMediationManager getInstance() {
        if (singleton == null) {
            singleton = new AvTFTPUploadMediationManager();
        }
        return singleton;
    }

    private synchronized void performNextUpload() {
        while (this.runningThreads.size() < CONCURRENT_UPLOADS) {
            AvTFTPUploadMediationRequest job = (AvTFTPUploadMediationRequest)this.queue.getNextRequest();
            if (job != null) {
                UploaderThread uploader = new UploaderThread(this.queue.getCurrentSession(), job);
                this.runningHosts.add(job.getRemoteHost());
                this.runningThreads.add(uploader);
                uploader.start();
                continue;
            }
            return;
        }
    }

    private synchronized void updateStatus(UploaderThread uploader, String status, String detailString, Serializable detailData, boolean finished) {
        AvTFTPUploadMediationRequest job = uploader.getJob();
        String sessionID = uploader.getSessionID();
        try {
            AvTFTPUploadBatchResponse event = new AvTFTPUploadBatchResponse();
            event.setMediationAgentPartition(this.mediationAgentPartition);
            event.setSessionID(sessionID);
            event.setRemoteHost(job.getRemoteHost());
            event.setRemoteFileName(job.getRemoteFileName());
            event.setClientData(job.getClientData());
            event.setStatusString(status);
            event.setDetailString(detailString);
            event.setDetailData(detailData);
            event.set_OW_PartitionName(OWAppServerUtility.getExternalPartitionName());
            event.emit();
            if (!"AvServices_RESPONSE_EXECUTING".equals(status) && !this.queue.isSessionActive(sessionID)) {
                event = new AvTFTPUploadBatchResponse();
                event.setMediationAgentPartition(this.mediationAgentPartition);
                event.setSessionID(sessionID);
                event.setRemoteHost(null);
                event.setRemoteFileName(null);
                event.setClientData(null);
                event.setStatusString("AvTFTPUpload.RESPONSE_SESSION_ENDED");
                event.setDetailString(null);
                event.setDetailData(null);
                event.set_OW_PartitionName(OWAppServerUtility.getExternalPartitionName());
                event.emit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (finished) {
            this.runningThreads.remove(uploader);
            this.runningHosts.remove(job.getRemoteHost());
            this.performNextUpload();
        }
    }

    public synchronized void addSession(String sessionID, Vector requests) {
        if (requests != null && requests.size() > 0) {
            this.queue.addSessionRequest(sessionID, requests);
        }
        this.performNextUpload();
    }

    public synchronized void pauseSession(String sessionID) {
        this.queue.pauseSession(sessionID);
    }

    public synchronized void resumeSession(String sessionID) {
        this.queue.resumeSession(sessionID);
        this.performNextUpload();
    }

    public synchronized void cancelSession(String sessionID) {
        this.queue.cancelSession(sessionID);
    }

    public boolean acceptJob(Object pJob) {
        AvTFTPUploadMediationRequest request = (AvTFTPUploadMediationRequest)pJob;
        if (this.runningHosts.contains(request.getRemoteHost())) {
            AvTrace.traceln("SWUpgrade", 3, "Rejected request. Host is running: " + request.getRemoteHost());
            return false;
        }
        return true;
    }

    private class UploaderThread
    extends Thread
    implements AvTftpEventListener {
        private AvTftpClient tftp = null;
        private AvTFTPUploadMediationRequest job;
        private String statusString = "";
        private String sessionID = null;
        boolean done = false;
        int attempt = 0;

        public UploaderThread(String pSessionID, AvTFTPUploadMediationRequest pJob) {
            this.job = pJob;
            this.sessionID = pSessionID;
        }

        public AvTFTPUploadMediationRequest getJob() {
            return this.job;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.tftp = new AvTftpClient();
            String _fName = AvFileTransferUtil.checkLocalFile(this.job.getLocalFileName());
            if (null == _fName) {
                AvTFTPUploadMediationManager.this.updateStatus(this, "AvServices_RESPONSE_ERROR", "Could not get file from Server.", null, true);
                return;
            }
            this.tftp.setLockalFileName(_fName);
            this.tftp.setRemoteHost(this.job.getRemoteHost());
            this.tftp.setRemoteFileName(this.job.getRemoteFileName());
            this.tftp.setRetries(this.job.getRetries());
            this.tftp.setTimeOut(this.job.getTimeout());
            this.tftp.addTftpEventListener(this);
            this.statusString = "AvServices_RESPONSE_OK";
            long expires = this.job.getExpires();
            int attempts = this.job.getAttempts();
            this.attempt = 1;
            while (!this.done) {
                if (expires > 0L && System.currentTimeMillis() > expires) {
                    AvTFTPUploadMediationManager.this.updateStatus(this, "AvServices_RESPONSE_ERROR", "Tried to upload after session limit time.", null, true);
                    return;
                }
                if (this.attempt > attempts) {
                    AvTFTPUploadMediationManager.this.updateStatus(this, "AvServices_RESPONSE_ERROR", "Maximum number of attempts exceeded", new Integer(attempts), true);
                    return;
                }
                AvTFTPUploadMediationManager.this.updateStatus(this, "AvServices_RESPONSE_EXECUTING", null, new Integer(this.attempt), false);
                try {
                    this.tftp.putFile();
                }
                catch (Exception e) {
                    ++this.attempt;
                }
                finally {
                    try {
                        UploaderThread.sleep(this.job.getDelay());
                    }
                    catch (InterruptedException e) {}
                }
            }
            AvTFTPUploadMediationManager.this.updateStatus(this, this.statusString, null, null, true);
        }

        public void endTransfer(AvTftpEndTransferEvent endEvent) {
            AvTrace.traceln("SWUpgrade", 1, "TFTP Session Finished. Retransmitions: " + endEvent.getRetransmitions());
            this.statusString = "AvServices_RESPONSE_OK";
            this.done = true;
        }

        public void error(AvTftpErrorEvent errorEvent) {
            this.statusString = errorEvent.getErrorString();
            AvTrace.traceln("SWUpgrade", 1, "TFTP Session Failed (On Attempt " + this.attempt + " of " + this.job.getRetries() + "): " + this.statusString);
            ++this.attempt;
        }

        public void startTransfer(AvTftpStartTransferEvent startEvent) {
            AvTrace.traceln("SWUpgrade", 1, "TFTP Session Started: File Size is " + startEvent.getFileSize());
        }

        public void transfer(AvTftpTransferEvent transferEvent) {
            int packetNumber = transferEvent.getPacketNumber();
            if (debugOn && packetNumber % 40 == 0) {
                System.out.println("In transfer: " + this.tftp.getRemoteHost() + " " + transferEvent.getBytesTransferred() + ", Packet Number: " + packetNumber);
            }
        }
    }
}

