/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation.tftpserver;

import com.dorado.core.ejb.ruleengine.OWRuleEngineClient;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.IOWEventListener;
import com.dorado.runtime.OWEvent;
import com.ngnms.mediation.AvMediationServerUtil;
import com.ngnms.mediation.filetransfer.AvFileTransferUtil;
import com.ngnms.mediation.tftpserver.AvTFTPServerBatchRequest;
import com.ngnms.mediation.tftpserver.AvTFTPServerBatchResponse;
import com.ngnms.mediation.tftpserver.AvTFTPServerMediationRequest;
import com.ngnms.mediation.tftpserver.IAvTFTPServerResponseHandler;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class AvTFTPServerRequestor
implements IOWEventListener {
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.mediation.tftpserver.debug");
    private static AvTFTPServerRequestor singleton = null;
    private static final String REQUESTOR_RULE = "com.ngnms.mediation.tftpserver.AvTFTPServerBatchRequestorRule";
    private Hashtable handlersBySession = new Hashtable();
    private Hashtable sessionsByMediationAgent = new Hashtable();
    private Hashtable mediationLastResponseTime = new Hashtable();
    AvTFTPServerBatchResponse listener;

    private AvTFTPServerRequestor() {
        try {
            this.listener = new AvTFTPServerBatchResponse();
            this.listener.addEventListener((IOWEventListener)this);
        }
        catch (Exception e) {
            System.out.println("AvTFTPServerRequestor: PANIC!!!!!");
            e.printStackTrace();
        }
    }

    public static AvTFTPServerRequestor getInstance() {
        if (singleton == null) {
            singleton = new AvTFTPServerRequestor();
        }
        return singleton;
    }

    public void newRequest(String pSessionID, Vector pRequests, IAvTFTPServerResponseHandler pHandler) {
        if (debugOn) {
            System.out.println("TFTPServerRequestor.newRequest: " + pSessionID + " with " + pRequests.size() + " requests");
        }
        if (pHandler != null) {
            this.handlersBySession.put(pSessionID, pHandler);
        }
        Hashtable<String, Vector<AvTFTPServerMediationRequest>> requestsByMediation = new Hashtable<String, Vector<AvTFTPServerMediationRequest>>();
        for (AvTFTPServerMediationRequest request : pRequests) {
            String mediationAgent = AvMediationServerUtil.getMedPartitionForIPAddress(request.getRemoteHost());
            Vector<AvTFTPServerMediationRequest> requestsByMed = (Vector<AvTFTPServerMediationRequest>)requestsByMediation.get(mediationAgent);
            if (requestsByMed == null) {
                requestsByMed = new Vector<AvTFTPServerMediationRequest>();
                requestsByMediation.put(mediationAgent, requestsByMed);
            }
            requestsByMed.add(request);
        }
        for (String mediationAgent : requestsByMediation.keySet()) {
            Vector requests = (Vector)requestsByMediation.get(mediationAgent);
            AvTFTPServerBatchRequest paramSet = new AvTFTPServerBatchRequest();
            paramSet.setSessionID(pSessionID);
            paramSet.setAction("AvTFTPServer.ADD_SESSION");
            paramSet.setData((Serializable)requests);
            paramSet.set_OW_RuleName(REQUESTOR_RULE);
            try {
                OWRuleEngineClient medRE = AvMediationServerUtil.getMedServerRuleEngine(mediationAgent);
                medRE.callRule((IOWEvent)paramSet);
                HashSet<String> sessionsOnMediation = (HashSet<String>)this.sessionsByMediationAgent.get(mediationAgent);
                if (sessionsOnMediation == null) {
                    sessionsOnMediation = new HashSet<String>();
                    this.sessionsByMediationAgent.put(mediationAgent, sessionsOnMediation);
                }
                sessionsOnMediation.add(pSessionID);
            }
            catch (Exception e) {
                this.batchUpdateStatus(pSessionID, requests, "AvTFTPServer.ERROR_MEDIATION_ERROR");
                if (!debugOn) continue;
                System.out.println("TFTPServerRequestor:");
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean isSessionRunning(String pSessionID) {
        for (HashSet sessions : this.sessionsByMediationAgent.values()) {
            if (!sessions.contains(pSessionID)) continue;
            return true;
        }
        return false;
    }

    private synchronized Vector getMediationAgentsForSession(String pSessionID) {
        Vector<String> ret = new Vector<String>();
        for (String mediationAgent : this.sessionsByMediationAgent.keySet()) {
            HashSet sessions = (HashSet)this.sessionsByMediationAgent.get(mediationAgent);
            if (!sessions.contains(pSessionID)) continue;
            ret.add(mediationAgent);
        }
        return ret;
    }

    private void emitControlEventToSessionMediationAgents(String pSessionID, String pControlEvent) {
        Vector mediationAgents = this.getMediationAgentsForSession(pSessionID);
        for (String mediationAgent : mediationAgents) {
            AvTFTPServerBatchRequest paramSet = new AvTFTPServerBatchRequest();
            paramSet.setSessionID(pSessionID);
            paramSet.setAction(pControlEvent);
            paramSet.setData(null);
            paramSet.set_OW_RuleName(REQUESTOR_RULE);
            try {
                OWRuleEngineClient medRE = AvMediationServerUtil.getMedServerRuleEngine(mediationAgent);
                medRE.callRule((IOWEvent)paramSet);
            }
            catch (Exception e) {
                if (!debugOn) continue;
                System.out.println("TFTPServerRequestor:");
                e.printStackTrace();
            }
        }
    }

    public synchronized void resumeSession(String pSessionID) {
        this.emitControlEventToSessionMediationAgents(pSessionID, "AvTFTPServer.RESUME_SESSION");
    }

    public synchronized void cancelSession(String pSessionID) {
        this.emitControlEventToSessionMediationAgents(pSessionID, "AvTFTPServer.CANCEL_SESSION");
    }

    private void batchUpdateStatus(String pSessionID, Vector pRequests, String pStatusString) {
        IAvTFTPServerResponseHandler handler = (IAvTFTPServerResponseHandler)this.handlersBySession.get(pSessionID);
        if (handler != null) {
            for (AvTFTPServerMediationRequest request : pRequests) {
                handler.tftpServerStatus(pSessionID, request.getRemoteHost(), request.getRemoteFileName(), request.getClientData(), pStatusString, null, null);
            }
        }
    }

    private synchronized void updateStatus(String pMediationAgent, String pSessionID, String pRemoteHost, String pRemoteFileName, Object pClientData, String pStatusString, String pDetailString, Object pDetailData) {
        IAvTFTPServerResponseHandler handler = (IAvTFTPServerResponseHandler)this.handlersBySession.get(pSessionID);
        if (handler != null) {
            handler.tftpServerStatus(pSessionID, pRemoteHost, pRemoteFileName, pClientData, pStatusString, pDetailString, pDetailData);
        }
    }

    public static String getTFTPServerRoot() {
        return AvFileTransferUtil.FILETRANSFER_ROOT;
    }

    public void action(OWEvent pEvent) {
        AvTFTPServerBatchResponse event = (AvTFTPServerBatchResponse)pEvent;
        this.updateStatus(event.getMediationAgentPartition(), event.getSessionID(), event.getRemoteHost(), event.getRemoteFileName(), event.getClientData(), event.getStatusString(), event.getDetailString(), event.getDetailData());
    }

    public void disconnectOccurred(String str) {
    }

    public void exceptionOccurred(Exception exception) {
    }
}

