/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation.tftpserver;

import com.dorado.common.utility.OWAppServerUtility;
import com.ngnms.mediation.filetransfer.AvFileTransferUtil;
import com.ngnms.mediation.tftp.AvTftpEndTransferEvent;
import com.ngnms.mediation.tftp.AvTftpErrorEvent;
import com.ngnms.mediation.tftp.AvTftpEventListener;
import com.ngnms.mediation.tftp.AvTftpServer;
import com.ngnms.mediation.tftp.AvTftpStartTransferEvent;
import com.ngnms.mediation.tftp.AvTftpTransferEvent;
import com.ngnms.mediation.tftpserver.AvTFTPServerBatchResponse;
import com.ngnms.mediation.tftpserver.AvTFTPServerMediationRequest;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class AvTFTPServerMediationManager
implements AvTftpEventListener {
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.mediation.tftpserver.debug");
    public static final String TFTP_ROOT_PROP_NAME = "com.ngnms.mediation.filetransfer.root";
    public static String DEFAULT_ROOT_DIR = System.getProperty("oware.user.root") + "/firmware";
    private static AvTFTPServerMediationManager singleton = null;
    private static AvTftpServer tftpServer = null;
    private String mediationAgentPartition = "";
    private Hashtable sessions = new Hashtable();
    private Hashtable sessionsByRemoteHost = new Hashtable();

    private AvTFTPServerMediationManager() {
        if (OWAppServerUtility.isMediationServer()) {
            this.mediationAgentPartition = OWAppServerUtility.getPartitionName();
        }
        System.out.println("TFTP Download Manager - Partition name is: \"" + this.mediationAgentPartition + "\"");
        tftpServer = new AvTftpServer();
        tftpServer.start();
        tftpServer.addTftpEventListener(this);
    }

    public static synchronized AvTFTPServerMediationManager getInstance() {
        if (singleton == null) {
            singleton = new AvTFTPServerMediationManager();
        }
        return singleton;
    }

    private synchronized void updateStatus(String pRemoteHost, String pRemoteFileName, String pStatusString, String pDetailString, Serializable pDetailData, boolean finished) {
        String sessionID = (String)this.sessionsByRemoteHost.get(pRemoteHost);
        try {
            AvTFTPServerBatchResponse event = new AvTFTPServerBatchResponse();
            event.setMediationAgentPartition(this.mediationAgentPartition);
            event.setSessionID(sessionID);
            event.setRemoteHost(pRemoteHost);
            event.setRemoteFileName(pRemoteFileName);
            event.setClientData(null);
            event.setStatusString(pStatusString);
            event.setDetailString(pDetailString);
            event.setDetailData(pDetailData);
            event.set_OW_PartitionName(OWAppServerUtility.getExternalPartitionName());
            event.emit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void addSession(String sessionID, Vector requests) {
        if (requests != null && requests.size() > 0) {
            Vector sessionRequests = (Vector)this.sessions.get(sessionID);
            if (sessionRequests == null) {
                sessionRequests = new Vector();
                this.sessions.put(sessionID, sessionRequests);
            }
            sessionRequests.addAll(requests);
            for (AvTFTPServerMediationRequest request : requests) {
                this.sessionsByRemoteHost.put(request.getRemoteHost(), sessionID);
                String localFileName = AvFileTransferUtil.checkLocalFile(request.getLocalFileName());
                if (debugOn) {
                    System.out.println("TFTPSERVERMANAGER: Mapping file " + request.getRemoteFileName() + " to " + localFileName);
                }
                if (localFileName == null) continue;
                tftpServer.addFileMapping(request.getRemoteFileName(), localFileName);
            }
        }
    }

    public synchronized void cancelSession(String sessionID) {
        this.sessions.remove(sessionID);
        Iterator i = this.sessionsByRemoteHost.values().iterator();
        while (i.hasNext()) {
            if (!sessionID.equals(i.next())) continue;
            i.remove();
        }
    }

    public void endTransfer(AvTftpEndTransferEvent pEvent) {
        if (debugOn) {
            System.out.println("TFTPSERVERMANAGER: End transfer: " + pEvent.getHost() + " " + pEvent.getRequestFile());
        }
        this.updateStatus(pEvent.getHost().getHostAddress(), pEvent.getRequestFile(), "AvTFTPServer.OK", null, null, true);
    }

    public void error(AvTftpErrorEvent pEvent) {
        if (debugOn) {
            System.out.println("TFTPSERVERMANAGER: Error in transfer: " + pEvent.getHost() + " " + pEvent.getRequestFile());
        }
        this.updateStatus(pEvent.getHost().getHostAddress(), pEvent.getRequestFile(), "AvTFTPServer.ERROR", pEvent.getErrorString(), null, true);
    }

    public void transfer(AvTftpTransferEvent pEvent) {
        int packetNumber = pEvent.getPacketNumber();
        if (debugOn && packetNumber % 40 == 0) {
            System.out.println("TFTPSERVERMANAGER: In transfer: " + pEvent.getHost() + " " + pEvent.getBytesTransferred() + ", Packet Number: " + packetNumber);
        }
    }

    public void startTransfer(AvTftpStartTransferEvent pEvent) {
        if (debugOn) {
            System.out.println("TFTPSERVERMANAGER: Start transfer: " + pEvent.getHost() + " " + pEvent.getRequestFile());
        }
        this.updateStatus(pEvent.getHost().getHostAddress(), pEvent.getRequestFile(), "AvTFTPServer.RUNNING", null, null, true);
    }
}

