/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation.tftp;

import java.net.DatagramPacket;
import java.net.InetAddress;

public class AvUdpData {
    private byte[] data;

    public AvUdpData(byte[] newData) {
        this.data = new byte[newData.length];
        this.setData(newData);
    }

    public AvUdpData(int len) {
        this.data = new byte[len];
    }

    public AvUdpData(DatagramPacket pack) {
        this.data = pack.getData();
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] newData) {
        System.arraycopy(newData, 0, this.data, 0, this.data.length);
    }

    public void putData(byte[] pData, int srcOffset, int destOffset, int len) {
        System.arraycopy(pData, srcOffset, this.data, destOffset, len);
    }

    public void putData(byte[] pData, int srcOffset, int destOffset) {
        this.putData(pData, srcOffset, destOffset, pData.length);
    }

    public void putData(byte[] pData, int destOffset) {
        this.putData(pData, 0, destOffset, pData.length);
    }

    public int length() {
        return this.data.length;
    }

    public DatagramPacket mkPacket() {
        return new DatagramPacket(this.data, this.data.length);
    }

    public DatagramPacket mkPacket(int len) {
        return new DatagramPacket(this.data, len);
    }

    public DatagramPacket mkPacket(InetAddress dest, int port) {
        return new DatagramPacket(this.data, this.data.length, dest, port);
    }

    public DatagramPacket mkPacket(InetAddress dest, int port, int len) {
        return new DatagramPacket(this.data, len, dest, port);
    }

    public byte getByte(int offset) {
        return this.data[offset];
    }

    public void setByte(int offset, byte value) {
        this.data[offset] = value;
    }

    public int getInt(int offset) {
        byte lo = this.data[offset + 1];
        int signBit = lo & 0x80;
        lo = (byte)(lo & 0x7F);
        byte hiByte = this.data[offset];
        byte loByte = lo;
        return (hiByte << 8) + signBit + loByte;
    }

    public void putInt(int val, int offset) {
        int loByte = val % 256;
        int hiByte = val >>> 8;
        this.data[offset] = (byte)hiByte;
        this.data[offset + 1] = (byte)loByte;
    }

    public String getString(int offset) {
        StringBuffer strBuf = new StringBuffer();
        int curPos = offset;
        while (this.data[curPos] != 0) {
            strBuf.append((char)this.data[curPos]);
            ++curPos;
        }
        return new String(strBuf);
    }

    public void putString(String str, int offset) {
        byte[] bytes = str.getBytes();
        System.arraycopy(bytes, 0, this.data, offset, bytes.length);
        this.data[offset + str.length()] = 0;
    }
}

