/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation.tftp;

import com.ngnms.mediation.tftp.AvUdpData;
import java.net.DatagramPacket;
import java.net.InetAddress;

class AvTftpUtil {
    public static final int MAX_PACKET_SIZE = 512;
    public static final int MAX_DATA_SIZE = 512;
    public static final int TFTP_DEFAULT_PORT = 69;
    public static final String TFTP_netascii = "netascii";
    public static final String TFTP_octet = "octet";
    public static final short TFTP_RRQ = 1;
    public static final short TFTP_WRQ = 2;
    public static final short TFTP_DATA = 3;
    public static final short TFTP_ACK = 4;
    public static final short TFTP_ERROR = 5;
    public static final short TFTP_ERROR_NA = 0;
    public static final short TFTP_ERROR_FILE_NOT_FOUND = 1;
    public static final short TFTP_ERROR_ACCESS_VIOLATION = 2;
    public static final short TFTP_ERROR_DISK_OR_SERVER_FULL = 3;
    public static final short TFTP_ERROR_ILLEGAL_OPERATION = 4;
    public static final short TFTP_ERROR_UNKNOWN_TRANSFER_ID = 5;
    public static final short TFTP_ERROR_FILE_EXISTS = 6;
    public static final short TFTP_ERROR_NO_SUCH_USER = 7;
    public static final String[] TFTP_ERRORS = new String[]{"Not defined, see error message (if any).", "File not found.", "Access violation.", "Disk full or allocation exceeded.", "Illegal TFTP operation.", "Unknown transfer ID.", "File already exists.", "No such user.", "File not found."};
    public static final String[] TFTP_OPCODES = new String[]{"", "RRQ", "WRQ", "DATA", "ACK", "ERROR"};

    AvTftpUtil() {
    }

    static DatagramPacket buildRequestPacket(short opcode, String filename, String mode, InetAddress server, int remotePort) {
        AvUdpData reqData = new AvUdpData(2 + filename.length() + 1 + 5 + 1);
        reqData.putInt(opcode, 0);
        reqData.putString(filename, 2);
        reqData.putString(mode, 2 + filename.length() + 1);
        return reqData.mkPacket(server, remotePort);
    }

    static DatagramPacket buildReceivePacket() {
        AvUdpData recvData = new AvUdpData(516);
        return recvData.mkPacket();
    }

    static DatagramPacket buildAckPacket(int port, InetAddress host, int blockNum) {
        AvUdpData ackData = new AvUdpData(4);
        ackData.putInt(0, 4);
        ackData.putInt(2, blockNum);
        DatagramPacket ret = ackData.mkPacket();
        ret.setPort(port);
        ret.setAddress(host);
        ret.setLength(4);
        return ret;
    }

    static DatagramPacket buildDataPacket(int port, InetAddress host, int blockNum, byte[] data) {
        return AvTftpUtil.buildDataPacket(port, host, blockNum, data, 0, data.length);
    }

    static DatagramPacket buildDataPacket(int port, InetAddress host, int blockNum, byte[] data, int offset, int len) {
        AvUdpData dataObj = new AvUdpData(len + 4);
        dataObj.putInt(3, 0);
        dataObj.putInt(blockNum, 2);
        dataObj.putData(data, offset, 4, len);
        DatagramPacket dataPacket = dataObj.mkPacket();
        dataPacket.setPort(port);
        dataPacket.setAddress(host);
        dataPacket.setLength(len + 4);
        return dataPacket;
    }

    static DatagramPacket buildErrorPacket(int port, InetAddress host, int errorCode, String errorMsg) {
        AvUdpData errorObj = new AvUdpData(4 + errorMsg.length() + 1);
        errorObj.putInt(5, 0);
        errorObj.putInt(errorCode, 2);
        errorObj.putString(errorMsg, 4);
        DatagramPacket errPacket = errorObj.mkPacket();
        errPacket.setPort(port);
        errPacket.setAddress(host);
        errPacket.setLength(4 + errorMsg.length() + 1);
        return errPacket;
    }
}

