/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation.tftp;

import com.ngnms.mediation.tftp.AvTftpEndTransferEvent;
import com.ngnms.mediation.tftp.AvTftpErrorEvent;
import com.ngnms.mediation.tftp.AvTftpEventListener;
import com.ngnms.mediation.tftp.AvTftpStartTransferEvent;
import com.ngnms.mediation.tftp.AvTftpTransferEvent;
import com.ngnms.mediation.tftp.AvTftpUtil;
import com.ngnms.mediation.tftp.AvUdpData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class AvTftpServer
extends Thread {
    public static String TFTP_SERVER_OK = "TFTP_SERVER_OK";
    public static String TFTP_SERVER_ERROR = "TFTP_SERVER_ERROR";
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.mediation.tftp.AvTftpServer.debug");
    private Vector listeners = null;
    private Hashtable runningSessions = new Hashtable();
    private int localPort = 69;
    private InetAddress localAddress = null;
    private boolean stop = false;
    private int maxSessionCount = 100;
    private int timeout = 30000;
    private int retries = 3;
    private DatagramSocket listener;
    private Properties fileMappings = new Properties();
    private String serverStatus = TFTP_SERVER_OK;

    public String getServerStatus() {
        return this.serverStatus;
    }

    public void setRetries(int pRetries) {
        this.retries = pRetries;
    }

    public void setTimeout(int pTimeout) {
        this.timeout = pTimeout;
    }

    public void setLocalPort(int pLocalPort) {
        this.localPort = pLocalPort;
    }

    public void setLocalAddress(InetAddress pLocalAddress) {
        this.localAddress = pLocalAddress;
    }

    public void run() {
        try {
            this.listener = this.localAddress == null ? new DatagramSocket(this.localPort) : new DatagramSocket(this.localPort, this.localAddress);
        }
        catch (Exception e) {
            this.serverStatus = TFTP_SERVER_ERROR;
            System.out.println("TFTPServer: PANIC! ");
            System.out.println("Could not initialize: ");
            e.printStackTrace();
            return;
        }
        block7: while (!this.stop) {
            try {
                DatagramPacket recv = AvTftpUtil.buildReceivePacket();
                this.listener.receive(recv);
                AvUdpData data = new AvUdpData(recv);
                int opcode = data.getInt(0);
                String sessionKey = recv.getAddress().getHostAddress() + ":" + recv.getPort();
                switch (opcode) {
                    case 1: {
                        int port = recv.getPort();
                        InetAddress host = recv.getAddress();
                        String fileName = data.getString(2);
                        String mode = data.getString(2 + fileName.length() + 1);
                        this.initRRQ(sessionKey, host, port, fileName, mode);
                        continue block7;
                    }
                }
                if (!debugOn) continue;
                System.out.print("TFTPServer: ");
                if (opcode > 0 && opcode < AvTftpUtil.TFTP_OPCODES.length) {
                    System.out.println(AvTftpUtil.TFTP_OPCODES[opcode] + " unexpected from " + sessionKey);
                    continue;
                }
                System.out.println("Unknown opcode: " + opcode + " from " + sessionKey);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRRQ(String sessionKey, InetAddress host, int port, String requestFileName, String mode) throws IOException {
        if (!mode.equalsIgnoreCase("octet")) {
            DatagramPacket errPacket = AvTftpUtil.buildErrorPacket(port, host, 0, "Can only service octet transfers.");
            this.listener.send(errPacket);
        } else {
            Hashtable hashtable = this.runningSessions;
            synchronized (hashtable) {
                if (this.runningSessions.size() >= this.maxSessionCount) {
                    DatagramPacket errPacket = AvTftpUtil.buildErrorPacket(port, host, 3, "Maximum number of connections exceeded.");
                    this.listener.send(errPacket);
                } else {
                    if (debugOn) {
                        System.out.println("TFTPServer: Create session " + sessionKey);
                    }
                    try {
                        TftpServerSession session = new TftpServerSession(sessionKey, host, port, requestFileName);
                        this.runningSessions.put(sessionKey, session);
                        session.start();
                    }
                    catch (IOException e) {
                        DatagramPacket errPacket = AvTftpUtil.buildErrorPacket(port, host, 3, "Maximum number of connections exceeded.");
                        this.listener.send(errPacket);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(TftpServerSession session) {
        Hashtable hashtable = this.runningSessions;
        synchronized (hashtable) {
            this.runningSessions.remove(session.getSessionKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileMapping(String requestFile, String actualFile) {
        Properties properties = this.fileMappings;
        synchronized (properties) {
            this.fileMappings.setProperty(requestFile, actualFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileMappings(Properties mappings) {
        Properties properties = this.fileMappings;
        synchronized (properties) {
            for (String string : mappings.keySet()) {
                String actualFile = mappings.getProperty(string);
                this.fileMappings.setProperty(string, actualFile);
            }
        }
    }

    public void addTftpEventListener(AvTftpEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public void removeTftpEventListener(AvTftpEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners != null) {
            this.listeners.removeElement(listener);
        }
    }

    private class TftpServerSession
    extends Thread {
        private int port;
        private InetAddress host;
        private String sessionKey;
        private byte[] buff;
        private int buffRead = 0;
        private int packetNo = 1;
        private int retryCount = 0;
        private boolean transferFinished = false;
        private DatagramSocket listener = null;
        private InputStream in = null;
        private String fileName;
        private long fileSize;

        public TftpServerSession(String pSessionKey, InetAddress pHost, int pPort, String pFileName) throws IOException {
            this.sessionKey = pSessionKey;
            this.host = pHost;
            this.port = pPort;
            this.fileName = AvTftpServer.this.fileMappings.getProperty(pFileName, pFileName);
        }

        public String getSessionKey() {
            return this.sessionKey;
        }

        private AvUdpData listen() throws IOException {
            DatagramPacket recv = AvTftpUtil.buildReceivePacket();
            this.listener.receive(recv);
            AvUdpData data = new AvUdpData(recv);
            int opcode = data.getInt(0);
            if (opcode == 4) {
                return data;
            }
            if (debugOn) {
                System.out.print("TFTPServer: ");
                if (opcode > 0 && opcode < AvTftpUtil.TFTP_OPCODES.length) {
                    System.out.println(AvTftpUtil.TFTP_OPCODES[opcode] + " unexpected from " + this.sessionKey);
                } else {
                    System.out.println("Unknown opcode: " + opcode + " from " + this.sessionKey);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.listener = new DatagramSocket();
                this.listener.setSoTimeout(AvTftpServer.this.timeout);
                File actualFile = new File(this.fileName);
                this.fileSize = actualFile.length();
                FileInputStream in = new FileInputStream(actualFile);
                this.buff = new byte[512];
                this.fireStartTransfer(this.fileSize);
                this.buffRead = ((InputStream)in).read(this.buff);
                while (!this.transferFinished) {
                    this.sendCurrentData();
                    try {
                        AvUdpData ackPacket = this.listen();
                        if (ackPacket == null) {
                            throw new IOException();
                        }
                        int ackPacketNo = ackPacket.getInt(2);
                        if (ackPacketNo != this.packetNo && debugOn) {
                            System.out.println("TFTPServer: ACK Wrong packetNo " + ackPacketNo + " expected " + this.packetNo);
                        }
                        if (this.buffRead == 512) {
                            this.retryCount = 0;
                            ++this.packetNo;
                            this.buffRead = ((InputStream)in).read(this.buff);
                            continue;
                        }
                        this.transferFinished = true;
                    }
                    catch (IOException e) {
                        if (debugOn) {
                            System.out.println(e.getMessage());
                        }
                        ++this.retryCount;
                        if (debugOn) {
                            System.out.println("TFTPServer: DATA timeout " + this.sessionKey + " retry " + this.retryCount);
                        }
                        if (this.retryCount <= AvTftpServer.this.retries) continue;
                        this.fireError("Too many retransmissions");
                        this.transferFinished = true;
                    }
                }
                this.fireEndTransfer(0);
            }
            catch (IOException e) {
                if (debugOn) {
                    e.printStackTrace();
                }
                this.fireError(e.getMessage());
            }
            finally {
                if (this.listener != null) {
                    try {
                        this.listener.close();
                    }
                    catch (Exception e) {}
                }
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (Exception exception) {}
                }
                AvTftpServer.this.removeSession(this);
            }
        }

        private void sendCurrentData() throws IOException {
            DatagramPacket data = AvTftpUtil.buildDataPacket(this.port, this.host, this.packetNo, this.buff, 0, this.buffRead);
            this.listener.send(data);
        }

        void fireEndTransfer(int retransmitions) {
            if (AvTftpServer.this.listeners == null || AvTftpServer.this.listeners.isEmpty()) {
                return;
            }
            Enumeration e = AvTftpServer.this.listeners.elements();
            while (e.hasMoreElements()) {
                AvTftpEventListener listener = (AvTftpEventListener)e.nextElement();
                listener.endTransfer(new AvTftpEndTransferEvent(this, this.host, this.port, this.fileName, retransmitions));
            }
        }

        void fireError(String errorString) {
            if (AvTftpServer.this.listeners == null || AvTftpServer.this.listeners.isEmpty()) {
                return;
            }
            Enumeration e = AvTftpServer.this.listeners.elements();
            while (e.hasMoreElements()) {
                AvTftpEventListener listener = (AvTftpEventListener)e.nextElement();
                listener.error(new AvTftpErrorEvent(this, this.host, this.port, this.fileName, errorString));
            }
        }

        void fireStartTransfer(long fileSize) {
            if (AvTftpServer.this.listeners == null || AvTftpServer.this.listeners.isEmpty()) {
                return;
            }
            Enumeration e = AvTftpServer.this.listeners.elements();
            while (e.hasMoreElements()) {
                AvTftpEventListener listener = (AvTftpEventListener)e.nextElement();
                listener.startTransfer(new AvTftpStartTransferEvent(this, this.host, this.port, this.fileName, fileSize));
            }
        }

        void fireTransfer(long bytesTransferred, int packetNumber) {
            if (AvTftpServer.this.listeners == null || AvTftpServer.this.listeners.isEmpty()) {
                return;
            }
            Enumeration e = AvTftpServer.this.listeners.elements();
            while (e.hasMoreElements()) {
                AvTftpEventListener listener = (AvTftpEventListener)e.nextElement();
                listener.transfer(new AvTftpTransferEvent(this, this.host, this.port, this.fileName, bytesTransferred, packetNumber));
            }
        }
    }
}

