/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation.tftp;

import com.ngnms.mediation.tftp.AvTftpEndTransferEvent;
import com.ngnms.mediation.tftp.AvTftpErrorEvent;
import com.ngnms.mediation.tftp.AvTftpEventListener;
import com.ngnms.mediation.tftp.AvTftpStartTransferEvent;
import com.ngnms.mediation.tftp.AvTftpTransferEvent;
import com.ngnms.mediation.tftp.AvTftpUtil;
import com.ngnms.mediation.tftp.AvUdpData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class AvTftpClient {
    private InetAddress server;
    private String remoteHost;
    private String remoteFileName;
    private String localFileName;
    private String mode = "octet";
    private int remotePort = 69;
    private int retries = 3;
    private int timeOut = 3000;
    private Vector listeners = null;

    /*
     * Unable to fully structure code
     */
    public void putFile() throws Exception {
        url = new URL("file", "", this.localFileName);
        inFile = new File(url.getPath());
        if (!inFile.exists()) {
            throw new FileNotFoundException("Local file does not exist: " + this.localFileName);
        }
        fileSize = inFile.length();
        inFileStream = url.openStream();
        this.fireStartTransfer(fileSize);
        this.server = InetAddress.getByName(this.remoteHost);
        sock = new DatagramSocket();
        sock.setSoTimeout(this.timeOut);
        data = new byte[512];
        dataLength = 512;
        packetNum = 0;
        totalBytes = 0;
        retransmitions = 0;
        retryCount = 0;
        done = false;
        lastPacket = false;
        bSendPacket = true;
        ackPacket = AvTftpUtil.buildReceivePacket();
        sendPacket = AvTftpUtil.buildRequestPacket((short)2, this.remoteFileName, this.mode, this.server, this.remotePort);
        _sendTimeStamp = 0L;
        _prevPacketAcks = 0;
        block11: while (!done) {
            if (bSendPacket) {
                try {
                    sock.send(sendPacket);
                    _sendTimeStamp = System.currentTimeMillis();
                    if (this.timeOut == sock.getSoTimeout()) ** GOTO lbl36
                    sock.setSoTimeout(this.timeOut);
                }
                catch (Exception e) {
                    this.fireError("Error on Sending WRQ Packet: " + e);
                    return;
                }
            } else {
                bSendPacket = true;
            }
lbl36:
            // 3 sources

            try {
                sock.receive(ackPacket);
                retryCount = 0;
            }
            catch (InterruptedIOException ioe) {
                if (retryCount > this.retries) {
                    this.fireError("Error in recieve ACK: " + ioe.getMessage());
                    return;
                }
                ++retryCount;
                continue;
            }
            catch (IOException e) {
                this.fireError("Error in recieve ACK: " + e.getMessage());
                return;
            }
            totalBytes += dataLength;
            udpData = new AvUdpData(ackPacket);
            status = udpData.getByte(1);
            ackPacketNum = udpData.getInt(2);
            switch (status) {
                case 4: {
                    if (packetNum != ackPacketNum) {
                        _deltaTimeOut = this.timeOut - (int)(System.currentTimeMillis() - _sendTimeStamp);
                        if (_deltaTimeOut <= 0 || ++_prevPacketAcks > 2) continue block11;
                        sock.setSoTimeout(_deltaTimeOut);
                        bSendPacket = false;
                        continue block11;
                    }
                    _prevPacketAcks = 0;
                    this.fireTransfer(totalBytes, packetNum);
                    this.remotePort = ackPacket.getPort();
                    if (this.remotePort == 0) {
                        this.fireError("Failed to Set Remote Port.");
                        return;
                    }
                    ++packetNum;
                    break;
                }
                case 5: {
                    this.fireError("Error Packet Retrieved: " + this.getErrorString(udpData));
                    return;
                }
                default: {
                    this.fireError("Unknown Packet Recieved.");
                    return;
                }
            }
            if (lastPacket) {
                done = true;
                continue;
            }
            try {
                dataLength = inFileStream.read(data);
                retransmitions += retryCount;
                retryCount = 0;
            }
            catch (IOException e) {
                this.fireError("Failed to read DATA packet from file: " + e);
                return;
            }
            if (dataLength < 512) {
                lastPacket = true;
                if (dataLength < 0) {
                    dataLength = 0;
                }
            }
            sendPacket = AvTftpUtil.buildDataPacket(this.remotePort, this.server, packetNum, data, 0, dataLength);
        }
        this.closeConnections(inFileStream, sock);
        this.fireEndTransfer(retransmitions);
    }

    void closeConnections(InputStream fileToClose, DatagramSocket socketToClose) throws Exception {
        fileToClose.close();
        socketToClose.close();
    }

    String getErrorString(AvUdpData udpData) {
        String str = udpData.getString(4);
        if (str.length() != 0) {
            return "ErrorStr: " + str;
        }
        byte errorCode = udpData.getByte(3);
        if (errorCode >= 0 && errorCode < 8) {
            return AvTftpUtil.TFTP_ERRORS[errorCode];
        }
        return "File not found.";
    }

    public void addTftpEventListener(AvTftpEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public void removeTftpEventListener(AvTftpEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners != null) {
            this.listeners.removeElement(listener);
        }
    }

    void fireEndTransfer(int retransmitions) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            AvTftpEventListener listener = (AvTftpEventListener)e.nextElement();
            listener.endTransfer(new AvTftpEndTransferEvent(this, this.server, this.remotePort, this.remoteFileName, retransmitions));
        }
    }

    void fireError(String errorString) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            AvTftpEventListener listener = (AvTftpEventListener)e.nextElement();
            listener.error(new AvTftpErrorEvent(this, this.server, this.remotePort, this.remoteFileName, errorString));
        }
    }

    void fireStartTransfer(long fileSize) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            AvTftpEventListener listener = (AvTftpEventListener)e.nextElement();
            listener.startTransfer(new AvTftpStartTransferEvent(this, this.server, this.remotePort, this.remoteFileName, fileSize));
        }
    }

    void fireTransfer(long bytesTransferred, int packetNumber) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            AvTftpEventListener listener = (AvTftpEventListener)e.nextElement();
            listener.transfer(new AvTftpTransferEvent(this, this.server, this.remotePort, this.remoteFileName, bytesTransferred, packetNumber));
        }
    }

    public void setRemoteHost(String newRemoteHost) {
        this.remoteHost = newRemoteHost;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteFileName(String newRemoteFileName) {
        this.remoteFileName = newRemoteFileName;
    }

    public String getRemoteFileName() {
        return this.remoteFileName;
    }

    public void setLockalFileName(String newLocalFileName) {
        this.localFileName = newLocalFileName;
    }

    public String getLockalFileName() {
        return this.localFileName;
    }

    public void setMode(String newMode) throws Exception {
        if (!newMode.equals("netascii") && !newMode.equals("octet")) {
            throw new Exception("Unknown mode: " + newMode);
        }
        this.mode = newMode;
    }

    public String getMode() {
        return this.mode;
    }

    public void setRemotePort(int newRemotePort) {
        this.remotePort = newRemotePort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRetries(int newRetries) {
        this.retries = newRetries;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setTimeOut(int newTimeOut) {
        this.timeOut = newTimeOut * 1000;
    }

    public int getTimeOut() {
        return this.timeOut;
    }
}

