/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation.snmp;

import com.dorado.core.mediation.snmp.SRSnmpSession;
import com.ngnms.mediation.snmp.AvSnmpEquipment;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AvSnmpRequestor
extends Thread {
    private static Logger logger = Logger.getLogger(AvSnmpRequestor.class);
    private static int maxSessions = Integer.getInteger("com.ngnms.mediation.snmp.AvSnmpReaquestor.maxSessions", 32);
    private static int batchSize = Integer.getInteger("com.ngnms.mediation.snmp.AvSnmpRequestor.batchSize", 8);
    private static int maxWaitingDevices = Integer.getInteger("com.ngnms.mediation.snmp.AvSnmpRequestor.maxWaitingDevices", 0);
    private static boolean debugEverything = Boolean.getBoolean("com.ngnms.mediation.snmp.AvSnmpRequestor.debug");
    Vector listeners = new Vector();
    LinkedList waitingDevices;
    int totalResponses;
    int totalRequests;
    int totalTimeouts;
    int totalRetries;
    int totalLate;
    static AvSnmpRequestor singleton = new AvSnmpRequestor();
    private static Object waitingObj = new Object();

    public static AvSnmpRequestor getInstance() {
        return singleton;
    }

    private AvSnmpRequestor() {
        System.out.println("AvSnmpRequestor: maxSessions: " + maxSessions);
        System.out.println("AvSnmpRequestor: batchSize:   " + batchSize);
        this.waitingDevices = new LinkedList();
        this.setDaemon(true);
        this.start();
        new AvSnmpRequestTimer(this, 1000).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void newRequest(AvSnmpEquipment pDevice) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("newRequest: " + pDevice.ipAddress));
        }
        Object object = waitingObj;
        synchronized (object) {
            singleton.addRequest(pDevice, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(AvSnmpEquipment pDevice, boolean bCheckMax) {
        LinkedList linkedList = this.waitingDevices;
        synchronized (linkedList) {
            while (bCheckMax && this.waitingDevices.size() > maxWaitingDevices) {
                try {
                    this.waitingDevices.wait();
                }
                catch (InterruptedException ignored) {}
            }
            this.waitingDevices.add(pDevice);
            this.waitingDevices.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long t = 0L;
        while (true) {
            AvSnmpEquipment _agentAddr = null;
            Object object = this.waitingDevices;
            synchronized (object) {
                while (this.waitingDevices.isEmpty()) {
                    try {
                        if (logger.isDebugEnabled()) {
                            t = System.currentTimeMillis();
                            logger.debug((Object)("WAIT for requests - waitingDevices.size() is " + this.waitingDevices.size()));
                        }
                        this.waitingDevices.wait();
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("WAIT for requests - " + (System.currentTimeMillis() - t) + " millis."));
                    }
                    catch (InterruptedException _ie) {}
                }
                _agentAddr = (AvSnmpEquipment)this.waitingDevices.removeFirst();
                this.waitingDevices.notify();
            }
            object = this;
            synchronized (object) {
                AvSnmpListener listener = null;
                while (null == listener) {
                    int i = 0;
                    while (i < this.listeners.size()) {
                        AvSnmpListener _listener;
                        if ((_listener = (AvSnmpListener)this.listeners.get(i++)).getSize() >= batchSize) continue;
                        listener = _listener;
                        break;
                    }
                    if (null != listener) continue;
                    if (this.listeners.size() < maxSessions) {
                        listener = new AvSnmpListener(this);
                        this.listeners.add(listener);
                        listener.start();
                        break;
                    }
                    try {
                        if (logger.isDebugEnabled()) {
                            t = System.currentTimeMillis();
                            logger.debug((Object)("WAIT for sessions - listeners.size() - " + this.listeners.size()));
                        }
                        this.wait();
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("WAITED for sessions - " + (System.currentTimeMillis() - t) + " millis."));
                    }
                    catch (InterruptedException ignored) {}
                }
                SRSnmpSession _target = listener.getTarget();
                try {
                    _target.setTargetHost(_agentAddr.ipAddress);
                    _target.setTargetPort(_agentAddr.port);
                    _target.setCommunity(_agentAddr.community);
                    _target.prepareVarBinds(_agentAddr.requestType, _agentAddr.vbList);
                    _agentAddr.requestID = listener.nextRequestID();
                }
                catch (Throwable e) {
                    System.out.println("Exception in prepareVarBinds IP " + _agentAddr.ipAddress);
                    try {
                        if (null != _agentAddr.handler) {
                            _agentAddr.handler.snmpResponse(99, _agentAddr.ipAddress, _agentAddr.vbList, _agentAddr.clientData);
                        }
                    }
                    catch (Exception _ignored) {
                        // empty catch block
                    }
                    listener.resetRequestID();
                    continue;
                }
                listener.getDevices().put(new Integer(_agentAddr.requestID), _agentAddr);
                try {
                    _target.sendRequest();
                    _agentAddr.timestamp = System.currentTimeMillis();
                    ++this.totalRequests;
                    if (debugEverything) {
                        logger.debug((Object)("-+-+-+- sent request to " + _agentAddr.ipAddress + " request_id: " + _agentAddr.requestID));
                    }
                }
                catch (Throwable e) {
                    System.out.println("Exception in send for IP " + _agentAddr.ipAddress + "  " + e.getMessage());
                }
            }
        }
    }

    synchronized void snmpResponse(String pIpAddress, AvSnmpListener pListener) {
        int _reqID = pListener.target.getRequestID();
        AvSnmpEquipment _dev = (AvSnmpEquipment)pListener.getDevices().get(new Integer(_reqID));
        if (null != _dev) {
            if (debugEverything) {
                logger.debug((Object)("-+-+-+- recv response from " + pIpAddress + " request_id: " + _reqID));
            }
            if (_dev.ipAddress.equals(pIpAddress)) {
                pListener.getDevices().remove(new Integer(_reqID));
                try {
                    if (null != _dev.handler) {
                        _dev.handler.snmpResponse(10, pIpAddress, pListener.target.getVBList(), _dev.clientData);
                    }
                }
                catch (Throwable e) {
                    logger.warn((Object)e, e);
                }
            } else {
                System.out.println("INVALID REQUEST ID RECEIVED !!!!!!!!!!!!  [" + pIpAddress + "]   reqID " + _reqID + " EXPECTED: [" + _dev.ipAddress + "]");
                pListener.resetRequestID();
                System.err.println("Current IDs for listeners ------------- ");
                for (AvSnmpEquipment _device : pListener.getDevices().values()) {
                    System.out.println("IP Address: " + _device.ipAddress + "   RequestID: " + _device.ipAddress);
                }
            }
            this.notify();
            ++this.totalResponses;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("NOT Found !!!!!!!! -- LATE response from " + pIpAddress + "   reqID " + _reqID));
            }
            ++this.totalLate;
        }
    }

    synchronized void checkAllTimestamps() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            this.checkTimestamps(((AvSnmpListener)it.next()).getDevices().values());
        }
        this.notify();
    }

    private void checkTimestamps(Collection pDevices) {
        long currentTime = System.currentTimeMillis();
        Iterator it = pDevices.iterator();
        while (it.hasNext()) {
            AvSnmpEquipment dev = (AvSnmpEquipment)it.next();
            if (currentTime - dev.timestamp <= (long)dev.timeout) continue;
            it.remove();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TIMEOUT: " + dev.ipAddress + "  requestID = " + dev.requestID + "  retries: " + dev.retries));
            }
            if (dev.retries > 0) {
                --dev.retries;
                this.addRequest(dev, false);
                ++this.totalRetries;
                continue;
            }
            if (null != dev.handler) {
                dev.handler.snmpResponse(11, dev.ipAddress, dev.vbList, dev.clientData);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TIMEOUT and RETRIES expired: NO Response from " + dev.ipAddress));
            }
            ++this.totalTimeouts;
        }
    }

    private static class AvSnmpRequestTimer
    extends Thread {
        AvSnmpRequestor requestor;
        int interval = 1000;

        AvSnmpRequestTimer(AvSnmpRequestor pRequestor, int pInterval) {
            this.requestor = pRequestor;
            this.interval = pInterval;
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException _ie) {
                    // empty catch block
                }
                try {
                    this.requestor.checkAllTimestamps();
                    continue;
                }
                catch (Exception _e) {
                    _e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private static class AvSnmpListener
    extends Thread {
        SRSnmpSession target = new SRSnmpSession();
        AvSnmpRequestor requestor;
        TreeMap devices;
        int requestID;

        public AvSnmpListener(AvSnmpRequestor pRequestor) {
            this.target.setTimeout(1);
            this.target.setRequestID(0);
            this.requestor = pRequestor;
            this.devices = new TreeMap();
            this.setDaemon(true);
        }

        public SRSnmpSession getTarget() {
            return this.target;
        }

        public TreeMap getDevices() {
            return this.devices;
        }

        int getSize() {
            return this.devices.size();
        }

        public int nextRequestID() {
            return this.requestID++;
        }

        public void resetRequestID() {
            this.requestID += 10000 + (int)(100000.0 * Math.random());
            this.target.setRequestID(this.requestID);
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        String _agentAddr = null;
                        while (null == _agentAddr) {
                            _agentAddr = this.target.getResponse();
                        }
                        this.requestor.snmpResponse(_agentAddr, this);
                    }
                }
                catch (Exception _e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(new Date().toString() + " " + _e.getMessage()));
                    continue;
                }
                break;
            }
        }
    }
}

