/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation.snmp;

import com.dorado.common.utility.OWAppServerUtility;
import com.dorado.core.ejb.ruleengine.OWRuleEngineClient;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.core.mediation.snmp.OWVarBindList;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWInvalidTypeException;
import com.dorado.runtime.OWRuleException;
import com.dorado.runtime.OWSet;
import com.ngnms.common.AvTrace;
import com.ngnms.mediation.snmp.AvSnmpBatchResponseRuleParamSet;
import com.ngnms.mediation.snmp.AvSnmpMediationRequest;
import com.ngnms.mediation.snmp.IAvSnmpResponseHandler;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class AvSnmpMediationHandler
implements IAvSnmpResponseHandler {
    private static Logger logger = Logger.getLogger(AvSnmpMediationHandler.class);
    String clbkRuleName;
    Serializable clientData;
    private int totalRequestCount = -1;
    private int responseCount = 0;
    private int errorRespCounter = 0;
    private int timeoutRespCounter = 0;
    OWSet responses = new OWSet(AvSnmpMediationRequest.class);

    public AvSnmpMediationHandler(String pClbkRuleName, Serializable pClientData) {
        this.clbkRuleName = pClbkRuleName;
        this.clientData = pClientData;
    }

    public AvSnmpMediationHandler(String pClbkRuleName, Serializable pClientData, int pRequestCount) {
        this.clbkRuleName = pClbkRuleName;
        this.totalRequestCount = pRequestCount;
        this.clientData = pClientData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpResponse(int pStatus, String pIpAddress, OWVarBindList pVBList, Object pClientData) {
        AvSnmpMediationRequest req = (AvSnmpMediationRequest)pClientData;
        req.status = pStatus;
        req.timestamp = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("snmpResponse() from " + pIpAddress + "  myStatus: " + pStatus + "  VBList status: " + pVBList.getErrorStatus()));
        }
        AvSnmpMediationHandler avSnmpMediationHandler = this;
        synchronized (avSnmpMediationHandler) {
            try {
                req.setVBList(pVBList);
                this.responses.add((Serializable)req);
            }
            catch (OWInvalidTypeException _ite) {
                _ite.printStackTrace();
            }
            ++this.responseCount;
            if (11 == pStatus) {
                ++this.timeoutRespCounter;
            } else if (99 == pStatus) {
                ++this.errorRespCounter;
            }
            if (this.responseCount == this.totalRequestCount) {
                logger.debug((Object)("TOTAL responses: " + this.responseCount + "   where timeouts: " + this.timeoutRespCounter + ",  errors: " + this.errorRespCounter));
                if (null != this.clbkRuleName) {
                    this.notifyListeners();
                } else {
                    this.notify();
                }
            }
        }
    }

    public synchronized boolean setRequestCount(int pRequestCount) {
        this.totalRequestCount = pRequestCount;
        if (this.totalRequestCount == this.responseCount) {
            logger.debug((Object)("TOTAL responses: " + this.responseCount + "   where timeouts: " + this.timeoutRespCounter + ",  errors: " + this.errorRespCounter));
            if (null != this.clbkRuleName) {
                this.notifyListeners();
            } else {
                return false;
            }
        }
        return true;
    }

    public OWSet getResponses() {
        return this.responses;
    }

    private void notifyListeners() {
        AvTrace.traceln("AvSMS", 3, "Inside NotifyListeners() - totalRequestCount: " + this.totalRequestCount);
        try {
            AvSnmpBatchResponseRuleParamSet ps = new AvSnmpBatchResponseRuleParamSet();
            ps.setClientData(this.clientData);
            ps.setDevicesResponses(this.responses);
            ps.set_OW_RuleName(this.clbkRuleName);
            OWRuleEngineClient serverRE = new OWRuleEngineClient(OWAppServerUtility.getExternalPartitionName());
            serverRE.execRuleAsync((IOWEvent)ps);
        }
        catch (OWRuleEngineException _ree) {
            AvTrace.traceStack("AvSMS", 1, (Exception)((Object)_ree));
        }
        catch (OWRuleException _re) {
            AvTrace.traceStack("AvSMS", 1, (Exception)((Object)_re));
        }
    }
}

