/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation.snmp;

import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.core.mediation.snmp.OWVarBindList;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.dorado.runtime.OWSet;
import com.ngnms.mediation.snmp.AvSnmpBatchRequestRule;
import com.ngnms.mediation.snmp.AvSnmpBatchRequestRuleParamSet;
import com.ngnms.mediation.snmp.AvSnmpEquipment;
import com.ngnms.mediation.snmp.AvSnmpMediationAuth;
import com.ngnms.mediation.snmp.AvSnmpMediationHandler;
import com.ngnms.mediation.snmp.AvSnmpMediationRequest;
import com.ngnms.mediation.snmp.AvSnmpRequestor;
import org.apache.log4j.Logger;

public class AvSnmpBatchRequestRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvSnmpBatchRequestRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        this.runRule((AvSnmpBatchRequestRuleParamSet)event);
    }

    public void runRule(AvSnmpBatchRequestRuleParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        log4j.debug((Object)"Inside AvSnmpBatchRequestRule. ");
        AvSnmpMediationHandler handler = new AvSnmpMediationHandler(pParamSet.getBatchClbkRuleName(), pParamSet.getClientData());
        OWSet _resp = AvSnmpBatchRequestRuleImpl.performSnmpRequests(handler, pParamSet.getCommonRequest(), pParamSet.getDevicesRequests(), pParamSet.getBatchClbkRuleName());
        if (null != _resp) {
            pParamSet.setDevicesRequests(_resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OWSet performSnmpRequests(AvSnmpMediationHandler handler, AvSnmpMediationRequest commonRequest, OWSet devicesRequests, String batchClbkRuleName) {
        OWSet _result = null;
        int _requestCount = 0;
        for (AvSnmpMediationRequest req : devicesRequests) {
            OWVarBindList _vbList;
            AvSnmpMediationAuth auth = req.getAuth();
            if (null == auth) {
                if (null != commonRequest) {
                    auth = commonRequest.getAuth();
                } else {
                    log4j.debug((Object)"Invalid request - no auth found.");
                    continue;
                }
            }
            if (null == (_vbList = req.getVBList())) {
                if (null != commonRequest) {
                    _vbList = commonRequest.getVBList();
                } else {
                    log4j.debug((Object)"Invalid request - no VB list found.");
                    continue;
                }
            }
            AvSnmpEquipment snmpeq = new AvSnmpEquipment(auth.getIPAddress(), auth.getPort(), auth.getCommunity(), req.getOperation(), _vbList, handler, auth.getTimeout(), auth.getRetries(), req);
            AvSnmpRequestor.newRequest(snmpeq);
            ++_requestCount;
        }
        log4j.debug((Object)("AvSnmpBatchRequestRule - Request count: " + _requestCount));
        if (null != batchClbkRuleName) {
            handler.setRequestCount(_requestCount);
        } else {
            AvSnmpMediationHandler avSnmpMediationHandler = handler;
            synchronized (avSnmpMediationHandler) {
                if (handler.setRequestCount(_requestCount)) {
                    log4j.debug((Object)"Pending requests. Will wait...");
                    try {
                        handler.wait();
                        log4j.debug((Object)"Was NOTIFIED!");
                    }
                    catch (InterruptedException e) {
                        log4j.debug((Object)"Was INTERRUPTED!");
                    }
                } else {
                    log4j.debug((Object)"Responses already received.");
                }
            }
            _result = handler.getResponses();
        }
        return _result;
    }
}

