/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation.filetransfer;

import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.common.AvTrace;
import com.ngnms.mediation.filetransfer.AvFileTransferChunk;
import com.ngnms.mediation.filetransfer.AvFileTransferUtil;
import com.ngnms.mediation.filetransfer.AvGetServerFileRule;
import com.ngnms.mediation.filetransfer.AvGetServerFileRuleParamSet;
import java.io.File;
import org.apache.log4j.Logger;

public class AvGetServerFileRuleImpl
extends BaseRuleImpl {
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.mediation.filetransfer.debug");
    private static final Logger log4j = Logger.getLogger(AvGetServerFileRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvGetServerFileRule.run()");
        this.runRule((AvGetServerFileRuleParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvGetServerFileRule.run()");
    }

    public void runRule(AvGetServerFileRuleParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        if (debugOn) {
            System.out.println("In AvGetServerFileRule");
        }
        String fileName = pParamSet.getServerFileName();
        long startPosition = pParamSet.getStartPosition();
        int maxLength = pParamSet.getMaxLength();
        if (debugOn) {
            System.out.println("In AvGetServerFileRule - fileChunk for " + fileName + "  startPosition: " + startPosition + "  maxLength: " + maxLength);
        }
        String localFileName = new File(new File(AvFileTransferUtil.FILETRANSFER_ROOT), fileName).getAbsolutePath();
        if (debugOn) {
            System.out.println("In AvGetServerFileRule - localFile: " + localFileName);
        }
        pParamSet.setFileChunk(new AvFileTransferChunk(localFileName, startPosition, maxLength));
    }
}

