/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.mediation.filetransfer;

import com.dorado.common.utility.OWAppServerUtility;
import com.dorado.core.ejb.ruleengine.OWRuleEngineClient;
import com.dorado.runtime.IOWEvent;
import com.ngnms.mediation.filetransfer.AvFileTransferChunk;
import com.ngnms.mediation.filetransfer.AvGetServerFileRuleParamSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public class AvFileTransferUtil {
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.mediation.filetransfer.debug");
    public static final String FILETRANSFER_ROOT_PROP_NAME = "com.ngnms.mediation.filetransfer.root";
    public static String DEFAULT_ROOT_DIR = System.getProperty("oware.user.root") + "/firmware";
    public static String FILETRANSFER_ROOT = System.getProperty("com.ngnms.mediation.filetransfer.root", DEFAULT_ROOT_DIR);
    private static final String DEFAULT_LOCAL_PREFIX = "_ft.";
    private static Hashtable cachedFiles = new Hashtable();

    private static void cleanupLocalFiles() {
        block3: {
            System.out.println("DEFAULT_ROOT_DIR: " + DEFAULT_ROOT_DIR);
            System.out.println("FILETRANSFER_ROOT: " + FILETRANSFER_ROOT);
            try {
                File _rootDir = new File(FILETRANSFER_ROOT);
                File[] _tmpFiles = _rootDir.listFiles(new FilenameFilter(){

                    public boolean accept(File pDir, String pName) {
                        return pName.startsWith(AvFileTransferUtil.DEFAULT_LOCAL_PREFIX);
                    }
                });
                for (int i = 0; i < _tmpFiles.length; ++i) {
                    _tmpFiles[i].delete();
                }
            }
            catch (Exception _e) {
                if (!debugOn) break block3;
                _e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkLocalFile(String pRelativeLocalFilePath) {
        File _f;
        String fileName = (String)cachedFiles.get(pRelativeLocalFilePath);
        if (null != fileName && !(_f = new File(fileName)).exists()) {
            fileName = null;
            cachedFiles.remove(pRelativeLocalFilePath);
        }
        if (null == fileName) {
            Hashtable hashtable = cachedFiles;
            synchronized (hashtable) {
                fileName = (String)cachedFiles.get(pRelativeLocalFilePath);
                if (null == fileName) {
                    File tmpFile;
                    boolean bSuccess;
                    block19: {
                        OutputStream os;
                        block18: {
                            bSuccess = true;
                            tmpFile = null;
                            os = null;
                            try {
                                tmpFile = File.createTempFile(DEFAULT_LOCAL_PREFIX, null, new File(FILETRANSFER_ROOT));
                                os = new FileOutputStream(tmpFile);
                                OWRuleEngineClient ruleEngClient = new OWRuleEngineClient(OWAppServerUtility.getExternalPartitionName());
                                int maxLength = 0x100000;
                                long startPosition = 0L;
                                int dataLength = 0;
                                do {
                                    AvGetServerFileRuleParamSet ps = new AvGetServerFileRuleParamSet();
                                    ps.setServerFileName(pRelativeLocalFilePath);
                                    ps.setStartPosition(startPosition);
                                    ps.setMaxLength(maxLength);
                                    ps.set_OW_RuleName("com.ngnms.mediation.filetransfer.AvGetServerFileRule");
                                    ruleEngClient.callRule((IOWEvent)ps);
                                    AvFileTransferChunk _fileChunk = ps.getFileChunk();
                                    if (null != _fileChunk.getException()) {
                                        throw new IOException(_fileChunk.getException().getMessage());
                                    }
                                    byte[] data = _fileChunk.getData();
                                    dataLength = _fileChunk.getDataLength();
                                    if (debugOn) {
                                        System.out.println("FileTransfer: --- Read new Chunk of size " + dataLength);
                                    }
                                    if (dataLength > 0) {
                                        os.write(data, 0, dataLength);
                                    }
                                    startPosition = _fileChunk.getStartPosition() + (long)dataLength;
                                } while (dataLength == maxLength);
                            }
                            catch (IOException _ioe) {
                                bSuccess = false;
                                if (debugOn) {
                                    System.out.println("FileTransfer: " + _ioe.getMessage());
                                }
                            }
                            catch (Exception _e) {
                                bSuccess = false;
                                if (!debugOn) break block18;
                                System.out.println("FileTransfer:");
                                _e.printStackTrace();
                            }
                        }
                        if (null != os) {
                            try {
                                os.close();
                            }
                            catch (IOException _ioe) {
                                bSuccess = false;
                                if (!debugOn) break block19;
                                System.out.println("FileTransfer: " + _ioe.getMessage());
                            }
                        }
                    }
                    if (bSuccess) {
                        fileName = tmpFile.getAbsolutePath();
                        cachedFiles.put(pRelativeLocalFilePath, fileName);
                    }
                }
            }
        }
        return fileName;
    }

    static {
        AvFileTransferUtil.cleanupLocalFiles();
    }
}

